/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig;

import com.intellij.application.options.CodeStyle;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.ec4j.core.ResourceProperties;
import org.ec4j.core.model.Property;
import org.editorconfig.EditorConfigNotifier;
import org.editorconfig.EditorConfigRegistry;
import org.editorconfig.configmanagement.ConfigEncodingCharsetUtil;
import org.editorconfig.plugincomponents.EditorConfigPropertiesService;
import org.editorconfig.settings.EditorConfigSettings;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0019\u001a\u00020\u0005*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0005J\u0012\u0010\u001c\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0006\u0010!\u001a\u00020\rJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\rH\u0007J*\u0010%\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 2\b\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010'\u001a\u00020\u00052\b\u0010(\u001a\u0004\u0018\u00010\u0005J\u0018\u0010)\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0011J\u0010\u0010+\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0007J\u000e\u0010,\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 J\b\u0010-\u001a\u00020\u0005H\u0002J\b\u0010.\u001a\u00020\u0005H\u0002J\r\u0010/\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u00100J\u0010\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u001eH\u0002J\u0010\u00103\u001a\u0004\u0018\u00010\u00052\u0006\u00104\u001a\u00020\u0005J\u0010\u00105\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u00106\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001f\u001a\u00020 J\u000e\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u000209J\u0018\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020<H\u0002J,\u0010>\u001a\u00020#2\n\u0010?\u001a\u00060@j\u0002`A2\u0006\u0010B\u001a\u00020\u00052\u0006\u0010C\u001a\u00020<2\u0006\u0010D\u001a\u00020\u0005H\u0002J\u000e\u0010E\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020HH\u0002J\u001a\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\f\u0010J\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010J\u000e\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020\u0011J\u0010\u0010M\u001a\u00020\r2\b\u0010N\u001a\u0004\u0018\u00010\u0005J\u000e\u0010O\u001a\u00020\r2\u0006\u0010L\u001a\u00020\u0011J\u0016\u0010P\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010L\u001a\u00020\u0011J(\u0010Q\u001a\u0014\u0012\u0004\u0012\u00020\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u00100R2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010*\u001a\u00020\u0011J\u0014\u0010S\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010T\u001a\u00020\u0011J\u000e\u0010U\u001a\u00020\r2\u0006\u0010*\u001a\u00020VJ\u000e\u0010W\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R-\u0010\u000e\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0011 \u0012*\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\u00100\u000f\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0015\u0010\u0003\u001a\u0004\b\u0014\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006X"}, d2={"Lorg/editorconfig/Utils;", "", "<init>", "()V", "EDITOR_CONFIG_NAME", "", "EDITOR_CONFIG_FILE_NAME", "FULL_SETTINGS_SUPPORT_REG_KEY", "PLUGIN_ID", "UNSET_VALUES", "", "[Ljava/lang/String;", "ourIsFullSettingsSupportEnabledInTest", "", "EDITOR_CONFIGS", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isEnabledInTests", "isEnabledInTests$annotations", "()Z", "setEnabledInTests", "(Z)V", "configValueForKey", "Lorg/ec4j/core/ResourceProperties;", "key", "isEnabled", "currentSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "project", "Lcom/intellij/openapi/project/Project;", "isFullIntellijSettingsSupport", "setFullIntellijSettingsSupportEnabledInTest", "", "enabled", "invalidConfigMessage", "configValue", "configKey", "filePath", "getFilePath", "file", "exportToString", "export", "getEndOfFileLine", "getTrailingSpacesLine", "getTrimTrailingSpaces", "()Ljava/lang/Boolean;", "getLineEndings", "settings", "getLineSeparatorString", "separator", "getEncodingLine", "getEncoding", "buildPattern", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "equalIndents", "a", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "b", "addIndentOptions", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "pattern", "options", "additionalText", "editorConfigExists", "containsEditorConfig", "dir", "Ljava/io/File;", "pathsToFiles", "paths", "isApplicableTo", "virtualFile", "isEditorConfigName", "name", "isEditorConfigFile", "isEnabledFor", "processEditorConfig", "Lkotlin/Pair;", "relatedEditorConfigFiles", "vCodeFile", "hasEditorConfig", "Lcom/intellij/psi/PsiFile;", "fireEditorConfigChanged", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/editorconfig/Utils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n1#2:282\n1#2:299\n1342#3,2:283\n1276#3,2:286\n23#4:285\n23#4:302\n23#4:303\n60#4,5:304\n23#4:309\n1642#5,10:288\n1915#5:298\n1916#5:300\n1652#5:301\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/editorconfig/Utils\n*L\n235#1:299\n117#1:283,2\n228#1:286,2\n128#1:285\n261#1:302\n263#1:303\n263#1:304,5\n142#1:309\n235#1:288,10\n235#1:298\n235#1:300\n235#1:301\n*E\n"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();
    @NotNull
    public static final String EDITOR_CONFIG_NAME = "EditorConfig";
    @NotNull
    public static final String EDITOR_CONFIG_FILE_NAME = ".editorconfig";
    @NotNull
    private static final String FULL_SETTINGS_SUPPORT_REG_KEY = "editor.config.full.settings.support";
    @NotNull
    public static final String PLUGIN_ID = "org.editorconfig.editorconfigjetbrains";
    @NotNull
    private static final String[] UNSET_VALUES;
    private static boolean ourIsFullSettingsSupportEnabledInTest;
    @NotNull
    private static final Key<List<VirtualFile>> EDITOR_CONFIGS;
    @TestOnly
    private static boolean isEnabledInTests;

    private Utils() {
    }

    public static final boolean isEnabledInTests() {
        return isEnabledInTests;
    }

    public static final void setEnabledInTests(boolean bl) {
        isEnabledInTests = bl;
    }

    @JvmStatic
    public static /* synthetic */ void isEnabledInTests$annotations() {
    }

    @NotNull
    public final String configValueForKey(@NotNull ResourceProperties $this$configValueForKey, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$configValueForKey, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Property property = $this$configValueForKey.getProperties().get(key);
        if (property == null) {
            return "";
        }
        Property prop = property;
        String string = prop.getSourceValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSourceValue(...)");
        String value = ((Object)StringsKt.trim((CharSequence)string)).toString();
        return ArraysKt.contains((Object[])UNSET_VALUES, (Object)value) ? "" : value;
    }

    @JvmStatic
    public static final boolean isEnabled(@Nullable CodeStyleSettings currentSettings) {
        EditorConfigSettings editorConfigSettings;
        return currentSettings != null && (editorConfigSettings = (EditorConfigSettings)currentSettings.getCustomSettingsIfCreated(EditorConfigSettings.class)) != null ? editorConfigSettings.ENABLED : false;
    }

    @JvmStatic
    public static final boolean isEnabled(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Utils.isEnabled(CodeStyle.getSettings((Project)project));
    }

    public final boolean isFullIntellijSettingsSupport() {
        return ourIsFullSettingsSupportEnabledInTest || Registry.Companion.is(FULL_SETTINGS_SUPPORT_REG_KEY);
    }

    @JvmStatic
    @TestOnly
    public static final void setFullIntellijSettingsSupportEnabledInTest(boolean enabled) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ourIsFullSettingsSupportEnabledInTest = enabled;
        }
    }

    public final void invalidConfigMessage(@NotNull Project project, @Nullable String configValue, @NotNull String configKey, @Nullable String filePath) {
        String string;
        String message;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configKey, (String)"configKey");
        if (configValue != null) {
            CharSequence charSequence;
            EditorConfigBundle editorConfigBundle = EditorConfigBundle.INSTANCE;
            String string2 = "invalid.config.value";
            Object[] objectArray = new Object[3];
            objectArray[0] = configValue;
            Object[] objectArray2 = objectArray;
            int n = 1;
            CharSequence charSequence2 = configKey;
            if (charSequence2.length() == 0) {
                int n2 = n;
                Object[] objectArray3 = objectArray2;
                String string3 = string2;
                EditorConfigBundle editorConfigBundle2 = editorConfigBundle;
                boolean bl = false;
                String string4 = "?";
                editorConfigBundle = editorConfigBundle2;
                string2 = string3;
                objectArray2 = objectArray3;
                n = n2;
                charSequence = string4;
            } else {
                charSequence = charSequence2;
            }
            objectArray2[n] = charSequence;
            objectArray[2] = filePath;
            v5 = editorConfigBundle.messageOrDefault(string2, objectArray);
        } else {
            v5 = message = EditorConfigBundle.message((String)"read.failure");
        }
        if ((string = configValue) == null) {
            string = "ioError";
        }
        EditorConfigNotifier.error(project, string, message);
    }

    @Nullable
    public final String getFilePath(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return !file.isInLocalFileSystem() ? project.getBasePath() + "/" + file.getNameWithoutExtension() + "." + file.getFileType().getDefaultExtension() : file.getCanonicalPath();
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final String exportToString(@NotNull Project project) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)codeStyleSettings, (String)"getSettings(...)");
        CodeStyleSettings settings = codeStyleSettings;
        CommonCodeStyleSettings.IndentOptions indentOptions = settings.getIndentOptions();
        Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"getIndentOptions(...)");
        CommonCodeStyleSettings.IndentOptions commonIndentOptions = indentOptions;
        StringBuilder result2 = new StringBuilder();
        INSTANCE.addIndentOptions(result2, "*", commonIndentOptions, INSTANCE.getEncodingLine(project) + INSTANCE.getLineEndings(settings) + INSTANCE.getTrailingSpacesLine() + INSTANCE.getEndOfFileLine());
        FileType[] fileTypeArray = FileTypeManager.getInstance().getRegisteredFileTypes();
        Intrinsics.checkNotNullExpressionValue((Object)fileTypeArray, (String)"getRegisteredFileTypes(...)");
        Sequence sequence = SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])fileTypeArray), arg_0 -> Utils.exportToString$lambda$0(project, arg_0));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommonCodeStyleSettings.IndentOptions options;
            FileType fileType = (FileType)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)settings.getIndentOptions(fileType), (String)"getIndentOptions(...)");
            if (INSTANCE.equalIndents(commonIndentOptions, options)) continue;
            Intrinsics.checkNotNull((Object)fileType);
            INSTANCE.addIndentOptions(result2, INSTANCE.buildPattern(fileType), options, "");
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final void export(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = project.getBaseDir();
        if (virtualFile == null) {
            Utils $this$export_u24lambda_u240 = this;
            boolean bl = false;
            Utils $this$thisLogger$iv = $this$export_u24lambda_u240;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Utils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug("Cannot export .editorconfig from the default project");
            return;
        }
        VirtualFile baseDir = virtualFile;
        VirtualFile virtualFile2 = baseDir.findChild(EDITOR_CONFIG_FILE_NAME);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            String string = baseDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String message = EditorConfigBundle.message((String)"dialog.message.editorconfig.already.present.in.overwrite", (String)string);
            String title = EditorConfigBundle.message((String)"dialog.title.editorconfig.exists");
            if (Messages.showYesNoDialog((Project)project, (String)message, (String)title, null) == 1) {
                return;
            }
        }
        ApplicationManager.getApplication().runWriteAction(() -> Utils.export$lambda$2(baseDir, project));
    }

    private final String getEndOfFileLine() {
        return "insert_final_newline=" + EditorSettingsExternalizable.getInstance().isEnsureNewLineAtEOF() + "\n";
    }

    private final String getTrailingSpacesLine() {
        Object object;
        block3: {
            block2: {
                object = this.getTrimTrailingSpaces();
                if (object == null) break block2;
                boolean it = (Boolean)object;
                boolean bl = false;
                String string = "trim_trailing_whitespace=" + it + "\n";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Nullable
    public final Boolean getTrimTrailingSpaces() {
        String string = EditorSettingsExternalizable.getInstance().getStripTrailingSpaces();
        return Intrinsics.areEqual((Object)string, (Object)"None") ? Boolean.valueOf(false) : (Intrinsics.areEqual((Object)string, (Object)"Whole") ? Boolean.valueOf(true) : null);
    }

    private final String getLineEndings(CodeStyleSettings settings) {
        Object object;
        block3: {
            block2: {
                String separator = settings.getLineSeparator();
                Intrinsics.checkNotNull((Object)separator);
                object = this.getLineSeparatorString(separator);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "end_of_line=" + it + "\n";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Nullable
    public final String getLineSeparatorString(@NotNull String separator) {
        String string;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
            Iterable iterable = (Iterable)EntriesMappings.entries$0;
            for (Object t : iterable) {
                LineSeparator it = (LineSeparator)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)separator, (Object)it.getSeparatorString())) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        LineSeparator lineSeparator = v0;
        if (lineSeparator != null) {
            LineSeparator it = lineSeparator;
            boolean bl = false;
            string = StringUtil.toLowerCase((String)it.name());
        } else {
            string = null;
        }
        return string;
    }

    private final String getEncodingLine(Project project) {
        Object object;
        block3: {
            block2: {
                object = this.getEncoding(project);
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string = "charset=" + it + "\n";
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @Nullable
    public final String getEncoding(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EncodingProjectManager encodingManager = EncodingProjectManager.getInstance((Project)project);
        Charset charset = encodingManager.getDefaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getDefaultCharset(...)");
        return ConfigEncodingCharsetUtil.INSTANCE.toString(charset, encodingManager.shouldAddBOMForNewUtf8File());
    }

    @NotNull
    public final String buildPattern(@NotNull FileType fileType) {
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        List list = FileTypeManager.getInstance().getAssociations(fileType);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAssociations(...)");
        List associations = list;
        String result2 = SequencesKt.joinToString$default((Sequence)SequencesKt.sorted((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)associations), Utils::buildPattern$lambda$0)), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
        return associations.size() > 1 ? "{" + result2 + "}" : result2;
    }

    private final boolean equalIndents(CommonCodeStyleSettings.IndentOptions a, CommonCodeStyleSettings.IndentOptions b) {
        return b.USE_TAB_CHARACTER == a.USE_TAB_CHARACTER && b.TAB_SIZE == a.TAB_SIZE && b.INDENT_SIZE == a.INDENT_SIZE;
    }

    private final void addIndentOptions(StringBuilder result2, String pattern, CommonCodeStyleSettings.IndentOptions options, String additionalText) {
        StringBuilder stringBuilder;
        if (((CharSequence)pattern).length() == 0) {
            return;
        }
        StringBuilder $this$addIndentOptions_u24lambda_u240 = stringBuilder = result2;
        boolean bl = false;
        $this$addIndentOptions_u24lambda_u240.append("[").append(pattern).append("]").append("\n");
        $this$addIndentOptions_u24lambda_u240.append(additionalText);
        $this$addIndentOptions_u24lambda_u240.append("indent_style").append("=");
        if (options.USE_TAB_CHARACTER) {
            $this$addIndentOptions_u24lambda_u240.append("tab\n");
            v0 = $this$addIndentOptions_u24lambda_u240.append("tab_width").append("=").append(options.TAB_SIZE).append("\n");
        } else {
            $this$addIndentOptions_u24lambda_u240.append("space\n");
            v0 = $this$addIndentOptions_u24lambda_u240.append("indent_size").append("=").append(options.INDENT_SIZE).append("\n");
        }
        $this$addIndentOptions_u24lambda_u240.append("\n");
    }

    public final boolean editorConfigExists(@NotNull Project project) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String string = project.getBasePath();
            if (string == null) {
                return false;
            }
            File projectDir = new File(string);
            Sequence $this$any$iv = SequencesKt.flatMap((Sequence)SequencesKt.ifEmpty((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)EditorConfigPropertiesService.Companion.getInstance(project).getRootDirs()), Utils::editorConfigExists$lambda$0), Utils::editorConfigExists$lambda$1), () -> Utils.editorConfigExists$lambda$2(projectDir)), arg_0 -> Utils.editorConfigExists$lambda$3(projectDir, arg_0));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                File dir = (File)element$iv;
                boolean bl2 = false;
                if (!INSTANCE.containsEditorConfig(dir)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    private final boolean containsEditorConfig(File dir) {
        return dir.exists() && dir.isDirectory() && new File(dir, EDITOR_CONFIG_FILE_NAME).exists();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<VirtualFile> pathsToFiles(@NotNull List<String> paths) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Iterable $this$mapNotNull$iv = paths;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if (VfsUtil.findFile((Path)Paths.get(it, new String[0]), (boolean)true) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean isApplicableTo(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        VirtualFile $this$isApplicableTo_u24lambda_u240 = virtualFile;
        boolean bl = false;
        return $this$isApplicableTo_u24lambda_u240.isInLocalFileSystem() && $this$isApplicableTo_u24lambda_u240.isValid();
    }

    public final boolean isEditorConfigName(@Nullable String name) {
        return StringsKt.equals((String)EDITOR_CONFIG_FILE_NAME, (String)name, (boolean)true);
    }

    public final boolean isEditorConfigFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return this.isEditorConfigName(virtualFile.getName());
    }

    public final boolean isEnabledFor(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return Utils.isEnabled(CodeStyle.getSettings((Project)project)) && this.isApplicableTo(virtualFile) && !this.isEditorConfigFile(virtualFile) && (!ApplicationManager.getApplication().isUnitTestMode() || isEnabledInTests);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Pair<ResourceProperties, List<VirtualFile>> processEditorConfig(@NotNull Project project, @NotNull VirtualFile file) {
        void $this$debug_u24default$iv;
        boolean $i$f$thisLogger;
        Utils $this$thisLogger$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        EDITOR_CONFIGS.set((UserDataHolder)file, null);
        String filePath = this.getFilePath(project, file);
        if (filePath != null) {
            Pair<ResourceProperties, List<VirtualFile>> propertiesAndEditorConfigs = EditorConfigPropertiesService.Companion.getInstance(project).getPropertiesAndEditorConfigs(file);
            EDITOR_CONFIGS.set((UserDataHolder)file, propertiesAndEditorConfigs.getSecond());
            return propertiesAndEditorConfigs;
        }
        if (VfsUtilCore.isBrokenLink((VirtualFile)file)) {
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Utils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn(file.getPresentableUrl() + " is a broken link");
        }
        $this$thisLogger$iv = this;
        $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(Utils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        $this$thisLogger$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            void var8_9 = $this$debug_u24default$iv;
            boolean bl = false;
            var8_9.debug("null filepath for " + file.getName(), t$iv);
        }
        return new Pair((Object)new ResourceProperties.Builder().build(), (Object)CollectionsKt.emptyList());
    }

    @NotNull
    public final List<VirtualFile> relatedEditorConfigFiles(@NotNull VirtualFile vCodeFile) {
        Intrinsics.checkNotNullParameter((Object)vCodeFile, (String)"vCodeFile");
        List list = (List)EDITOR_CONFIGS.get((UserDataHolder)vCodeFile);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final boolean hasEditorConfig(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        return !((Collection)this.relatedEditorConfigFiles(virtualFile)).isEmpty();
    }

    public final void fireEditorConfigChanged(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!project.isDisposed()) {
            EditorConfigPropertiesService editorConfigPropertiesService = EditorConfigPropertiesService.Companion.getInstance(project);
            editorConfigPropertiesService.clearCache$intellij_editorconfig_backend();
            editorConfigPropertiesService.incModificationCount();
            CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
        }
    }

    private static final boolean exportToString$lambda$0(Project $project, FileType it) {
        return FileTypeIndex.containsFileOfType((FileType)it, (GlobalSearchScope)GlobalSearchScope.allScope((Project)$project));
    }

    private static final void export$lambda$2(VirtualFile $baseDir, Project $project) {
        try {
            VirtualFile virtualFile = $baseDir.findOrCreateChildData(Utils.class, EDITOR_CONFIG_FILE_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"findOrCreateChildData(...)");
            VirtualFile editorConfig = virtualFile;
            VfsUtil.saveText((VirtualFile)editorConfig, (String)Utils.exportToString($project));
        }
        catch (IOException e) {
            Utils $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(Utils.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)e);
        }
    }

    private static final String buildPattern$lambda$0(FileNameMatcher it) {
        return it.getPresentableString();
    }

    private static final File editorConfigExists$lambda$3$0(File $projectDir, File currRoot) {
        Intrinsics.checkNotNullParameter((Object)currRoot, (String)"currRoot");
        return EditorConfigRegistry.shouldStopAtProjectRoot() && FileUtil.filesEqual((File)currRoot, (File)$projectDir) ? null : currRoot.getParentFile();
    }

    private static final boolean editorConfigExists$lambda$0(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isInLocalFileSystem();
    }

    private static final File editorConfigExists$lambda$1(VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new File(it.getPath());
    }

    private static final Sequence editorConfigExists$lambda$2(File $projectDir) {
        return SequencesKt.sequenceOf((Object)$projectDir);
    }

    private static final Sequence editorConfigExists$lambda$3(File $projectDir, File rootDir) {
        Intrinsics.checkNotNullParameter((Object)rootDir, (String)"rootDir");
        return SequencesKt.generateSequence((Object)rootDir, arg_0 -> Utils.editorConfigExists$lambda$3$0($projectDir, arg_0));
    }

    static {
        String[] stringArray = new String[]{"none", "unset"};
        UNSET_VALUES = stringArray;
        Key key = Key.create((String)"EDITOR_CONFIGS");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EDITOR_CONFIGS = key;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<LineSeparator> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])LineSeparator.values()));
        }
    }
}

