/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigDescribableElement;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigOptionValueList;
import com.intellij.editorconfig.common.syntax.psi.impl.EditorConfigElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.editorconfig.language.util.EditorConfigPsiTreeUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigRemoveListValueQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.editorconfig.backend"})
public final class EditorConfigRemoveListValueQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.value.remove.description", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement element = descriptor.getPsiElement();
        PsiElement psiElement = element.getParent();
        EditorConfigOptionValueList editorConfigOptionValueList = psiElement instanceof EditorConfigOptionValueList ? (EditorConfigOptionValueList)psiElement : null;
        if (editorConfigOptionValueList == null) {
            return;
        }
        EditorConfigOptionValueList list = editorConfigOptionValueList;
        Intrinsics.checkNotNull((Object)element);
        IntRange globalRange = EditorConfigPsiTreeUtil.INSTANCE.findRemovableRange(element);
        int listOffset = list.getTextOffset();
        IntRange parentRange = new IntRange(globalRange.getStart() - listOffset, globalRange.getEndInclusive() - listOffset);
        String string = list.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence text = string;
        CharSequence newText = StringsKt.removeRange((CharSequence)text, (IntRange)parentRange);
        EditorConfigElementFactory factory = EditorConfigElementFactory.Companion.getInstance(project);
        EditorConfigDescribableElement newList = factory.createAnyValue(newText);
        CodeStyleManager manager = CodeStyleManager.getInstance((Project)project);
        manager.performActionWithFormatterDisabled(() -> EditorConfigRemoveListValueQuickFix.applyFix$lambda$0(list, newList));
    }

    private static final void applyFix$lambda$0(EditorConfigOptionValueList $list, EditorConfigDescribableElement $newList) {
        $list.replace((PsiElement)$newList);
    }
}

