/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.editor.refactoring;

import com.intellij.kotlin.jupyter.core.editor.codeInsight.NotebookGotoDeclarationProvider;
import com.intellij.kotlin.jupyter.core.editor.find.KotlinNotebookElementFindUsagesHandler;
import com.intellij.kotlin.jupyter.core.editor.refactoring.NotebookRefactoringSupport;
import com.intellij.kotlin.jupyter.core.editor.refactoring.RenamingKt;
import com.intellij.kotlin.jupyter.core.notifications.NotificationsKt;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import java.util.Collection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.decompiler.psi.file.KtClsFile;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.refactoring.rename.RenameKotlinPropertyProcessor;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtScript;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000e0\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\u0007H\u0016J&\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\b\u0010\u0019\u001a\u00020\u0012H\u0016J\u001a\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J(\u0010\u001a\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u001b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00070\u001cH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kotlin/jupyter/core/editor/refactoring/NotebookPropertyRenameProcessor;", "Lcom/intellij/refactoring/rename/RenamePsiElementProcessor;", "<init>", "()V", "goToDeclarationProvider", "Lcom/intellij/kotlin/jupyter/core/editor/codeInsight/NotebookGotoDeclarationProvider;", "tryResolveToDeclaration", "Lcom/intellij/psi/PsiElement;", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "prepareRenaming", "", "newName", "", "allRenames", "", "canProcessElement", "", "findReferences", "", "Lcom/intellij/psi/PsiReference;", "searchScope", "Lcom/intellij/psi/search/SearchScope;", "searchInCommentsAndStrings", "isInplaceRenameSupported", "substituteElementToRename", "renameCallback", "Lcom/intellij/openapi/util/Pass;", "intellij.kotlin.jupyter.core"})
public final class NotebookPropertyRenameProcessor
extends RenamePsiElementProcessor {
    @NotNull
    private final NotebookGotoDeclarationProvider goToDeclarationProvider = new NotebookGotoDeclarationProvider();

    private final PsiElement tryResolveToDeclaration(PsiElement element, Editor editor) {
        Editor editor2 = editor;
        Object[] objectArray = this.goToDeclarationProvider.getGotoDeclarationTargets(element, editor2 != null && (editor2 = editor2.getCaretModel()) != null ? editor2.getOffset() : 0, editor);
        return objectArray != null ? (PsiElement)ArraysKt.firstOrNull((Object[])objectArray) : null;
    }

    public void prepareRenaming(@NotNull PsiElement element, @NotNull String newName, @NotNull Map<PsiElement, String> allRenames) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(allRenames, (String)"allRenames");
    }

    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return false;
        }
        PsiFile containingFile = psiFile;
        VirtualFile virtualFile = containingFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile vFile = virtualFile;
        if (!IsKotlinNotebookKt.isKotlinNotebook(vFile) && !RenamingKt.isKotlinNotebookInjectedFile(containingFile)) {
            return false;
        }
        PsiNamedElement namedUnwrappedElement = LightClassUtilsKt.getNamedUnwrappedElement((PsiElement)element);
        boolean isLocalScope = RenamingKt.isFromDeclarationsLocalScope(element);
        return namedUnwrappedElement instanceof KtProperty && !isLocalScope || namedUnwrappedElement instanceof RenameKotlinPropertyProcessor.PropertyMethodWrapper || element instanceof LeafPsiElement && namedUnwrappedElement instanceof KtScript || namedUnwrappedElement != null && namedUnwrappedElement instanceof KtParameter && ((KtParameter)namedUnwrappedElement).hasValOrVar();
    }

    @NotNull
    public Collection<PsiReference> findReferences(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean searchInCommentsAndStrings) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        return new KotlinNotebookElementFindUsagesHandler(element, false, false, 6, null).findReferencesToHighlight(element, searchScope);
    }

    public boolean isInplaceRenameSupported() {
        return true;
    }

    @NotNull
    public PsiElement substituteElementToRename(@NotNull PsiElement element, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!RenamingKt.isKotlinNotebookInjectedFile(element.getContainingFile())) {
            return element;
        }
        PsiElement psiElement = this.tryResolveToDeclaration(element, editor);
        if (psiElement == null) {
            psiElement = element;
        }
        return psiElement;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void substituteElementToRename(@NotNull PsiElement element, @NotNull Editor editor, @NotNull Pass<? super PsiElement> renameCallback) {
        PsiElement adjustedElement;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter(renameCallback, (String)"renameCallback");
                if (!RenamingKt.isKotlinNotebookInjectedFile(element.getContainingFile())) {
                    return;
                }
                Object object = this.tryResolveToDeclaration(element, editor);
                if (object == null) {
                    PsiReference psiReference = element.getParent().getReference();
                    object = psiReference != null ? psiReference.resolve() : null;
                }
                if ((adjustedElement = object) == null && !NotebookRefactoringSupport.INSTANCE.isNotebookRefactoringSupported(element.getParent())) break block6;
                PsiElement psiElement = adjustedElement;
                if (!((psiElement != null ? psiElement.getContainingFile() : null) instanceof KtClsFile)) break block7;
            }
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            NotificationsKt.getNotebookNotifications(project).showBytecodeRefactoringWarning();
            return;
        }
        PsiElement parent = NotebookRefactoringSupport.INSTANCE.tryCastParentToSuitableTarget(element);
        PsiElement psiElement = adjustedElement;
        if (psiElement == null && (psiElement = parent) == null) {
            return;
        }
        PsiElement properElem = psiElement;
        renameCallback.accept((Object)properElem);
    }
}

