/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.execution;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.executor.JupyterExecutionListener;
import com.intellij.jupyter.core.executor.kernel.JupyterKernelTask;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterCellExecutionCallbackFactory;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterExecutionCallback;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.kotlin.jupyter.core.jupyter.execution.KotlinNotebookCellExecutionCallback;
import com.intellij.kotlin.jupyter.core.util.IsKotlinNotebookKt;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBus;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\bJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006R,\u0010\u0004\u001a \u0012\u0004\u0012\u00020\u0006\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/execution/KotlinNotebookCellExecutionCallbackFactory;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterCellExecutionCallbackFactory;", "<init>", "()V", "callbacksCounters", "", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Lkotlin/Pair;", "", "Ljava/util/PriorityQueue;", "executionDataLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "registerNextIndexForCallback", "file", "unregisterCallback", "", "index", "create", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterExecutionCallback;", "task", "Lcom/intellij/jupyter/core/executor/kernel/JupyterKernelTask;", "createUnboundCallback", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "intellij.kotlin.jupyter.core"})
public final class KotlinNotebookCellExecutionCallbackFactory
implements JupyterCellExecutionCallbackFactory {
    @NotNull
    private final Map<BackedNotebookVirtualFile, Pair<Integer, PriorityQueue<Integer>>> callbacksCounters;
    @NotNull
    private final ReentrantReadWriteLock executionDataLock;

    public KotlinNotebookCellExecutionCallbackFactory() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        JupyterExecutionListener.Companion.register((Disposable)messageBus, new JupyterExecutionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public Object sessionDeleted(JupyterNotebookSession session, Continuation<? super Unit> $completion) {
                void $this$withWriteLock$iv;
                ReentrantReadWriteLock reentrantReadWriteLock = executionDataLock;
                KotlinNotebookCellExecutionCallbackFactory kotlinNotebookCellExecutionCallbackFactory = this;
                boolean $i$f$withWriteLock = false;
                void var6_6 = $this$withWriteLock$iv;
                ReentrantReadWriteLock.ReadLock readLock = var6_6.readLock();
                int n = var6_6.getWriteHoldCount() == 0 ? var6_6.getReadHoldCount() : 0;
                for (int i = 0; i < n; ++i) {
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = var6_6.writeLock();
                writeLock.lock();
                try {
                    boolean bl = false;
                    boolean bl2 = false;
                    Pair pair2 = (Pair)kotlinNotebookCellExecutionCallbackFactory.callbacksCounters.remove(session.getVirtualFile());
                }
                finally {
                    for (int i = 0; i < n; ++i) {
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
                return Unit.INSTANCE;
            }
        });
        this.callbacksCounters = new LinkedHashMap();
        this.executionDataLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int registerNextIndexForCallback(BackedNotebookVirtualFile file) {
        int n;
        ReentrantReadWriteLock reentrantReadWriteLock = this.executionDataLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n2 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n2; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Pair pair2 = this.callbacksCounters.get(file);
            if (pair2 == null) {
                pair2 = TuplesKt.to((Object)0, new PriorityQueue());
            }
            Pair pair3 = pair2;
            int cnt = ((Number)pair3.component1()).intValue();
            PriorityQueue pq = (PriorityQueue)pair3.component2();
            if (pq.size() > 1 && !pq.contains(-1)) {
                pq.add(-1);
            }
            pq.add(cnt);
            this.callbacksCounters.put(file, (Pair<Integer, PriorityQueue<Integer>>)TuplesKt.to((Object)(cnt + 1), (Object)pq));
            n = cnt;
        }
        finally {
            for (int i = 0; i < n2; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterCallback(@NotNull BackedNotebookVirtualFile file, int index) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        ReentrantReadWriteLock reentrantReadWriteLock = this.executionDataLock;
        ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
        int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
        for (int i = 0; i < n; ++i) {
            readLock.unlock();
        }
        ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
        writeLock.lock();
        try {
            boolean bl = false;
            Pair<Integer, PriorityQueue<Integer>> pair2 = this.callbacksCounters.get(file);
            if (pair2 != null) {
                boolean isAfterSeriesRuns;
                PriorityQueue pq = (PriorityQueue)pair2.component2();
                pq.remove(index);
                boolean bl2 = isAfterSeriesRuns = pq.size() == 1 && pq.contains(-1);
                if (isAfterSeriesRuns) {
                    pq.remove(-1);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            for (int i = 0; i < n; ++i) {
                readLock.lock();
            }
            writeLock.unlock();
        }
    }

    @Nullable
    public JupyterExecutionCallback create(@NotNull JupyterKernelTask task) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Project project = task.getProject();
        if (project == null) {
            return null;
        }
        Project cellProject = project;
        BackedNotebookVirtualFile file = task.getNotebookVirtualFile();
        if (!IsKotlinNotebookKt.isKotlinNotebook(file.getFile())) {
            return null;
        }
        Pair jupyterPsiCellData = (Pair)ActionsKt.runReadAction(() -> KotlinNotebookCellExecutionCallbackFactory.create$lambda$0(task, cellProject));
        Pair pair2 = jupyterPsiCellData;
        if (pair2 == null || (pair2 = (JupyterPsiCell)pair2.getFirst()) == null) {
            return null;
        }
        Pair cell = pair2;
        int cellIndex = ((Number)jupyterPsiCellData.getSecond()).intValue();
        int index = this.registerNextIndexForCallback(file);
        return new KotlinNotebookCellExecutionCallback(cellProject, file, (JupyterPsiCell)cell, index, cellIndex, System.currentTimeMillis());
    }

    @NotNull
    public final JupyterExecutionCallback createUnboundCallback(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        int index = this.registerNextIndexForCallback(virtualFile);
        return new KotlinNotebookCellExecutionCallback(project, virtualFile, null, index, null, System.currentTimeMillis());
    }

    private static final Pair create$lambda$0(JupyterKernelTask $task, Project $cellProject) {
        NotebookIntervalPointer notebookIntervalPointer = $task.getOptions().getCellPointer();
        if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null) {
            return null;
        }
        int cellIndex = notebookIntervalPointer.getOrdinal();
        List list = JupyterHelper.INSTANCE.getPsiCells($cellProject, $task.getNotebookVirtualFile());
        return TuplesKt.to((Object)(list != null ? (JupyterPsiCell)CollectionsKt.getOrNull((List)list, (int)cellIndex) : null), (Object)cellIndex);
    }
}

