/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded;

import com.intellij.jupyter.core.jupyter.connections.execution.JupyterKernelCommunicationClient;
import com.intellij.jupyter.core.jupyter.connections.execution.message.JupyterMessage;
import com.intellij.jupyter.execution.kernel.JupyterKernelConnection;
import com.intellij.jupyter.execution.kernel.MessageBridgeKt;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.KernelConfigFactoryKt;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.EmbeddedJupyterSockets;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.EmbeddedKotlinKernelLoggerFactory;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.IdeReplRuntimeProperties;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.IdeaHttpClient;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.InMemoryReplResultsHolderService;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.IntellijDataProvider;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.IntellijProcessKernelRunMode;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.embedded.MessageHanderFactoryKt;
import com.intellij.kotlin.jupyter.core.settings.OptionsUtilKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.ui.EDT;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.api.KotlinKernelVersion;
import org.jetbrains.kotlinx.jupyter.api.embedded.InMemoryReplResultsHolder;
import org.jetbrains.kotlinx.jupyter.config.RuntimePropertiesKt;
import org.jetbrains.kotlinx.jupyter.libraries.DefaultResolutionInfoProviderFactory;
import org.jetbrains.kotlinx.jupyter.libraries.LibraryHttpUtilKt;
import org.jetbrains.kotlinx.jupyter.messaging.MessageHandler;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.jetbrains.kotlinx.jupyter.protocol.startup.parameters.KernelConfig;
import org.jetbrains.kotlinx.jupyter.repl.ReplConfig;
import org.jetbrains.kotlinx.jupyter.repl.config.DefaultReplSettings;
import org.jetbrains.kotlinx.jupyter.startup.parameters.KotlinKernelOwnParams;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0002J\u0010\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000eH\u0003J\u0016\u0010\u001d\u001a\u00020\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelSession;", "Lcom/intellij/jupyter/execution/kernel/JupyterKernelConnection;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterKernelCommunicationClient;", "project", "Lcom/intellij/openapi/project/Project;", "kernelConfig", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelConfig;", "Lorg/jetbrains/kotlinx/jupyter/startup/parameters/KotlinKernelOwnParams;", "sessionId", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSessionId;", "loggerFactory", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory;", "onMessage", "Lkotlin/Function1;", "Lcom/intellij/jupyter/core/jupyter/connections/execution/message/JupyterMessage;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelConfig;Ljava/lang/String;Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/embedded/EmbeddedKotlinKernelLoggerFactory;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getSessionId-PaPw8_s", "()Ljava/lang/String;", "Ljava/lang/String;", "messageHandler", "Lorg/jetbrains/kotlinx/jupyter/messaging/MessageHandler;", "send", "content", "dispose", "close", "createMessageHandler", "doSend", "runOnBackgroundThread", "action", "Lkotlin/Function0;", "intellij.kotlin.jupyter.core"})
public final class EmbeddedKotlinKernelSession
implements JupyterKernelConnection,
JupyterKernelCommunicationClient {
    @NotNull
    private final Project project;
    @NotNull
    private final KernelConfig<KotlinKernelOwnParams> kernelConfig;
    @NotNull
    private final String sessionId;
    @NotNull
    private final EmbeddedKotlinKernelLoggerFactory loggerFactory;
    @NotNull
    private final Function1<JupyterMessage, Unit> onMessage;
    @NotNull
    private final MessageHandler messageHandler;

    private EmbeddedKotlinKernelSession(Project project, KernelConfig<KotlinKernelOwnParams> kernelConfig, String sessionId, EmbeddedKotlinKernelLoggerFactory loggerFactory, Function1<? super JupyterMessage, Unit> onMessage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(kernelConfig, (String)"kernelConfig");
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter(onMessage, (String)"onMessage");
        this.project = project;
        this.kernelConfig = kernelConfig;
        this.sessionId = sessionId;
        this.loggerFactory = loggerFactory;
        this.onMessage = onMessage;
        this.messageHandler = this.createMessageHandler();
    }

    @NotNull
    public String getSessionId-PaPw8_s() {
        return this.sessionId;
    }

    public void send(@NotNull JupyterMessage content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.runOnBackgroundThread((Function0<Unit>)((Function0)() -> EmbeddedKotlinKernelSession.send$lambda$0(this, content)));
    }

    public void dispose() {
    }

    public void close() {
        Disposer.dispose((Disposable)((Disposable)this));
    }

    private final MessageHandler createMessageHandler() {
        IntellijDataProvider intellijDataProvider = new IntellijDataProvider(this.project);
        Disposer.register((Disposable)((Disposable)this), (Disposable)intellijDataProvider);
        ReplConfig replConfig = ReplConfig.Companion.create$default(ReplConfig.Companion, DefaultResolutionInfoProviderFactory.INSTANCE, this.loggerFactory, LibraryHttpUtilKt.createLibraryHttpUtil(this.loggerFactory, IdeaHttpClient.INSTANCE), new IntellijProcessKernelRunMode(intellijDataProvider), null, 16, null);
        EmbeddedJupyterSockets socketsManager = new EmbeddedJupyterSockets(this.onMessage);
        KotlinKernelVersion kotlinKernelVersion = OptionsUtilKt.getSelectedKernelVersion(this.project);
        Intrinsics.checkNotNull((Object)kotlinKernelVersion);
        KotlinKernelVersion kernelVersion2 = kotlinKernelVersion;
        Object object = KernelConfigFactoryKt.chooseJvmTargetForSnippets(this.project);
        if (object == null || (object = OptionsUtilKt.toCanonicalString(object)) == null) {
            object = RuntimePropertiesKt.getDefaultRuntimeProperties().getJvmTargetForSnippets();
        }
        Object jvmTargetForSnippets2 = object;
        IdeReplRuntimeProperties runtimeProperties = new IdeReplRuntimeProperties(kernelVersion2, (String)jvmTargetForSnippets2);
        DefaultReplSettings replSettings = new DefaultReplSettings(this.kernelConfig, replConfig, this.loggerFactory, runtimeProperties);
        InMemoryReplResultsHolderService inMemoryHolderService = InMemoryReplResultsHolderService.Companion.getInstance(this.project);
        InMemoryReplResultsHolder inMemoryResultHolder = inMemoryHolderService.getOrCreateHolder-sG23Yws(this.getSessionId-PaPw8_s(), (Disposable)this);
        return MessageHanderFactoryKt.createEmbeddedMessageHandler(this.project, replSettings, this.loggerFactory, socketsManager, inMemoryResultHolder, kernelVersion2.toMavenVersion());
    }

    @RequiresBackgroundThread
    private final void doSend(JupyterMessage content) {
        MessageBridgeKt.asRawMessage((JupyterMessage)content, (arg_0, arg_1) -> EmbeddedKotlinKernelSession.doSend$lambda$0(this, arg_0, arg_1));
    }

    private final void runOnBackgroundThread(Function0<Unit> action) {
        if (EDT.isCurrentThreadEdt()) {
            Future future = ApplicationKt.getApplication().executeOnPooledThread(() -> EmbeddedKotlinKernelSession.runOnBackgroundThread$lambda$0(action));
            Intrinsics.checkNotNull((Object)future);
        } else {
            action.invoke();
        }
    }

    private static final Unit send$lambda$0(EmbeddedKotlinKernelSession this$0, JupyterMessage $content) {
        this$0.doSend($content);
        return Unit.INSTANCE;
    }

    private static final Unit doSend$lambda$0(EmbeddedKotlinKernelSession this$0, RawMessage rawMessage, JupyterSocketType socketType) {
        Intrinsics.checkNotNullParameter((Object)rawMessage, (String)"rawMessage");
        Intrinsics.checkNotNullParameter((Object)socketType, (String)"socketType");
        this$0.messageHandler.handleMessage(socketType, rawMessage);
        return Unit.INSTANCE;
    }

    private static final void runOnBackgroundThread$lambda$0(Function0 $tmp0) {
        $tmp0.invoke();
    }

    public /* synthetic */ EmbeddedKotlinKernelSession(Project project, KernelConfig kernelConfig, String sessionId, EmbeddedKotlinKernelLoggerFactory loggerFactory, Function1 onMessage, DefaultConstructorMarker $constructor_marker) {
        this(project, (KernelConfig<KotlinKernelOwnParams>)kernelConfig, sessionId, loggerFactory, (Function1<? super JupyterMessage, Unit>)onMessage);
    }
}

