/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.outputs.error;

import com.intellij.kotlin.jupyter.core.jupyter.outputs.error.CellHighlightInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\u001a\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"cellRegex", "Lkotlin/text/Regex;", "linkifyStackLine", "Lcom/intellij/kotlin/jupyter/core/jupyter/outputs/error/CellHighlightInfo;", "line", "", "entireLength", "", "intellij.kotlin.jupyter.core"})
public final class KotlinStacktraceUtilsKt {
    @NotNull
    private static final Regex cellRegex = new Regex("at Cell In\\[(?<executionCount>\\d+)\\], (?<highlight>line (?<lineNumber>\\d+))");

    @Nullable
    public static final CellHighlightInfo linkifyStackLine(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        MatchResult matchResult = Regex.find$default((Regex)cellRegex, (CharSequence)line, (int)0, (int)2, null);
        if (matchResult == null) {
            return null;
        }
        MatchResult match = matchResult;
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"highlight");
        if (matchGroup == null) {
            return null;
        }
        MatchGroup highlightText = matchGroup;
        MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"executionCount");
        if (matchGroup2 == null) {
            return null;
        }
        MatchGroup executionCountRaw = matchGroup2;
        MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"lineNumber");
        if (matchGroup3 == null) {
            return null;
        }
        MatchGroup cellLineRaw = matchGroup3;
        Integer n = StringsKt.toIntOrNull((String)executionCountRaw.getValue());
        if (n == null) {
            return null;
        }
        int runCount = n;
        Integer n2 = StringsKt.toIntOrNull((String)cellLineRaw.getValue());
        if (n2 == null) {
            return null;
        }
        int cellLine = n2;
        IntRange range = highlightText.getRange();
        int startLine = entireLength - line.length();
        return new CellHighlightInfo(new IntRange(startLine + range.getFirst(), startLine + range.getLast() + 1), runCount, cellLine);
    }
}

