/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.scriptingSupport;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.kotlin.jupyter.core.editor.codeInsight.DeclarationUtilsKt;
import com.intellij.kotlin.jupyter.core.jupyter.cells.CellMetaDataUtilsKt;
import com.intellij.kotlin.jupyter.core.jupyter.cells.ExecutedCellData;
import com.intellij.kotlin.jupyter.core.jupyter.cells.NotebookExecutionRelatedMetaData;
import com.intellij.kotlin.jupyter.core.jupyter.cells.NotebookExecutionRelatedMetaDataKt;
import com.intellij.kotlin.jupyter.core.logging.KotlinNotebookLoggerFactory;
import com.intellij.kotlin.jupyter.core.scriptingSupport.JupyterCompilerService;
import com.intellij.kotlin.jupyter.core.scriptingSupport.NotebookClassesInCellsInfoHandler;
import com.intellij.kotlin.jupyter.core.util.ExecutedPresentCellInfo;
import com.intellij.kotlin.jupyter.core.util.NotebookPerFileChildService;
import com.intellij.kotlin.jupyter.core.util.UtilKt;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlinx.jupyter.repl.EvaluatedSnippetMetadata;
import org.jetbrains.kotlinx.jupyter.repl.SerializedScriptSource;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 A2\u00020\u00012\u00020\u0002:\u0001AB\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020%H\u0016J \u00101\u001a\n\u0012\u0004\u0012\u000203\u0018\u0001022\u0006\u00100\u001a\u00020%2\u0006\u00104\u001a\u00020%H\u0016J\u0018\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0016J\u001d\u0010;\u001a\u0002062\u0006\u0010<\u001a\u00020/2\b\u0010=\u001a\u0004\u0018\u00010#\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u000206H\u0016J\b\u0010@\u001a\u000206H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u001c\u001a\u00020\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 *\u0004\b\u001d\u0010\u001eR&\u0010!\u001a\u0014\u0012\u0004\u0012\u00020#\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0$0\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R \u0010(\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020#0)8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010'R\u0014\u0010+\u001a\u00020#8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006B"}, d2={"Lcom/intellij/kotlin/jupyter/core/scriptingSupport/NotebookStructurePerFileTracker;", "Lcom/intellij/kotlin/jupyter/core/util/NotebookPerFileChildService;", "Lcom/intellij/kotlin/jupyter/core/scriptingSupport/NotebookClassesInCellsInfoHandler;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;Lkotlinx/coroutines/CoroutineScope;)V", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "getPsiFile", "()Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "psiFile$delegate", "Lkotlin/Lazy;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getNotebook", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "injectedManager", "Lcom/intellij/lang/injection/InjectedLanguageManager;", "getInjectedManager", "()Lcom/intellij/lang/injection/InjectedLanguageManager;", "knownCellInfoDelegate", "Lkotlin/Lazy;", "Lcom/intellij/kotlin/jupyter/core/util/ExecutedPresentCellInfo;", "knownCellInfo", "getKnownCellInfo$delegate", "(Lcom/intellij/kotlin/jupyter/core/scriptingSupport/NotebookStructurePerFileTracker;)Ljava/lang/Object;", "getKnownCellInfo", "()Lcom/intellij/kotlin/jupyter/core/util/ExecutedPresentCellInfo;", "cellOrdinalToCompiledClassNames", "", "", "", "", "getCellOrdinalToCompiledClassNames", "()Ljava/util/Map;", "classNameToCellOrdinalStructure", "", "getClassNameToCellOrdinalStructure", "nextCompiledClassLineIndex", "getNextCompiledClassLineIndex", "()I", "findPsiCellByClassName", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;", "className", "findPsiDeclarationsInsideCompliedCellByName", "", "Lcom/intellij/psi/PsiElement;", "elementName", "storeCompliedDataInCell", "", "snippetMetadata", "Lorg/jetbrains/kotlinx/jupyter/repl/EvaluatedSnippetMetadata;", "executedCellData", "Lcom/intellij/kotlin/jupyter/core/jupyter/cells/ExecutedCellData;", "updateCellInformationBeforeExecution", "cell", "ordinal", "(Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterPsiCell;Ljava/lang/Integer;)V", "clearData", "dispose", "Companion", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nNotebookStructurePerFileTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookStructurePerFileTracker.kt\ncom/intellij/kotlin/jupyter/core/scriptingSupport/NotebookStructurePerFileTracker\n+ 2 DeclarationUtils.kt\ncom/intellij/kotlin/jupyter/core/editor/codeInsight/DeclarationUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 sync.kt\ncom/intellij/kotlin/jupyter/core/util/SyncKt\n+ 6 KotlinNotebookLoggerFactory.kt\ncom/intellij/kotlin/jupyter/core/logging/KotlinNotebookLoggerFactoryKt\n*L\n1#1,188:1\n67#2,4:189\n812#3,12:193\n1661#3,2:205\n1663#3:208\n1915#3,2:209\n1#4:207\n15#5,3:211\n13#6:214\n*S KotlinDebug\n*F\n+ 1 NotebookStructurePerFileTracker.kt\ncom/intellij/kotlin/jupyter/core/scriptingSupport/NotebookStructurePerFileTracker\n*L\n122#1:189,4\n122#1:193,12\n145#1:205,2\n145#1:208\n154#1:209,2\n59#1:211,3\n186#1:214\n*E\n"})
public final class NotebookStructurePerFileTracker
extends NotebookPerFileChildService
implements NotebookClassesInCellsInfoHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Lazy psiFile$delegate;
    @NotNull
    private final Lazy<ExecutedPresentCellInfo> knownCellInfoDelegate;
    @NotNull
    private static final Key<Set<String>> CELL_CLASS_NAME;
    @NotNull
    private static final Logger LOG;

    public NotebookStructurePerFileTracker(@NotNull Project project, @NotNull BackedNotebookVirtualFile virtualFile, @NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(virtualFile, scope);
        this.project = project;
        this.psiFile$delegate = LazyKt.lazy(() -> NotebookStructurePerFileTracker.psiFile_delegate$lambda$0(virtualFile, this));
        this.knownCellInfoDelegate = LazyKt.lazy(() -> NotebookStructurePerFileTracker.knownCellInfoDelegate$lambda$0(this));
    }

    private final JupyterFile getPsiFile() {
        Lazy lazy = this.psiFile$delegate;
        return (JupyterFile)lazy.getValue();
    }

    private final JupyterNotebook getNotebook() {
        return this.getVirtualFile().getNotebookOrNull();
    }

    private final InjectedLanguageManager getInjectedManager() {
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)injectedLanguageManager, (String)"getInstance(...)");
        return injectedLanguageManager;
    }

    private final ExecutedPresentCellInfo getKnownCellInfo() {
        Lazy<ExecutedPresentCellInfo> lazy = this.knownCellInfoDelegate;
        return (ExecutedPresentCellInfo)lazy.getValue();
    }

    private static Object getKnownCellInfo$delegate(NotebookStructurePerFileTracker notebookStructurePerFileTracker) {
        return notebookStructurePerFileTracker.knownCellInfoDelegate;
    }

    @Override
    @NotNull
    public Map<Integer, Set<String>> getCellOrdinalToCompiledClassNames() {
        Map map;
        Map $this$_get_cellOrdinalToCompiledClassNames__u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        JupyterNotebook jupyterNotebook = this.getNotebook();
        if (jupyterNotebook != null) {
            JupyterNotebook notebook = jupyterNotebook;
            Iterator iterator = ((Iterable)notebook.computeCells()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int index = n++;
                JupyterCell cell = (JupyterCell)iterator.next();
                NotebookExecutionRelatedMetaData notebookExecutionRelatedMetaData = NotebookExecutionRelatedMetaDataKt.getExecutionMetadata(cell);
                Set set = notebookExecutionRelatedMetaData != null ? notebookExecutionRelatedMetaData.getCompiledClasses() : null;
                if (set == null) {
                    set = SetsKt.emptySet();
                }
                Set compiledClassSet = set;
                $this$_get_cellOrdinalToCompiledClassNames__u24lambda_u240.put(index, compiledClassSet);
            }
        }
        return MapsKt.build((Map)map);
    }

    @Override
    @NotNull
    public Map<String, Integer> getClassNameToCellOrdinalStructure() {
        return this.getKnownCellInfo().getClassNameToCellOrdinal();
    }

    @Override
    public int getNextCompiledClassLineIndex() {
        int cellsCounter = JupyterCompilerService.Companion.getForFile(this.project, this.getVirtualFile()).getExecutedCellsCount() - 1;
        return cellsCounter == -1 ? 1 : cellsCounter + 1;
    }

    @Override
    @Nullable
    public JupyterPsiCell findPsiCellByClassName(@NotNull String className) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Pair pair2 = (Pair)ActionsKt.runReadAction(() -> NotebookStructurePerFileTracker.findPsiCellByClassName$lambda$0(this));
        List ktFiles = (List)pair2.component1();
        List jupyterCells = (List)pair2.component2();
        if (ktFiles.isEmpty()) {
            LOG.warn("No injected KtFiles present inside " + this.getVirtualFile().getFile().getName());
            return null;
        }
        List<JupyterPsiCell> psiCells = UtilKt.getNotebookCells((PsiFile)this.getPsiFile());
        Iterator iterator = ((Iterable)jupyterCells).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            NotebookExecutionRelatedMetaData cellExecutionRelatedData;
            Set<String> compiledClasses;
            int index = n++;
            JupyterCell cell = (JupyterCell)iterator.next();
            if (NotebookExecutionRelatedMetaDataKt.getExecutionMetadata(cell) == null || !(compiledClasses = cellExecutionRelatedData.getCompiledClasses()).contains(className)) continue;
            return (JupyterPsiCell)kotlin.collections.CollectionsKt.getOrNull(psiCells, (int)index);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Collection<PsiElement> findPsiDeclarationsInsideCompliedCellByName(@NotNull String className, @NotNull String elementName) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        JupyterPsiCell jupyterPsiCell = this.findPsiCellByClassName(className);
        if (jupyterPsiCell == null) {
            return null;
        }
        JupyterPsiCell psiCell = jupyterPsiCell;
        List<KtFile> ktFiles = UtilKt.getInjectedKtFiles((PsiLanguageInjectionHost)psiCell, this.getInjectedManager());
        Set matchedDeclarations = new LinkedHashSet();
        Iterator<KtFile> iterator = ktFiles.iterator();
        while (iterator.hasNext()) {
            void $this$filterIsInstanceTo$iv$iv$iv;
            KtFile file;
            KtFile $this$findAllDeclarationsOfType$iv = file = iterator.next();
            boolean $i$f$findAllDeclarationsOfType = false;
            Collection declarations$iv = (Collection)ActionsKt.runReadAction((Function0)((Function0)new Function0<Collection<? extends KtNamedDeclaration>>($this$findAllDeclarationsOfType$iv){
                final /* synthetic */ KtFile $this_findAllDeclarationsOfType;
                {
                    this.$this_findAllDeclarationsOfType = $receiver;
                }

                public final Collection<KtNamedDeclaration> invoke() {
                    return DeclarationUtilsKt.findAllDeclarations(this.$this_findAllDeclarationsOfType);
                }
            }));
            Iterable $this$filterIsInstance$iv$iv = declarations$iv;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv$iv : $this$filterIsInstanceTo$iv$iv$iv) {
                if (!(element$iv$iv$iv instanceof KtNamedDeclaration)) continue;
                destination$iv$iv$iv.add(element$iv$iv$iv);
            }
            Collection declarations2 = (List)destination$iv$iv$iv;
            for (KtNamedDeclaration declaration : declarations2) {
                Name name = declaration.getNameAsName();
                String string = name != null ? name.getIdentifier() : null;
                if (string == null) {
                    string = "";
                }
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)elementName, (boolean)false, (int)2, null)) continue;
                matchedDeclarations.add(declaration);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void storeCompliedDataInCell(@NotNull EvaluatedSnippetMetadata snippetMetadata, @NotNull ExecutedCellData executedCellData) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)snippetMetadata, (String)"snippetMetadata");
        Intrinsics.checkNotNullParameter((Object)executedCellData, (String)"executedCellData");
        Map<String, Integer> classNamesToCellOrdinal = this.getClassNameToCellOrdinalStructure();
        Iterable iterable = snippetMetadata.getCompiledData().getSources();
        Collection collection = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            SerializedScriptSource serializedScriptSource = (SerializedScriptSource)item$iv;
            void var14_18 = destination$iv;
            boolean bl = false;
            String f = StringsKt.substringBefore$default((String)it.getFileName(), (String)".kts", null, (int)2, null);
            boolean bl2 = false;
            var14_18.add(f + "_jupyter");
        }
        Set compiledClassNames = (Set)destination$iv;
        if (compiledClassNames.isEmpty()) {
            return;
        }
        JupyterPsiCell psiCell = executedCellData.getPsiCell();
        int cellIndex = executedCellData.getCellIndex();
        JupyterNotebook jupyterNotebook = this.getNotebook();
        if (jupyterNotebook == null || (jupyterNotebook = jupyterNotebook.getCell(cellIndex)) == null) {
            return;
        }
        JupyterNotebook notebookCell = jupyterNotebook;
        if (cellIndex != -1) {
            Iterable $this$forEach$iv = compiledClassNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                classNamesToCellOrdinal.put(it, cellIndex);
            }
        }
        NotebookStructurePerFileTracker.storeCompliedDataInCell$storeReferenceInfo(psiCell, compiledClassNames);
        try {
            NotebookExecutionRelatedMetaData.Companion.storeExecutionRelatedMetaData$intellij_kotlin_jupyter_core((JupyterCell)notebookCell, compiledClassNames);
        }
        catch (Exception ex) {
            LOG.warn("Exception during storing cell-related data", (Throwable)ex);
        }
    }

    public final void updateCellInformationBeforeExecution(@NotNull JupyterPsiCell cell, @Nullable Integer ordinal) {
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.getKnownCellInfo().updateInfoBeforeCellExecution(cell, ordinal, this.getNextCompiledClassLineIndex());
    }

    @Override
    public void clearData() {
        block1: {
            ExecutedPresentCellInfo executedPresentCellInfo = (ExecutedPresentCellInfo)org.jetbrains.kotlin.util.UtilKt.getValueOrNull(this.knownCellInfoDelegate);
            if (executedPresentCellInfo != null) {
                executedPresentCellInfo.clear();
            }
            JupyterNotebook jupyterNotebook = this.getNotebook();
            if (jupyterNotebook == null) break block1;
            CellMetaDataUtilsKt.clearAllCellsDataByKey(jupyterNotebook, NotebookExecutionRelatedMetaData.Companion.getDATA_KEY$intellij_kotlin_jupyter_core());
        }
    }

    @Override
    public void dispose() {
        block0: {
            ExecutedPresentCellInfo executedPresentCellInfo = (ExecutedPresentCellInfo)org.jetbrains.kotlin.util.UtilKt.getValueOrNull(this.knownCellInfoDelegate);
            if (executedPresentCellInfo == null) break block0;
            executedPresentCellInfo.clear();
        }
    }

    private static final JupyterFile psiFile_delegate$lambda$0(BackedNotebookVirtualFile $virtualFile, NotebookStructurePerFileTracker this$0) {
        Object object;
        boolean $i$f$withReadAccess = false;
        if (ApplicationManager.getApplication().isDispatchThread() || ApplicationManager.getApplication().isReadAccessAllowed()) {
            boolean bl = false;
            PsiFile psiFile = UtilKt.findPsiFile($virtualFile.getFile(), this$0.project);
            Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile");
            object = (JupyterFile)psiFile;
        } else {
            object = ReadAction.compute((ThrowableComputable)new ThrowableComputable($virtualFile, this$0){
                final /* synthetic */ BackedNotebookVirtualFile $virtualFile$inlined;
                final /* synthetic */ NotebookStructurePerFileTracker this$0;
                {
                    this.$virtualFile$inlined = backedNotebookVirtualFile;
                    this.this$0 = notebookStructurePerFileTracker;
                }

                public final T compute() {
                    boolean bl = false;
                    PsiFile psiFile = UtilKt.findPsiFile(this.$virtualFile$inlined.getFile(), NotebookStructurePerFileTracker.access$getProject$p(this.this$0));
                    Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile");
                    return (T)((JupyterFile)psiFile);
                }
            });
        }
        return (JupyterFile)object;
    }

    private static final ExecutedPresentCellInfo knownCellInfoDelegate$lambda$0(NotebookStructurePerFileTracker this$0) {
        return new ExecutedPresentCellInfo(this$0.getPsiFile());
    }

    private static final Pair findPsiCellByClassName$lambda$0(NotebookStructurePerFileTracker this$0) {
        return TuplesKt.to(UtilKt.getInjectedKtFiles((PsiFile)this$0.getPsiFile()), (Object)this$0.getVirtualFile().getNotebook().computeCells());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void storeCompliedDataInCell$storeReferenceInfo(JupyterPsiCell $this$storeCompliedDataInCell_u24storeReferenceInfo, Set<String> compiledClassName) {
        if ($this$storeCompliedDataInCell_u24storeReferenceInfo == null) {
            return;
        }
        JupyterPsiCell jupyterPsiCell = $this$storeCompliedDataInCell_u24storeReferenceInfo;
        synchronized (jupyterPsiCell) {
            boolean bl = false;
            Set set = (Set)$this$storeCompliedDataInCell_u24storeReferenceInfo.getUserData(CELL_CLASS_NAME);
            String last = set != null ? (String)kotlin.collections.CollectionsKt.firstOrNull((Iterable)set) : null;
            CollectionsKt.addIfNotNull((Collection)compiledClassName, (Object)last);
            $this$storeCompliedDataInCell_u24storeReferenceInfo.putUserData(CELL_CLASS_NAME, compiledClassName);
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        Key key = Key.create((String)"COMPILED_CELL_SCRIPT_CLASS_NAME");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CELL_CLASS_NAME = key;
        Companion $this$notebookLogger$iv = Companion;
        boolean $i$f$notebookLogger = false;
        LOG = KotlinNotebookLoggerFactory.INSTANCE.getInstance(Reflection.getOrCreateKotlinClass(Companion.class));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/kotlin/jupyter/core/scriptingSupport/NotebookStructurePerFileTracker$Companion;", "", "<init>", "()V", "CELL_CLASS_NAME", "Lcom/intellij/openapi/util/Key;", "", "", "getCELL_CLASS_NAME", "()Lcom/intellij/openapi/util/Key;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.kotlin.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<Set<String>> getCELL_CLASS_NAME() {
            return CELL_CLASS_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

