/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.plugins.PluginStringSetFile;
import com.intellij.ide.plugins.PluginStringSetFileKt;
import com.intellij.ide.plugins.PluginUtils;
import com.intellij.idea.AppMode;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManager;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0016\u0010\f\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\u0010\u001a\u00020\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\u0016\u0010\u0011\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016J\u0016\u0010\u0014\u001a\u00020\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ide/plugins/DisabledPluginsState;", "Lcom/intellij/ide/plugins/PluginEnabler$Headless;", "<init>", "()V", "isIgnoredDisabledPlugins", "", "setIgnoredDisabledPlugins", "", "ignoredDisabledPlugins", "isDisabled", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "enable", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "disable", "enableById", "pluginIds", "", "disableById", "Companion", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class DisabledPluginsState
implements PluginEnabler.Headless {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String DISABLED_PLUGINS_CUSTOM_FILE_PATH = System.getProperty("disabled.plugins.file.path");
    @NotNull
    public static final String DISABLED_PLUGINS_FILENAME = "disabled_plugins.txt";
    @Nullable
    private static volatile Set<PluginId> disabledPlugins;
    @NotNull
    private static final CopyOnWriteArrayList<Runnable> ourDisabledPluginListeners;
    private static volatile boolean isDisabledStateIgnored;

    @Override
    public boolean isIgnoredDisabledPlugins() {
        return isDisabledStateIgnored;
    }

    @Override
    public void setIgnoredDisabledPlugins(boolean ignoredDisabledPlugins) {
        isDisabledStateIgnored = ignoredDisabledPlugins;
    }

    @Override
    public boolean isDisabled(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return Companion.getDisabledIds().contains(pluginId);
    }

    @Override
    public boolean enable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return Companion.setEnabledState(descriptors, true);
    }

    @Override
    public boolean disable(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        return Companion.setEnabledState(descriptors, false);
    }

    @Override
    public boolean enableById(@NotNull Set<PluginId> pluginIds) {
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        return Companion.setEnabledStateForIds(pluginIds, true);
    }

    @Override
    public boolean disableById(@NotNull Set<PluginId> pluginIds) {
        Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
        return Companion.setEnabledStateForIds(pluginIds, false);
    }

    static {
        ourDisabledPluginListeners = new CopyOnWriteArrayList();
        isDisabledStateIgnored = EarlyAccessRegistryManager.INSTANCE.getBoolean("idea.ignore.disabled.plugins");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eJ\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010 \u001a\u00020\u0012J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001e\u0010#\u001a\u00020\u00102\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010'\u001a\u00020\u0010H\u0001J#\u0010#\u001a\u00020\u00102\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010'\u001a\u00020\u0010H\u0001\u00a2\u0006\u0002\b)J\u0014\u0010*\u001a\u00020\u00102\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\u001e\u0010+\u001a\u00020\u00102\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010,\u001a\u00020\u0010H\u0002J \u0010*\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u00122\u000e\b\u0002\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00050.H\u0007J\u0006\u0010,\u001a\u00020\u001bJ\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u00100\u001a\u00020\u0005H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0003\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00061"}, d2={"Lcom/intellij/ide/plugins/DisabledPluginsState$Companion;", "", "<init>", "()V", "DISABLED_PLUGINS_CUSTOM_FILE_PATH", "", "kotlin.jvm.PlatformType", "DISABLED_PLUGINS_FILENAME", "Lorg/jetbrains/annotations/NonNls;", "disabledPlugins", "", "Lcom/intellij/openapi/extensions/PluginId;", "ourDisabledPluginListeners", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Ljava/lang/Runnable;", "isDisabledStateIgnored", "", "defaultFilePath", "Ljava/nio/file/Path;", "getDefaultFilePath", "()Ljava/nio/file/Path;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "addDisablePluginListener", "", "listener", "removeDisablePluginListener", "getRequiredPlugins", "loadDisabledPlugins", "path", "getSuppressedPluginsSet", "getDisabledIds", "setEnabledState", "descriptors", "", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "enabled", "pluginIds", "setEnabledStateForIds", "saveDisabledPluginsAndInvalidate", "trySaveDisabledPlugins", "invalidate", "configPath", "", "splitByComma", "key", "intellij.platform.core.impl"})
    @SourceDebugExtension(value={"SMAP\nDisabledPluginsState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisabledPluginsState.kt\ncom/intellij/ide/plugins/DisabledPluginsState$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,205:1\n777#2:206\n873#2,2:207\n1#3:209\n*S KotlinDebug\n*F\n+ 1 DisabledPluginsState.kt\ncom/intellij/ide/plugins/DisabledPluginsState$Companion\n*L\n93#1:206\n93#1:207,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getDefaultFilePath() {
            if (DISABLED_PLUGINS_CUSTOM_FILE_PATH != null) {
                Path path = Paths.get(DISABLED_PLUGINS_CUSTOM_FILE_PATH, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                return path;
            }
            Path path = PathManager.getConfigDir().resolve(DisabledPluginsState.DISABLED_PLUGINS_FILENAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        private final Logger getLogger() {
            Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.DisabledPluginsState");
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            return logger;
        }

        private static /* synthetic */ void getLogger$annotations() {
        }

        public final void addDisablePluginListener(@NotNull Runnable listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            ourDisabledPluginListeners.add(listener);
        }

        public final void removeDisablePluginListener(@NotNull Runnable listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            ourDisabledPluginListeners.remove(listener);
        }

        @NotNull
        public final Set<PluginId> getRequiredPlugins() {
            return this.splitByComma("idea.required.plugins.id");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Set<PluginId> loadDisabledPlugins(@NotNull Path path) {
            Set<PluginId> suppressedPluginsSet;
            Set<PluginId> suppressedPluginIds;
            Set<PluginId> pluginIdsFromFile;
            boolean updateFile;
            Set<PluginId> requiredPlugins;
            LinkedHashSet<PluginId> disabledPlugins;
            block9: {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                disabledPlugins = new LinkedHashSet<PluginId>();
                requiredPlugins = this.getRequiredPlugins();
                updateFile = false;
                pluginIdsFromFile = PluginStringSetFile.INSTANCE.readIdsSafe(path, this.getLogger());
                suppressedPluginIds = this.splitByComma("idea.suppressed.plugins.id");
                suppressedPluginsSet = this.getSuppressedPluginsSet();
                if (!pluginIdsFromFile.isEmpty() || !suppressedPluginIds.isEmpty() || !suppressedPluginsSet.isEmpty()) break block9;
                Set set = SetsKt.emptySet();
                return set;
            }
            try {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                PluginId requiredForCurrentMode = AppMode.isRemoteDevHost() ? PluginManagerCore.ULTIMATE_PLUGIN_ID : null;
                ApplicationInfoEx applicationInfoEx = ApplicationInfoImpl.getShadowInstance();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)applicationInfoEx), (String)"getShadowInstance(...)");
                ApplicationInfoEx applicationInfo = applicationInfoEx;
                for (PluginId id : pluginIdsFromFile) {
                    if (!(requiredPlugins.contains(id) || applicationInfo.isEssentialPlugin(id) || Intrinsics.areEqual((Object)id, (Object)requiredForCurrentMode))) {
                        disabledPlugins.add(id);
                        continue;
                    }
                    updateFile = true;
                }
                for (PluginId suppressedPluginId : suppressedPluginIds) {
                    if (applicationInfo.isEssentialPlugin(suppressedPluginId) || !disabledPlugins.add(suppressedPluginId)) continue;
                    updateFile = true;
                }
                Object object = suppressedPluginsSet;
                Set set = disabledPlugins;
                boolean $i$f$filter = false;
                void var12_16 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    PluginId it = (PluginId)element$iv$iv;
                    boolean bl = false;
                    if (!(!applicationInfo.isEssentialPlugin(it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                object = SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv));
                return object;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (updateFile) {
                    this.trySaveDisabledPlugins((Set<PluginId>)disabledPlugins, false);
                }
            }
        }

        private final Set<PluginId> getSuppressedPluginsSet() {
            String string = System.getProperty("idea.suppressed.plugins.set.selector");
            if (string == null) {
                return SetsKt.emptySet();
            }
            String selector = string;
            return this.splitByComma("idea.suppressed.plugins.set." + selector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Set<PluginId> getDisabledIds() {
            Set set = disabledPlugins;
            if (set != null) {
                Set it = set;
                boolean bl = false;
                return it;
            }
            if (isDisabledStateIgnored) {
                Set<PluginId> set2 = Collections.emptySet();
                Intrinsics.checkNotNullExpressionValue(set2, (String)"emptySet(...)");
                return set2;
            }
            Class<DisabledPluginsState> clazz = DisabledPluginsState.class;
            synchronized (clazz) {
                boolean bl = false;
                Set<PluginId> result = disabledPlugins;
                if (result == null) {
                    Set<PluginId> set3 = Collections.unmodifiableSet(Companion.loadDisabledPlugins(Companion.getDefaultFilePath()));
                    Intrinsics.checkNotNull(set3);
                    result = set3;
                    disabledPlugins = result;
                }
                Set<PluginId> set4 = result;
                return set4;
            }
        }

        @JvmName(name="setEnabledState")
        public final boolean setEnabledState(@NotNull Collection<? extends IdeaPluginDescriptor> descriptors, boolean enabled) {
            Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
            Set<PluginId> pluginIds = PluginUtils.toPluginIdSet((Iterable<? extends IdeaPluginDescriptor>)descriptors);
            return this.setEnabledStateForIds(pluginIds, enabled);
        }

        @JvmName(name="setEnabledStateForIds")
        public final boolean setEnabledStateForIds(@NotNull Set<PluginId> pluginIds, boolean enabled) {
            boolean changed;
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            Set disabled = CollectionsKt.toMutableSet((Iterable)this.getDisabledIds());
            boolean bl = changed = enabled ? disabled.removeAll((Collection)pluginIds) : disabled.addAll((Collection)pluginIds);
            if (changed) {
                disabledPlugins = Collections.unmodifiableSet(disabled);
            }
            boolean actuallyChanged = changed && this.saveDisabledPluginsAndInvalidate(disabled);
            String operation = enabled ? "enable" : "disable";
            this.getLogger().info(PluginUtils.joinedPluginIds((Iterable<PluginId>)pluginIds, operation) + ", " + (actuallyChanged ? "applied" : " was already " + operation + "d, nothing changed"));
            return actuallyChanged;
        }

        public final boolean saveDisabledPluginsAndInvalidate(@NotNull Set<PluginId> pluginIds) {
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            return this.trySaveDisabledPlugins(pluginIds, true);
        }

        private final boolean trySaveDisabledPlugins(Set<PluginId> pluginIds, boolean invalidate) {
            if (!PluginStringSetFile.INSTANCE.writeIdsSafe(this.getDefaultFilePath(), pluginIds, this.getLogger())) {
                return false;
            }
            if (invalidate) {
                this.invalidate();
            }
            Iterator iterator = ourDisabledPluginListeners.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                Runnable listener = (Runnable)iterator2.next();
                listener.run();
            }
            return true;
        }

        @TestOnly
        public final void saveDisabledPluginsAndInvalidate(@NotNull Path configPath, @NotNull List<String> pluginIds) throws IOException {
            Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
            Intrinsics.checkNotNullParameter(pluginIds, (String)"pluginIds");
            Path path = configPath.resolve(DisabledPluginsState.DISABLED_PLUGINS_FILENAME);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            PluginStringSetFileKt.writePluginStringSet(path, CollectionsKt.toSet((Iterable)pluginIds));
            this.invalidate();
        }

        public static /* synthetic */ void saveDisabledPluginsAndInvalidate$default(Companion companion, Path path, List list, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                list = CollectionsKt.emptyList();
            }
            companion.saveDisabledPluginsAndInvalidate(path, list);
        }

        public final void invalidate() {
            disabledPlugins = null;
        }

        private final Set<PluginId> splitByComma(String key) {
            Set<PluginId> set;
            String property = System.getProperty(key, "");
            Intrinsics.checkNotNull((Object)property);
            if (((CharSequence)property).length() == 0) {
                set = SetsKt.emptySet();
            } else {
                char[] cArray = new char[]{','};
                set = PluginUtils.parseAsPluginIdSet(StringsKt.split$default((CharSequence)property, (char[])cArray, (boolean)false, (int)0, (int)6, null));
            }
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

