/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.core.CoreBundle;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginNonLoadReason;
import com.intellij.openapi.util.BuildNumber;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\r\u00a2\u0006\u0002\b\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0010R\u0019\u0010\u0014\u001a\u00070\r\u00a2\u0006\u0002\b\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0010R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lcom/intellij/ide/plugins/PluginUntilBuildConstraintViolation;", "Lcom/intellij/ide/plugins/PluginNonLoadReason;", "plugin", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "productBuildNumber", "Lcom/intellij/openapi/util/BuildNumber;", "<init>", "(Lcom/intellij/ide/plugins/IdeaPluginDescriptor;Lcom/intellij/openapi/util/BuildNumber;)V", "getPlugin", "()Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "getProductBuildNumber", "()Lcom/intellij/openapi/util/BuildNumber;", "detailedMessage", "", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "getDetailedMessage", "()Ljava/lang/String;", "shortMessage", "Lcom/intellij/openapi/util/NlsContexts$Label;", "getShortMessage", "logMessage", "Lorg/jetbrains/annotations/NonNls;", "getLogMessage", "shouldNotifyUser", "", "getShouldNotifyUser", "()Z", "intellij.platform.core.impl"})
@ApiStatus.Internal
public final class PluginUntilBuildConstraintViolation
implements PluginNonLoadReason {
    @NotNull
    private final IdeaPluginDescriptor plugin;
    @NotNull
    private final BuildNumber productBuildNumber;
    private final boolean shouldNotifyUser;

    public PluginUntilBuildConstraintViolation(@NotNull IdeaPluginDescriptor plugin, @NotNull BuildNumber productBuildNumber) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)productBuildNumber, (String)"productBuildNumber");
        this.plugin = plugin;
        this.productBuildNumber = productBuildNumber;
        this.shouldNotifyUser = true;
    }

    @Override
    @NotNull
    public IdeaPluginDescriptor getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final BuildNumber getProductBuildNumber() {
        return this.productBuildNumber;
    }

    @Override
    @NotNull
    public String getDetailedMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getName(), this.getPlugin().getVersion(), this.getPlugin().getUntilBuild(), this.productBuildNumber};
        return CoreBundle.message((String)"plugin.loading.error.long.incompatible.until.build", (Object[])objectArray);
    }

    @Override
    @NotNull
    public String getShortMessage() {
        Object[] objectArray = new Object[]{this.getPlugin().getUntilBuild()};
        return CoreBundle.message((String)"plugin.loading.error.short.incompatible.until.build", (Object[])objectArray);
    }

    @Override
    @NotNull
    public String getLogMessage() {
        return "Plugin '" + this.getPlugin().getName() + "' (" + this.getPlugin().getPluginId() + ", version=" + this.getPlugin().getVersion() + ") requires IDE build " + this.getPlugin().getUntilBuild() + " or older, but the current build is " + this.productBuildNumber;
    }

    @Override
    public boolean getShouldNotifyUser() {
        return this.shouldNotifyUser;
    }
}

