/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.PersistentRangeMarkerUtil;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.editor.impl.StripedIDGenerator;
import com.intellij.openapi.editor.impl.event.DocumentEventImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerBase;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.TextRangeScalarUtil;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.diff.FilesTooBigForDiffException;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@ApiStatus.Internal
public class RangeMarkerImpl
extends UserDataHolderBase
implements RangeMarkerEx,
Supplier<RangeMarkerEx> {
    private static final Logger LOG = Logger.getInstance(RangeMarkerImpl.class);
    @NotNull
    private final Object myDocumentOrFile;
    @ApiStatus.Internal
    protected volatile RangeMarkerTree.RMNode<RangeMarkerEx> myNode;
    @ApiStatus.Internal
    protected volatile long myId;
    private static final StripedIDGenerator counter = new StripedIDGenerator();

    @ApiStatus.Internal
    public RangeMarkerImpl(@NotNull DocumentEx document, int start, int end, boolean register, boolean forceDocumentStrongReference) {
        if (document == null) {
            RangeMarkerImpl.$$$reportNull$$$0(0);
        }
        this(forceDocumentStrongReference ? document : ObjectUtils.notNull((Object)FileDocumentManager.getInstance().getFile((Document)document), (Object)document), document, document.getTextLength(), start, end, register, false, false);
    }

    RangeMarkerImpl(@NotNull VirtualFile virtualFile, int start, int end, int estimatedDocumentLength, boolean register) {
        if (virtualFile == null) {
            RangeMarkerImpl.$$$reportNull$$$0(1);
        }
        this(virtualFile, null, estimatedDocumentLength, start, end, register, false, false);
    }

    private RangeMarkerImpl(@NotNull Object documentOrFile, @Nullable DocumentEx document, int documentTextLength, int start, int end, boolean register, boolean greedyToLeft, boolean greedyToRight) {
        if (documentOrFile == null) {
            RangeMarkerImpl.$$$reportNull$$$0(2);
        }
        if (end > documentTextLength) {
            throw new IllegalArgumentException("Invalid offsets: start=" + start + "; end=" + end + "; document length=" + documentTextLength);
        }
        this.myDocumentOrFile = documentOrFile;
        this.myId = counter.next();
        if (register) {
            DocumentEx d = document == null ? this.getDocument() : document;
            this.registerInTree(d, start, end, greedyToLeft, greedyToRight, 0);
        }
    }

    static int estimateDocumentLength(@NotNull VirtualFile virtualFile) {
        Document document;
        if (virtualFile == null) {
            RangeMarkerImpl.$$$reportNull$$$0(3);
        }
        return (document = FileDocumentManager.getInstance().getCachedDocument(virtualFile)) == null ? Math.max(0, (int)virtualFile.getLength()) : document.getTextLength();
    }

    @ApiStatus.Internal
    protected void registerInTree(@NotNull DocumentEx document, int start, int end, boolean greedyToLeft, boolean greedyToRight, int layer) {
        if (document == null) {
            RangeMarkerImpl.$$$reportNull$$$0(4);
        }
        document.registerRangeMarker(this, start, end, greedyToLeft, greedyToRight, layer);
    }

    protected void unregisterInTree() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (!this.isValid()) {
            return;
        }
        IntervalTreeImpl tree = node.getTree();
        tree.checkMax(true);
        DocumentEx document = this.getCachedDocument();
        if (document == null) {
            this.storeOffsetsBeforeDying(node);
            this.myNode = null;
        } else {
            document.removeRangeMarker(this);
        }
        tree.checkMax(true);
    }

    @Override
    public long getId() {
        long id = this.myId;
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            throw new IllegalStateException("Already disposed");
        }
        return id;
    }

    public void dispose() {
        this.unregisterInTree();
    }

    public int getStartOffset() {
        return this.getStartOffset(this.myNode);
    }

    private int getStartOffset(RangeMarkerTree.RMNode<?> node) {
        return node == null ? TextRangeScalarUtil.startOffset((long)this.myId) : node.intervalStart() + node.computeDeltaUpToRoot();
    }

    public int getEndOffset() {
        return this.getEndOffset(this.myNode);
    }

    private int getEndOffset(RangeMarkerTree.RMNode<?> node) {
        return node == null ? TextRangeScalarUtil.endOffset((long)this.myId) : node.intervalEnd() + node.computeDeltaUpToRoot();
    }

    @NotNull
    public TextRange getTextRange() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            TextRange textRange = TextRangeScalarUtil.create((long)this.myId);
            if (textRange == null) {
                RangeMarkerImpl.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        int delta = node.computeDeltaUpToRoot();
        TextRange textRange = TextRangeScalarUtil.create((long)TextRangeScalarUtil.shift((long)node.toScalarRange(), (int)delta, (int)delta));
        if (textRange == null) {
            RangeMarkerImpl.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @ApiStatus.Internal
    public void invalidate() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node != null) {
            node.invalidate();
        }
    }

    @NotNull
    public final DocumentEx getDocument() {
        DocumentEx document;
        Object file = this.myDocumentOrFile;
        DocumentEx documentEx = document = file instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getDocument((VirtualFile)file) : (DocumentEx)file;
        if (document == null) {
            LOG.error("document is null; isValid=" + this.isValid() + "; file=" + file);
        }
        DocumentEx documentEx2 = document;
        if (documentEx2 == null) {
            RangeMarkerImpl.$$$reportNull$$$0(7);
        }
        return documentEx2;
    }

    @VisibleForTesting
    public DocumentEx getCachedDocument() {
        Object file = this.myDocumentOrFile;
        return file instanceof VirtualFile ? (DocumentEx)FileDocumentManager.getInstance().getCachedDocument((VirtualFile)file) : (DocumentEx)file;
    }

    public int getLayer() {
        return 0;
    }

    public void setGreedyToLeft(boolean greedy) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (this.isValid(node) && greedy != node.isGreedyToLeft()) {
            node.getTree().changeData(this, this.getStartOffset(node), this.getEndOffset(node), greedy, node.isGreedyToRight(), node.isStickingToRight(), this.getLayer());
        }
    }

    public void setGreedyToRight(boolean greedy) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (this.isValid(node) && greedy != node.isGreedyToRight()) {
            node.getTree().changeData(this, this.getStartOffset(node), this.getEndOffset(node), node.isGreedyToLeft(), greedy, node.isStickingToRight(), this.getLayer());
        }
    }

    public void setStickingToRight(boolean value) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (this.isValid(node) && value != node.isStickingToRight()) {
            node.getTree().changeData(this, this.getStartOffset(node), this.getEndOffset(node), node.isGreedyToLeft(), node.isGreedyToRight(), value, this.getLayer());
        }
    }

    public boolean isGreedyToLeft() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToLeft();
    }

    public boolean isGreedyToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isGreedyToRight();
    }

    public boolean isStickingToRight() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node != null && node.isStickingToRight();
    }

    final void onDocumentChanged(@NotNull DocumentEvent e) {
        int newEnd;
        int newStart;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(8);
        }
        int oldStart = this.intervalStart();
        int oldEnd = this.intervalEnd();
        int docLength = e.getDocument().getTextLength();
        if (!this.isValid()) {
            LOG.error("Invalid range marker " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + ". Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            return;
        }
        if (oldStart > oldEnd || oldStart < 0 || oldEnd > docLength - e.getNewLength() + e.getOldLength()) {
            LOG.error("RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " is invalid before update. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass());
            this.invalidate();
            return;
        }
        this.changedUpdateImpl(e);
        if (this.isValid() && ((newStart = this.intervalStart()) > (newEnd = this.intervalEnd()) || newStart < 0 || newEnd > docLength)) {
            LOG.error("Update failed. Event = " + e + ". Doc length=" + docLength + "; " + this.getClass() + ". Before update: " + (this.isGreedyToLeft() ? "[" : "(") + oldStart + ", " + oldEnd + (this.isGreedyToRight() ? "]" : ")") + " After update: '" + this + "'");
            this.invalidate();
        }
    }

    protected void changedUpdateImpl(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(9);
        }
        this.doChangeUpdate(e);
    }

    private void doChangeUpdate(@NotNull DocumentEvent e) {
        long newRange;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(10);
        }
        if (!this.isValid()) {
            return;
        }
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        long l = newRange = node == null ? -1L : RangeMarkerImpl.applyChange(e, node.toScalarRange(), this.isGreedyToLeft(), this.isGreedyToRight(), this.isStickingToRight());
        if (newRange == -1L) {
            this.invalidate();
        } else {
            node.setRange(newRange);
        }
    }

    protected void persistentHighlighterUpdate(@NotNull DocumentEvent e, boolean wholeLineRange) {
        boolean viaDiff;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(11);
        }
        int line = 0;
        DocumentEventImpl event = (DocumentEventImpl)e;
        boolean bl = viaDiff = this.isValid() && PersistentRangeMarkerUtil.shouldTranslateViaDiff(event, this.toScalarRange());
        if (viaDiff) {
            try {
                line = event.getLineNumberBeforeUpdate(this.getStartOffset());
                line = this.translatedViaDiff(event, line);
            }
            catch (FilesTooBigForDiffException exception) {
                viaDiff = false;
            }
        }
        if (!viaDiff) {
            this.doChangeUpdate(e);
            if (this.isValid()) {
                int startOffset = this.getStartOffset();
                line = this.getDocument().getLineNumber(startOffset);
                int endLine = this.getDocument().getLineNumber(this.getEndOffset());
                if (endLine != line) {
                    this.setRange(TextRangeScalarUtil.toScalarRange((int)startOffset, (int)this.getDocument().getLineEndOffset(line)));
                }
            }
        }
        if (this.isValid() && wholeLineRange) {
            int newStart = DocumentUtil.getFirstNonSpaceCharOffset(this.getDocument(), line);
            int newEnd = this.getDocument().getLineEndOffset(line);
            this.setRange(TextRangeScalarUtil.toScalarRange((int)newStart, (int)newEnd));
        }
    }

    private int translatedViaDiff(@NotNull DocumentEventImpl e, int line) throws FilesTooBigForDiffException {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(12);
        }
        if ((line = e.translateLineViaDiff(line)) < 0 || line >= this.getDocument().getLineCount()) {
            this.invalidate();
        } else {
            DocumentEx document = this.getDocument();
            this.setRange(TextRangeScalarUtil.toScalarRange((int)document.getLineStartOffset(line), (int)document.getLineEndOffset(line)));
        }
        return line;
    }

    protected void onReTarget(@NotNull DocumentEvent e) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(13);
        }
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    public static long applyChange(@NotNull DocumentEvent e, long range, boolean isGreedyToLeft, boolean isGreedyToRight, boolean bl) {
        int intervalEnd;
        int intervalStart;
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(14);
        }
        if ((intervalStart = TextRangeScalarUtil.startOffset((long)range)) == (intervalEnd = TextRangeScalarUtil.endOffset((long)range))) {
            void isStickingToRight;
            return RangeMarkerImpl.processIfOnePoint(e, intervalStart, isGreedyToRight, (boolean)isStickingToRight);
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int newLength = e.getNewLength();
        if (offset > intervalEnd) {
            return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)intervalEnd);
        }
        if (!isGreedyToRight && intervalEnd == offset) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() < offset) {
                return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)(intervalEnd + newLength));
            }
            return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)intervalEnd);
        }
        if (intervalStart > offset + oldLength) {
            return TextRangeScalarUtil.toScalarRange((int)(intervalStart + newLength - oldLength), (int)(intervalEnd + newLength - oldLength));
        }
        if (!isGreedyToLeft && intervalStart == offset + oldLength) {
            if (e instanceof DocumentEventImpl && oldLength == 0 && ((DocumentEventImpl)e).getInitialStartOffset() + ((DocumentEventImpl)e).getInitialOldLength() > offset) {
                return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)(intervalEnd + newLength));
            }
            return TextRangeScalarUtil.toScalarRange((int)(intervalStart + newLength - oldLength), (int)(intervalEnd + newLength - oldLength));
        }
        if (intervalStart <= offset && intervalEnd >= offset + oldLength) {
            return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)(intervalEnd + newLength - oldLength));
        }
        if (intervalStart >= offset && intervalStart <= offset + oldLength && intervalEnd > offset + oldLength) {
            return TextRangeScalarUtil.toScalarRange((int)(offset + newLength), (int)(intervalEnd + newLength - oldLength));
        }
        if (intervalEnd <= offset + oldLength && intervalStart < offset) {
            return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)offset);
        }
        return -1L;
    }

    private static long processIfOnePoint(@NotNull DocumentEvent e, int intervalStart, boolean greedyRight, boolean stickyRight) {
        if (e == null) {
            RangeMarkerImpl.$$$reportNull$$$0(15);
        }
        int offset = e.getOffset();
        int oldLength = e.getOldLength();
        int oldEnd = offset + oldLength;
        if (offset < intervalStart && intervalStart < oldEnd) {
            return -1L;
        }
        if (offset == intervalStart && oldLength == 0) {
            if (greedyRight) {
                return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)(intervalStart + e.getNewLength()));
            }
            if (stickyRight) {
                int off = intervalStart + e.getNewLength();
                return TextRangeScalarUtil.toScalarRange((int)off, (int)off);
            }
        }
        if (intervalStart > oldEnd || intervalStart == oldEnd && oldLength > 0) {
            int off = intervalStart + e.getNewLength() - oldLength;
            return TextRangeScalarUtil.toScalarRange((int)off, (int)off);
        }
        return TextRangeScalarUtil.toScalarRange((int)intervalStart, (int)intervalStart);
    }

    @NonNls
    public String toString() {
        return "RangeMarker" + (this.isGreedyToLeft() ? "[" : "(") + (this.isValid() ? "" : "invalid:") + this.getStartOffset() + "," + this.getEndOffset() + (this.isGreedyToRight() ? "]" : ")") + " " + (this.isValid() ? Long.valueOf(this.getId()) : "");
    }

    @ApiStatus.Internal
    public void setRange(long scalarRange) {
        this.myNode.setRange(scalarRange);
    }

    public boolean isValid() {
        return this.isValid(this.myNode);
    }

    private boolean isValid(@Nullable RangeMarkerTree.RMNode<?> node) {
        if (node == null || !node.isValid()) {
            return false;
        }
        Object file = this.myDocumentOrFile;
        return file instanceof Document || RangeMarkerImpl.canHaveDocument((VirtualFile)file);
    }

    private static boolean canHaveDocument(@NotNull VirtualFile file) {
        Document document;
        if (file == null) {
            RangeMarkerImpl.$$$reportNull$$$0(16);
        }
        if ((document = FileDocumentManager.getInstance().getCachedDocument(file)) != null) {
            return true;
        }
        if (!file.isValid() || file.isDirectory() || FileDocumentManagerBase.isBinaryWithoutDecompiler(file)) {
            return false;
        }
        return !file.getFileType().isBinary() || !VirtualFileUtil.isTooLarge((VirtualFile)file);
    }

    protected boolean setValid(boolean value) {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        return node == null || node.setValid(value);
    }

    public int intervalStart() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalStart();
    }

    public int intervalEnd() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return -1;
        }
        return node.intervalEnd();
    }

    @ApiStatus.Internal
    public long getScalarRange() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return this.myId;
        }
        long range = node.toScalarRange();
        int delta = node.computeDeltaUpToRoot();
        return TextRangeScalarUtil.shift((long)range, (int)delta, (int)delta);
    }

    @ApiStatus.Internal
    public long toScalarRange() {
        RangeMarkerTree.RMNode<RangeMarkerEx> node = this.myNode;
        if (node == null) {
            return this.myId;
        }
        return node.toScalarRange();
    }

    public RangeMarker findRangeMarkerAfter() {
        return this.myNode.getTree().findRangeMarkerAfter(this);
    }

    public RangeMarker findRangeMarkerBefore() {
        return this.myNode.getTree().findRangeMarkerBefore(this);
    }

    @NotNull
    TextRange reCalcTextRangeAfterReload(@NotNull DocumentImpl document, int tabSize) {
        if (document == null) {
            RangeMarkerImpl.$$$reportNull$$$0(17);
        }
        TextRange textRange = this.getTextRange();
        if (textRange == null) {
            RangeMarkerImpl.$$$reportNull$$$0(18);
        }
        return textRange;
    }

    void storeOffsetsBeforeDying(@NotNull IntervalTreeImpl.IntervalNode<?> node) {
        if (node == null) {
            RangeMarkerImpl.$$$reportNull$$$0(19);
        }
        int delta = node.computeDeltaUpToRoot();
        long range = TextRangeScalarUtil.shift((long)node.toScalarRange(), (int)delta, (int)delta);
        int startOffset = Math.max(0, TextRangeScalarUtil.startOffset((long)range));
        int endOffset = Math.max(startOffset, TextRangeScalarUtil.endOffset((long)range));
        this.myId = TextRangeScalarUtil.toScalarRange((int)startOffset, (int)endOffset);
    }

    @Override
    public RangeMarkerEx get() {
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentOrFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/RangeMarkerImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocument";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "reCalcTextRangeAfterReload";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "estimateDocumentLength";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "registerInTree";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onDocumentChanged";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "changedUpdateImpl";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doChangeUpdate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "persistentHighlighterUpdate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "translatedViaDiff";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "onReTarget";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "applyChange";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processIfOnePoint";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "canHaveDocument";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reCalcTextRangeAfterReload";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "storeOffsetsBeforeDying";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

