/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.util.pico.AmbiguousComponentResolutionException;
import com.intellij.util.pico.CachingConstructorInjectionComponentAdapter;
import com.intellij.util.pico.PicoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;

@ApiStatus.Internal
public class DefaultPicoContainer
implements MutablePicoContainer {
    private final DefaultPicoContainer parent;
    private final Map<Object, ComponentAdapter> componentKeyToAdapter = new ConcurrentHashMap<Object, ComponentAdapter>();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();

    public DefaultPicoContainer(@Nullable DefaultPicoContainer parent) {
        this.parent = parent;
    }

    public DefaultPicoContainer() {
        this(null);
    }

    @NotNull
    public final @Unmodifiable Collection<ComponentAdapter> getComponentAdapters() {
        Set<ComponentAdapter> set = this.componentAdapters.getImmutableSet();
        if (set == null) {
            DefaultPicoContainer.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @Nullable
    public final ComponentAdapter getComponentAdapter(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(1);
        }
        if ((adapter = this.getFromCache(componentKey)) == null && this.parent != null) {
            return this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    @Nullable
    private ComponentAdapter getFromCache(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(2);
        }
        if ((adapter = this.componentKeyToAdapter.get(componentKey)) != null) {
            return adapter;
        }
        return componentKey instanceof Class ? this.componentKeyToAdapter.get(((Class)componentKey).getName()) : null;
    }

    @Nullable
    final ComponentAdapter getComponentAdapterOfType(@NotNull Class<?> componentType, @Nullable Object excludeKey) {
        ComponentAdapter adapterByKey;
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(3);
        }
        if (!((adapterByKey = this.getComponentAdapter(componentType)) == null || excludeKey != null && excludeKey.equals(adapterByKey.getComponentKey()))) {
            return adapterByKey;
        }
        List<ComponentAdapter> found = this.getComponentAdaptersOfType(componentType, excludeKey);
        if (found.isEmpty()) {
            return this.parent == null ? null : this.parent.getComponentAdapterOfType(componentType, excludeKey);
        }
        if (found.size() == 1) {
            return found.get(0);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    @NotNull
    private @Unmodifiable List<ComponentAdapter> getComponentAdaptersOfType(@NotNull Class<?> componentType, @Nullable Object excludeKey) {
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(4);
        }
        if (componentType == String.class) {
            List<ComponentAdapter> list = Collections.emptyList();
            if (list == null) {
                DefaultPicoContainer.$$$reportNull$$$0(5);
            }
            return list;
        }
        ArrayList<ComponentAdapter> result = new ArrayList<ComponentAdapter>();
        ComponentAdapter cacheHit = this.componentKeyToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result.add(cacheHit);
        }
        for (ComponentAdapter adapter : this.componentKeyToAdapter.values()) {
            Class descendant;
            Object componentKey = adapter.getComponentKey();
            if (componentKey instanceof String || excludeKey != null && excludeKey.equals(componentKey) || componentType != (descendant = adapter.getComponentImplementation()) && !componentType.isAssignableFrom(descendant)) continue;
            result.add(adapter);
        }
        ArrayList<ComponentAdapter> arrayList = result;
        if (arrayList == null) {
            DefaultPicoContainer.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    private ComponentAdapter registerComponent(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(7);
        }
        if (this.componentKeyToAdapter.putIfAbsent(componentAdapter.getComponentKey(), componentAdapter) != null) {
            @NotNull String message = "Key " + componentAdapter.getComponentKey() + " duplicated";
            throw new PicoException(message);
        }
        this.componentAdapters.add(componentAdapter);
        ComponentAdapter componentAdapter2 = componentAdapter;
        if (componentAdapter2 == null) {
            DefaultPicoContainer.$$$reportNull$$$0(8);
        }
        return componentAdapter2;
    }

    @Override
    @Nullable
    public final ComponentAdapter unregisterComponent(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(9);
        }
        if ((adapter = this.componentKeyToAdapter.remove(componentKey)) == null) {
            return null;
        }
        this.componentAdapters.remove(adapter);
        return adapter;
    }

    @Nullable
    public Object getComponentInstance(@NotNull Object componentKey) {
        ComponentAdapter adapter;
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(10);
        }
        if ((adapter = this.getFromCache(componentKey)) != null) {
            return adapter.getComponentInstance();
        }
        return this.parent == null ? null : this.parent.getComponentInstance(componentKey);
    }

    @Nullable
    public final <T> T getService(@NotNull Class<T> serviceClass) {
        ComponentAdapter adapter;
        if (serviceClass == null) {
            DefaultPicoContainer.$$$reportNull$$$0(11);
        }
        if ((adapter = this.componentKeyToAdapter.get(serviceClass.getName())) == null) {
            return null;
        }
        return (T)adapter.getComponentInstance();
    }

    @Nullable
    public final Object getComponentInstanceOfType(@NotNull Class<?> componentType) {
        ComponentAdapter componentAdapter;
        if (componentType == null) {
            DefaultPicoContainer.$$$reportNull$$$0(12);
        }
        return (componentAdapter = this.getComponentAdapterOfType(componentType, null)) == null ? null : this.getInstance(componentAdapter);
    }

    @Nullable
    private Object getInstance(@NotNull ComponentAdapter componentAdapter) {
        if (componentAdapter == null) {
            DefaultPicoContainer.$$$reportNull$$$0(13);
        }
        if (this.componentAdapters.getImmutableSet().contains(componentAdapter)) {
            return componentAdapter.getComponentInstance();
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    @Override
    public final ComponentAdapter registerComponentInstance(@NotNull Object componentKey, @NotNull Object componentInstance) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(14);
        }
        if (componentInstance == null) {
            DefaultPicoContainer.$$$reportNull$$$0(15);
        }
        return this.registerComponent(new InstanceComponentAdapter(componentKey, componentInstance));
    }

    @Override
    public final ComponentAdapter registerComponentImplementation(@NotNull Object componentKey, @NotNull Class<?> componentImplementation) {
        if (componentKey == null) {
            DefaultPicoContainer.$$$reportNull$$$0(16);
        }
        if (componentImplementation == null) {
            DefaultPicoContainer.$$$reportNull$$$0(17);
        }
        return this.registerComponent(new CachingConstructorInjectionComponentAdapter(this, componentKey, componentImplementation));
    }

    public final String toString() {
        DefaultPicoContainer parent = this.parent;
        return "DefaultPicoContainer" + (parent == null ? " (root)" : " (parent=" + parent + ")");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentKey";
                break;
            }
            case 3: 
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentType";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentAdapter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentInstance";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentAdapters";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/pico/DefaultPicoContainer";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentAdaptersOfType";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "registerComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFromCache";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdapterOfType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getComponentAdaptersOfType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "unregisterComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstance";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getComponentInstanceOfType";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentInstance";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerComponentImplementation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile @Unmodifiable Set<T> immutableSet;
        private Set<T> synchronizedSet = new LinkedHashSet<T>();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void add(@NotNull T element) {
            if (element == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(0);
            }
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private Set<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void remove(@Nullable T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        @Unmodifiable Set<T> getImmutableSet() {
            Set<T> result = this.immutableSet;
            if (result == null) {
                Object object = this.lock;
                synchronized (object) {
                    result = this.immutableSet;
                    if (result == null) {
                        this.immutableSet = result = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            Set<T> set = result;
            if (set == null) {
                LinkedHashSetWrapper.$$$reportNull$$$0(1);
            }
            return set;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/pico/DefaultPicoContainer$LinkedHashSetWrapper";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImmutableSet";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class InstanceComponentAdapter
    implements ComponentAdapter {
        @NotNull
        private final Object componentKey;
        @NotNull
        private final Object componentInstance;

        InstanceComponentAdapter(@NotNull Object componentKey, @NotNull Object componentInstance) {
            if (componentKey == null) {
                InstanceComponentAdapter.$$$reportNull$$$0(0);
            }
            if (componentInstance == null) {
                InstanceComponentAdapter.$$$reportNull$$$0(1);
            }
            this.componentKey = componentKey;
            this.componentInstance = componentInstance;
        }

        @NotNull
        public Object getComponentInstance() {
            Object object = this.componentInstance;
            if (object == null) {
                InstanceComponentAdapter.$$$reportNull$$$0(2);
            }
            return object;
        }

        @NotNull
        public Object getComponentKey() {
            Object object = this.componentKey;
            if (object == null) {
                InstanceComponentAdapter.$$$reportNull$$$0(3);
            }
            return object;
        }

        @NotNull
        public Class<?> getComponentImplementation() {
            Class<?> clazz = this.componentInstance.getClass();
            if (clazz == null) {
                InstanceComponentAdapter.$$$reportNull$$$0(4);
            }
            return clazz;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.getComponentKey() + "]";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentKey";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "componentInstance";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/pico/DefaultPicoContainer$InstanceComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/pico/DefaultPicoContainer$InstanceComponentAdapter";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponentInstance";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponentKey";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponentImplementation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

