/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormatter;
import com.intellij.database.csv.CsvRecord;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.csv.ValueRange;
import com.intellij.database.datagrid.CsvFormatParser;
import com.intellij.database.datagrid.CsvParserResult;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.NamedRow;
import com.intellij.database.datagrid.mutating.ColumnQueryData;
import com.intellij.database.datagrid.mutating.RowMutation;
import com.intellij.database.dbimport.CsvImportUtil;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CsvDocumentDataHookUp
extends DocumentDataHookUp {
    private CsvFormat myFormat;

    public CsvDocumentDataHookUp(@NotNull Project project, @NotNull CsvFormat format, @NotNull Document document, @Nullable TextRange range) {
        if (project == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(0);
        }
        if (format == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(1);
        }
        if (document == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(2);
        }
        super(project, document, range);
        this.myFormat = format;
    }

    @Override
    @NotNull
    protected DocumentDataHookUp.DocumentDataMutator createDataMutator() {
        return new CsvDocumentDataMutator();
    }

    public void setFormat(@NotNull CsvFormat format, @NotNull GridRequestSource source) {
        if (format == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(3);
        }
        if (source == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(4);
        }
        this.myFormat = format;
        this.getLoader().reloadCurrentPage(source);
    }

    @NotNull
    public CsvFormat getFormat() {
        CsvFormat csvFormat = this.myFormat;
        if (csvFormat == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(5);
        }
        return csvFormat;
    }

    @Override
    @Nullable
    protected CsvMarkup buildMarkup(@NotNull CharSequence sequence, @NotNull GridRequestSource source) {
        String string;
        CsvParserResult result;
        if (sequence == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(6);
        }
        if (source == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(7);
        }
        return (result = new CsvFormatParser(this.myFormat).parse((CharSequence)(string = sequence.toString()))) == null ? this.oneLineMarkup(string) : new CsvMarkup(result);
    }

    @NotNull
    private CsvMarkup oneLineMarkup(@NotNull String string) {
        if (string == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(8);
        }
        CsvFormatter formatter = new CsvFormatter(this.myFormat);
        int length = string.length();
        TextRange range = new TextRange(0, length);
        CsvRecord record = new CsvRecord(range, Collections.singletonList(new ValueRange(0, length)), false);
        return new CsvMarkup(formatter, string, Collections.singletonList(record), null, false, record.values.size());
    }

    @NotNull
    public static List<GridColumn> columnsFrom(@NotNull CharSequence sequence, @NotNull List<CsvRecord> records, @Nullable CsvRecord header, boolean rowNameColumn, int columnsCount, @NotNull CsvFormat format) {
        if (sequence == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(9);
        }
        if (records == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(10);
        }
        if (format == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(11);
        }
        if (columnsCount > 0 && rowNameColumn) {
            --columnsCount;
        }
        List columnNames = header != null && rowNameColumn ? CsvFormatParser.values(null, (CharSequence)sequence, header.values.subList(1, header.values.size())) : (header != null ? CsvFormatParser.values(null, (CharSequence)sequence, (List)header.values) : null);
        ArrayList<GridColumn> columns = new ArrayList<GridColumn>(columnsCount);
        for (int i = 0; i < columnsCount; ++i) {
            String name = columnNames == null || i >= columnNames.size() ? "C" + (i + 1) : (String)columnNames.get(i);
            TypeMerger merger = CsvDocumentDataHookUp.determineColumnType(records, i, sequence, format);
            columns.add(new DataConsumer.Column(i, name, DocumentDataHookUp.DataMarkup.getType(merger), merger.getName(), DocumentDataHookUp.DataMarkup.getClassName(merger)));
        }
        ArrayList<GridColumn> arrayList = columns;
        if (arrayList == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(12);
        }
        return arrayList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static TypeMerger determineColumnType(@NotNull List<CsvRecord> records, int i, @NotNull CharSequence sequence, @NotNull CsvFormat format) {
        if (records == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(13);
        }
        if (sequence == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(14);
        }
        if (format == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(15);
        }
        @Nullable JBIterable values = JBIterable.from(records).map(row -> i < row.values.size() ? CsvDocumentDataHookUp.nullize(format.dataRecord.nullText, ((ValueRange)row.values.get(i)).value(sequence).toString()) : null).take(200);
        TypeMerger typeMerger = CsvImportUtil.getPreferredTypeMergerBasedOnContent((Iterable)values, (TypeMerger)DocumentDataHookUp.DataMarkup.STRING_MERGER, (TypeMerger[])new TypeMerger[]{DocumentDataHookUp.DataMarkup.INTEGER_MERGER, DocumentDataHookUp.DataMarkup.BIG_INTEGER_MERGER, DocumentDataHookUp.DataMarkup.DOUBLE_MERGER, DocumentDataHookUp.DataMarkup.BOOLEAN_MERGER});
        if (typeMerger == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(16);
        }
        return typeMerger;
    }

    @Nullable
    private static String nullize(@Nullable String nullText, @NotNull String string) {
        if (string == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(17);
        }
        return StringUtil.equals((CharSequence)nullText, (CharSequence)string) ? null : string;
    }

    @NotNull
    public static List<GridRow> rowsFrom(@NotNull CsvFormat format, @NotNull CharSequence sequence, @NotNull List<CsvRecord> records, boolean named) {
        if (format == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(18);
        }
        if (sequence == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(19);
        }
        if (records == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(20);
        }
        ArrayList<GridRow> rows = new ArrayList<GridRow>(records.size());
        for (int i = 0; i < records.size(); ++i) {
            DataConsumer.Row row;
            List valuesList = records.get((int)i).values;
            if (named) {
                Object[] values = CsvFormatParser.values((CsvRecordFormat)format.dataRecord, (CharSequence)sequence, valuesList.subList(1, valuesList.size())).toArray();
                String name = ((ValueRange)valuesList.getFirst()).value(sequence).toString();
                row = NamedRow.create(i, name, values);
            } else {
                row = DataConsumer.Row.create(i, CsvFormatParser.values((CsvRecordFormat)format.dataRecord, (CharSequence)sequence, (List)valuesList).toArray());
            }
            rows.add(row);
        }
        ArrayList<GridRow> arrayList = rows;
        if (arrayList == null) {
            CsvDocumentDataHookUp.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 12, 16, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 5: 
            case 12: 
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/CsvDocumentDataHookUp";
                break;
            }
            case 6: 
            case 9: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 10: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "records";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/CsvDocumentDataHookUp";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormat";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "columnsFrom";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "determineColumnType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "rowsFrom";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setFormat";
                break;
            }
            case 5: 
            case 12: 
            case 16: 
            case 21: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildMarkup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "oneLineMarkup";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "columnsFrom";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "determineColumnType";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "nullize";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "rowsFrom";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 12, 16, 21 -> new IllegalStateException(string);
        };
    }

    private class CsvDocumentDataMutator
    extends DocumentDataHookUp.DocumentDataMutator {
        private CsvDocumentDataMutator() {
            super(CsvDocumentDataHookUp.this);
        }

        @Override
        @NotNull
        protected DocumentDataHookUp.UpdateSession createSession() {
            TextRange range = CsvDocumentDataHookUp.this.getRange();
            return new CsvUpdateSession(CsvDocumentDataHookUp.this.getDocument(), range != null ? range.getStartOffset() : 0);
        }

        @Override
        protected void finishSession(@NotNull DocumentDataHookUp.UpdateSession session, boolean success) {
            if (session == null) {
                CsvDocumentDataMutator.$$$reportNull$$$0(0);
            }
            if (success && ((CsvUpdateSession)session).myNewFormat != null) {
                CsvDocumentDataHookUp.this.myFormat = ((CsvUpdateSession)session).myNewFormat;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvDocumentDataMutator", "finishSession"));
        }
    }

    public static class CsvMarkup
    extends DocumentDataHookUp.DataMarkup {
        private final List<CsvRecord> myRecords;
        private final CsvRecord myHeader;
        private final CsvFormatter myFormatter;

        public CsvMarkup(@NotNull CsvParserResult result) {
            if (result == null) {
                CsvMarkup.$$$reportNull$$$0(0);
            }
            super(CsvDocumentDataHookUp.columnsFrom(result.getSequence(), result.getRecords(), result.getHeader(), result.getFormat().rowNumbers, result.getColumnsCount(), result.getFormat()), CsvDocumentDataHookUp.rowsFrom(result.getFormat(), result.getSequence(), result.getRecords(), result.getFormat().rowNumbers));
            this.myFormatter = new CsvFormatter(result.getFormat());
            this.myHeader = result.getHeader();
            this.myRecords = result.getRecords();
        }

        CsvMarkup(@NotNull CsvFormatter formatter, @NotNull CharSequence sequence, @NotNull List<CsvRecord> records, @Nullable CsvRecord header, boolean firstRowIsHeader, int columnsCount) {
            if (formatter == null) {
                CsvMarkup.$$$reportNull$$$0(1);
            }
            if (sequence == null) {
                CsvMarkup.$$$reportNull$$$0(2);
            }
            if (records == null) {
                CsvMarkup.$$$reportNull$$$0(3);
            }
            super(CsvDocumentDataHookUp.columnsFrom(sequence, records, header, firstRowIsHeader, columnsCount, formatter.getFormat()), CsvDocumentDataHookUp.rowsFrom(formatter.getFormat(), sequence, records, firstRowIsHeader));
            this.myFormatter = formatter;
            this.myHeader = header;
            this.myRecords = records;
        }

        @Override
        protected boolean deleteRows(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<GridRow> sortedRows) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(4);
            }
            if (sortedRows == null) {
                CsvMarkup.$$$reportNull$$$0(5);
            }
            for (GridRow row : sortedRows) {
                session.delete(this.myRecords.get((int)GridRow.toRealIdx((GridRow)row)).range);
            }
            return true;
        }

        @Override
        protected boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(6);
            }
            return this.insertRow(session, Arrays.asList(new Object[this.columns.size()]));
        }

        @Override
        protected boolean cloneRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull GridRow row) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(7);
            }
            if (row == null) {
                CsvMarkup.$$$reportNull$$$0(8);
            }
            return this.insertRow(session, ContainerUtil.newArrayList((Iterable)row));
        }

        @Override
        protected boolean deleteColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<GridColumn> sortedColumns) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(9);
            }
            if (sortedColumns == null) {
                CsvMarkup.$$$reportNull$$$0(10);
            }
            List<GridColumn> columnsToLeave = this.getColumnsToLeave(sortedColumns);
            if (this.myHeader != null) {
                this.leaveColumns(session, columnsToLeave, this.myHeader);
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                this.leaveColumns(session, columnsToLeave, this.myRecords.get(i), (GridRow)this.rows.get(i));
            }
            return true;
        }

        @Override
        protected boolean renameColumn(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull ModelIndex<GridColumn> column, @NotNull String name) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(11);
            }
            if (column == null) {
                CsvMarkup.$$$reportNull$$$0(12);
            }
            if (name == null) {
                CsvMarkup.$$$reportNull$$$0(13);
            }
            if (column.asInteger() >= this.columns.size()) {
                return false;
            }
            String columnName = this.myFormatter.formatHeaderValue((Object)name);
            if (this.myHeader == null) {
                this.generateHeaderRow(session, column, columnName);
                return true;
            }
            if (column.asInteger() >= this.myHeader.values.size()) {
                this.generateMissingPartOfHeaderRow(session, column, columnName);
                return true;
            }
            ValueRange range = (ValueRange)this.myHeader.values.get(column.asInteger());
            session.replace((TextRange)range, columnName);
            return true;
        }

        private void generateMissingPartOfHeaderRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull ModelIndex<GridColumn> column, @NotNull String columnName) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(14);
            }
            if (column == null) {
                CsvMarkup.$$$reportNull$$$0(15);
            }
            if (columnName == null) {
                CsvMarkup.$$$reportNull$$$0(16);
            }
            int offset = this.myHeader.values.isEmpty() ? 0 : ((ValueRange)ContainerUtil.getLastItem((List)this.myHeader.values)).getEndOffset();
            for (int i = this.myHeader.values.size(); i < column.asInteger(); ++i) {
                session.insert(this.myFormatter.valueSeparator(), offset);
                session.insert(((GridColumn)this.columns.get(i)).getName(), offset);
            }
            session.insert(this.myFormatter.valueSeparator(), offset);
            session.insert(columnName, offset);
        }

        private void generateHeaderRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull ModelIndex<GridColumn> column, @NotNull String columnName) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(17);
            }
            if (column == null) {
                CsvMarkup.$$$reportNull$$$0(18);
            }
            if (columnName == null) {
                CsvMarkup.$$$reportNull$$$0(19);
            }
            ((CsvUpdateSession)session).myNewFormat = CsvFormatter.setFirstRowIsHeader((CsvFormat)this.myFormatter.getFormat(), (boolean)true);
            boolean emptyDoc = session.getText().isEmpty();
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (GridColumn c : this.columns) {
                if (first) {
                    first = false;
                } else {
                    sb.append(this.myFormatter.valueSeparator());
                }
                if (c.getColumnNumber() == column.asInteger()) {
                    sb.append(columnName);
                    continue;
                }
                sb.append(this.myFormatter.formatHeaderValue((Object)c.getName()));
            }
            if (emptyDoc) {
                sb.append(this.myFormatter.recordSeparator());
            }
            session.insert(sb.append(this.myFormatter.recordSeparator()).toString(), 0);
        }

        @Override
        protected boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session, @Nullable String name) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(20);
            }
            return this.insertColumn(session, null, name);
        }

        @Override
        protected String prepareMoveColumn(@NotNull GridColumn fromColumn, @NotNull ModelIndex<GridColumn> toColumn) {
            if (fromColumn == null) {
                CsvMarkup.$$$reportNull$$$0(21);
            }
            if (toColumn == null) {
                CsvMarkup.$$$reportNull$$$0(22);
            }
            int to = toColumn.value;
            int from = fromColumn.getColumnNumber();
            boolean fromBeforeTo = from < to;
            int left = Math.min(from, to);
            int right = Math.max(from, to);
            StringBuilder text = new StringBuilder();
            if (this.myHeader != null) {
                for (int i = 0; i < this.columns.size(); ++i) {
                    int newPos = i < left || i > right ? i : (i == to ? from : (fromBeforeTo ? i + 1 : i - 1));
                    text.append(this.myFormatter.formatHeaderValue((Object)((GridColumn)this.columns.get(newPos)).getName()));
                    text.append(i < this.columns.size() - 1 ? this.myFormatter.headerValueSeparator() : this.myFormatter.recordSeparator());
                }
            }
            for (GridRow row : this.rows) {
                for (int i = 0; i < this.columns.size(); ++i) {
                    int newPos = i < left || i > right ? i : (i == to ? from : (fromBeforeTo ? i + 1 : i - 1));
                    text.append(this.myFormatter.formatValue(((GridColumn)this.columns.get(newPos)).getValue(row)));
                    text.append(i < this.columns.size() - 1 ? this.myFormatter.valueSeparator() : this.myFormatter.recordSeparator());
                }
            }
            return text.toString();
        }

        @Override
        protected boolean cloneColumn(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull GridColumn column) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(23);
            }
            if (column == null) {
                CsvMarkup.$$$reportNull$$$0(24);
            }
            return this.insertColumn(session, column, null);
        }

        @Override
        protected boolean update(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<RowMutation> mutations) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(25);
            }
            if (mutations == null) {
                CsvMarkup.$$$reportNull$$$0(26);
            }
            for (RowMutation mutation : mutations) {
                GridRow row = mutation.getRow();
                List valueRanges = this.myRecords.get((int)GridRow.toRealIdx((GridRow)row)).values;
                for (ColumnQueryData data : mutation.getData()) {
                    String newValueText = this.myFormatter.formatValue(data.getObject());
                    GridColumn column = data.getColumn();
                    int rangeIdx = column.getColumnNumber() + (row instanceof NamedRow ? 1 : 0);
                    int missingRanges = rangeIdx - valueRanges.size() + 1;
                    ValueRange range = missingRanges > 0 ? this.insertMissingRanges(session, ((ValueRange)ContainerUtil.getLastItem((List)valueRanges)).getEndOffset(), missingRanges) : (ValueRange)valueRanges.get(rangeIdx);
                    session.replace((TextRange)range, newValueText);
                }
            }
            return true;
        }

        private ValueRange insertMissingRanges(@NotNull DocumentDataHookUp.UpdateSession session, int endOffset, int missingRanges) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(27);
            }
            String nullValue = this.myFormatter.formatValue(null);
            for (int i = 0; i < missingRanges; ++i) {
                session.insert(this.myFormatter.valueSeparator(), endOffset);
                session.insert(nullValue, endOffset);
            }
            return new ValueRange(endOffset - nullValue.length(), endOffset, false);
        }

        private boolean insertColumn(@NotNull DocumentDataHookUp.UpdateSession session, @Nullable GridColumn column, @Nullable String name) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(28);
            }
            String columnName = name != null ? name : (column != null ? column.getName() : "column" + (this.columns.size() + 1));
            return this.doInsertColumn(session, column, columnName);
        }

        private boolean doInsertColumn(@NotNull DocumentDataHookUp.UpdateSession session, @Nullable GridColumn column, @NotNull String name) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(29);
            }
            if (name == null) {
                CsvMarkup.$$$reportNull$$$0(30);
            }
            if (this.myHeader != null) {
                ValueRange lastColumnRange = Objects.requireNonNull((ValueRange)ContainerUtil.getLastItem((List)this.myHeader.values));
                String columnName = this.myFormatter.formatHeaderValue((Object)name);
                session.insert(this.myFormatter.headerValueSeparator() + columnName, lastColumnRange.getEndOffset());
            }
            for (int i = 0; i < this.rows.size(); ++i) {
                ValueRange lastValueRange = Objects.requireNonNull((ValueRange)ContainerUtil.getLastItem((List)this.myRecords.get((int)i).values));
                String valueText = this.myFormatter.formatValue(column != null ? column.getValue((GridRow)this.rows.get(i)) : null);
                session.insert(this.myFormatter.valueSeparator() + valueText, lastValueRange.getEndOffset());
            }
            return true;
        }

        private boolean insertRow(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<?> values) {
            CsvRecord lastRecord;
            int offset;
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(31);
            }
            if (values == null) {
                CsvMarkup.$$$reportNull$$$0(32);
            }
            int n = offset = (lastRecord = (CsvRecord)ObjectUtils.chooseNotNull((Object)((CsvRecord)ContainerUtil.getLastItem(this.myRecords)), (Object)this.myHeader)) != null ? lastRecord.range.getEndOffset() : 0;
            if (lastRecord != null && !lastRecord.hasRecordSeparator) {
                session.insert(this.myFormatter.recordSeparator(), offset);
            }
            if (this.myFormatter.requiresRowNumbers()) {
                String newRecordName = null;
                GridRow lastRow = (GridRow)ContainerUtil.getLastItem((List)this.rows);
                if (lastRow instanceof NamedRow) {
                    try {
                        newRecordName = String.valueOf(Long.parseLong(((NamedRow)lastRow).name) + 1L);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (newRecordName == null) {
                    newRecordName = String.valueOf(lastRow != null ? lastRow.getRowNum() + 1 : 1);
                }
                values = ContainerUtil.prepend(values, (Object[])new Object[]{newRecordName});
            }
            String newRecord = this.myFormatter.formatRecord(values);
            session.insert(newRecord, offset);
            if (newRecord.isEmpty()) {
                session.insert(this.myFormatter.recordSeparator(), offset);
            }
            return true;
        }

        private void leaveColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<GridColumn> columns, @NotNull CsvRecord record, @NotNull GridRow row) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(33);
            }
            if (columns == null) {
                CsvMarkup.$$$reportNull$$$0(34);
            }
            if (record == null) {
                CsvMarkup.$$$reportNull$$$0(35);
            }
            if (row == null) {
                CsvMarkup.$$$reportNull$$$0(36);
            }
            if (columns.isEmpty()) {
                session.delete(record.range);
                return;
            }
            List values = ContainerUtil.map(columns, column -> column.getValue(row));
            if (row instanceof NamedRow) {
                values = ContainerUtil.prepend((List)values, (Object[])new Object[]{((NamedRow)row).name});
            }
            String recordText = this.myFormatter.formatRecord(values);
            session.replace(record.range, recordText);
            if (record.hasRecordSeparator) {
                session.insert(this.myFormatter.recordSeparator(), record.range.getEndOffset());
            }
        }

        private void leaveColumns(@NotNull DocumentDataHookUp.UpdateSession session, @NotNull List<GridColumn> columns, @NotNull CsvRecord headerRecord) {
            if (session == null) {
                CsvMarkup.$$$reportNull$$$0(37);
            }
            if (columns == null) {
                CsvMarkup.$$$reportNull$$$0(38);
            }
            if (headerRecord == null) {
                CsvMarkup.$$$reportNull$$$0(39);
            }
            List values = headerRecord.values;
            int valuesStart = ((ValueRange)values.get(this.myFormatter.requiresRowNumbers() ? 1 : 0)).getStartOffset();
            int valuesEnd = ((ValueRange)values.getLast()).getEndOffset();
            StringBuilder sb = new StringBuilder();
            for (GridColumn column : columns) {
                sb.append(this.myFormatter.formatHeaderValue((Object)column.getName())).append(this.myFormatter.headerValueSeparator());
            }
            sb.setLength(!sb.isEmpty() ? sb.length() - this.myFormatter.headerValueSeparator().length() : 0);
            session.replace(TextRange.create((int)valuesStart, (int)valuesEnd), sb.toString());
        }

        @NotNull
        private List<GridColumn> getColumnsToLeave(@NotNull List<GridColumn> orderedColumnsToDelete) {
            if (orderedColumnsToDelete == null) {
                CsvMarkup.$$$reportNull$$$0(40);
            }
            ArrayList<GridColumn> columnsToLeave = new ArrayList<GridColumn>(this.columns.size() - orderedColumnsToDelete.size());
            Iterator<GridColumn> toDeleteIterator = orderedColumnsToDelete.iterator();
            Iterator allColumnsIterator = this.columns.iterator();
            block0: while (allColumnsIterator.hasNext()) {
                GridColumn column;
                GridColumn toDelete;
                GridColumn gridColumn = toDelete = toDeleteIterator.hasNext() ? toDeleteIterator.next() : null;
                while (!(column = (GridColumn)allColumnsIterator.next()).equals(toDelete)) {
                    columnsToLeave.add(column);
                    if (allColumnsIterator.hasNext()) continue;
                    continue block0;
                }
            }
            ArrayList<GridColumn> arrayList = columnsToLeave;
            if (arrayList == null) {
                CsvMarkup.$$$reportNull$$$0(41);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 41 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formatter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "records";
                    break;
                }
                case 4: 
                case 6: 
                case 7: 
                case 9: 
                case 11: 
                case 14: 
                case 17: 
                case 20: 
                case 23: 
                case 25: 
                case 27: 
                case 28: 
                case 29: 
                case 31: 
                case 33: 
                case 37: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortedRows";
                    break;
                }
                case 8: 
                case 36: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "row";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sortedColumns";
                    break;
                }
                case 12: 
                case 15: 
                case 18: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "column";
                    break;
                }
                case 13: 
                case 30: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 16: 
                case 19: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columnName";
                    break;
                }
                case 21: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromColumn";
                    break;
                }
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toColumn";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mutations";
                    break;
                }
                case 32: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "values";
                    break;
                }
                case 34: 
                case 38: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
                case 35: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "record";
                    break;
                }
                case 39: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "headerRecord";
                    break;
                }
                case 40: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "orderedColumnsToDelete";
                    break;
                }
                case 41: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvMarkup";
                    break;
                }
                case 41: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnsToLeave";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRows";
                    break;
                }
                case 6: 
                case 31: 
                case 32: {
                    objectArray = objectArray;
                    objectArray[2] = "insertRow";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneRow";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteColumns";
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "renameColumn";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "generateMissingPartOfHeaderRow";
                    break;
                }
                case 17: 
                case 18: 
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "generateHeaderRow";
                    break;
                }
                case 20: 
                case 28: {
                    objectArray = objectArray;
                    objectArray[2] = "insertColumn";
                    break;
                }
                case 21: 
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareMoveColumn";
                    break;
                }
                case 23: 
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "cloneColumn";
                    break;
                }
                case 25: 
                case 26: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "insertMissingRanges";
                    break;
                }
                case 29: 
                case 30: {
                    objectArray = objectArray;
                    objectArray[2] = "doInsertColumn";
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: {
                    objectArray = objectArray;
                    objectArray[2] = "leaveColumns";
                    break;
                }
                case 40: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnsToLeave";
                    break;
                }
                case 41: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 41 -> new IllegalStateException(string);
            };
        }
    }

    protected static class CsvUpdateSession
    extends DocumentDataHookUp.UpdateSession {
        private CsvFormat myNewFormat;

        private CsvUpdateSession(@NotNull Document document, int rightShift) {
            if (document == null) {
                CsvUpdateSession.$$$reportNull$$$0(0);
            }
            super(document, rightShift);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/database/datagrid/CsvDocumentDataHookUp$CsvUpdateSession", "<init>"));
        }
    }
}

