/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.database.data.types.DataTypeConversion;
import com.intellij.openapi.ide.Sizeable;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public class GridTransferableData
implements Transferable,
Sizeable {
    public static final DataFlavor ourFlavor = new DataFlavor(GridTransferableData.class, "Cells");
    private final List<DataTypeConversion.Builder> myConversions;
    private final Transferable myTransferable;
    private final int myFirstRowIdx;
    private final int myFirstColumnIdx;
    private final int myRowsCount;

    public GridTransferableData(@NotNull List<DataTypeConversion.Builder> conversions, @NotNull Transferable transferable, int firstRowIdx, int firstColumnIdx, int rowsCount) {
        if (conversions == null) {
            GridTransferableData.$$$reportNull$$$0(0);
        }
        if (transferable == null) {
            GridTransferableData.$$$reportNull$$$0(1);
        }
        this.myConversions = conversions;
        this.myTransferable = transferable;
        this.myFirstRowIdx = firstRowIdx;
        this.myFirstColumnIdx = firstColumnIdx;
        this.myRowsCount = rowsCount;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])ArrayUtil.mergeArrays((Object[])((DataFlavor[])ContainerUtil.ar((Object[])new DataFlavor[]{ourFlavor})), (Object[])this.myTransferable.getTransferDataFlavors());
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == ourFlavor || this.myTransferable.isDataFlavorSupported(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return flavor == ourFlavor ? this : this.myTransferable.getTransferData(flavor);
    }

    @NotNull
    public List<DataTypeConversion.Builder> getConversions() {
        List<DataTypeConversion.Builder> list = this.myConversions;
        if (list == null) {
            GridTransferableData.$$$reportNull$$$0(2);
        }
        return list;
    }

    public int getFirstRowIdx() {
        return this.myFirstRowIdx;
    }

    public int getRowsCount() {
        return this.myRowsCount;
    }

    public int getColumnsCount() {
        return this.myConversions.size() / this.myRowsCount;
    }

    public int getFirstColumnIdx() {
        return this.myFirstColumnIdx;
    }

    @NotNull
    public Transferable getTransferable() {
        Transferable transferable = this.myTransferable;
        if (transferable == null) {
            GridTransferableData.$$$reportNull$$$0(3);
        }
        return transferable;
    }

    public @Range(from=0L, to=0x7FFFFFFFL) int getSize() {
        int size = 0;
        for (DataTypeConversion.Builder conversion : this.myConversions) {
            size += Math.max(100, conversion.size());
        }
        return size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conversions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transferable";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/GridTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/GridTransferableData";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getConversions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTransferable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

