/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.ui.painter.hints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.ui.painter.hints.CssRule;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\u0006J\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\u0006J\f\u0010\u000b\u001a\u00020\u0006*\u00020\u0006H\u0002J\f\u0010\f\u001a\u00020\u0006*\u00020\u0006H\u0002J\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/jewel/ui/painter/hints/CssParser;", "", "<init>", "()V", "parseCssBlock", "", "", "Lorg/jetbrains/jewel/ui/painter/hints/CssRule;", "cssText", "parseInlineStyle", "style", "removeComments", "removeCDATAWrapper", "parseProperties", "propertiesText", "Companion", "intellij.platform.jewel.ui"})
@SourceDebugExtension(value={"SMAP\nEmbeddedToInlineCssStyleSvgPatchHint.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedToInlineCssStyleSvgPatchHint.kt\norg/jetbrains/jewel/ui/painter/hints/CssParser\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,416:1\n1342#2:417\n1343#2:424\n1342#2,2:439\n1586#3:418\n1661#3,3:419\n1915#3,2:422\n1642#3,10:425\n1915#3:435\n1916#3:437\n1652#3:438\n1#4:436\n*S KotlinDebug\n*F\n+ 1 EmbeddedToInlineCssStyleSvgPatchHint.kt\norg/jetbrains/jewel/ui/painter/hints/CssParser\n*L\n271#1:417\n271#1:424\n332#1:439,2\n276#1:418\n276#1:419,3\n280#1:422,2\n298#1:425,10\n298#1:435\n298#1:437\n298#1:438\n298#1:436\n*E\n"})
final class CssParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex COMMENT_PATTERN = new Regex("/\\*.*?\\*/", RegexOption.DOT_MATCHES_ALL);
    @NotNull
    private static final Regex RULE_PATTERN;
    @NotNull
    private static final Regex PROPERTY_PATTERN;
    @NotNull
    private static final Regex CLASS_SELECTOR_PATTERN;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, CssRule> parseCssBlock(@NotNull String cssText) {
        Intrinsics.checkNotNullParameter((Object)cssText, (String)"cssText");
        String normalizedCssText = this.removeCDATAWrapper(this.removeComments(cssText));
        if (StringsKt.isBlank((CharSequence)normalizedCssText)) {
            return MapsKt.emptyMap();
        }
        Map rules = new LinkedHashMap();
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)RULE_PATTERN, (CharSequence)normalizedCssText, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            MatchResult match = (MatchResult)element$iv;
            boolean bl = false;
            MatchResult.Destructured destructured = match.getDestructured();
            String selectorPart = (String)destructured.getMatch().getGroupValues().get(1);
            String propertiesPart = (String)destructured.getMatch().getGroupValues().get(2);
            char[] cArray = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)selectorPart, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(((Object)StringsKt.trim((CharSequence)((CharSequence)it))).toString());
            }
            List selectors = (List)destination$iv$iv;
            Map<String, String> properties = this.parseProperties(propertiesPart);
            Iterable $this$forEach$iv2 = selectors;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String selector = (String)element$iv2;
                boolean bl3 = false;
                if (!CLASS_SELECTOR_PATTERN.matches((CharSequence)selector)) continue;
                rules.put(selector, new CssRule(selector, properties));
            }
        }
        return rules;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> parseInlineStyle(@NotNull String style) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        char[] cArray = new char[]{';'};
        Iterable $this$mapNotNull$iv = StringsKt.split$default((CharSequence)style, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String declaration = (String)element$iv$iv;
            boolean bl2 = false;
            char[] cArray2 = new char[]{':'};
            List parts = StringsKt.split$default((CharSequence)declaration, (char[])cArray2, (boolean)false, (int)2, (int)2, null);
            if (parts.size() != 2) {
                pair = null;
            } else {
                String name = ((Object)StringsKt.trim((CharSequence)((String)parts.get(0)))).toString();
                String value = ((Object)StringsKt.trim((CharSequence)((String)parts.get(1)))).toString();
                pair = ((CharSequence)name).length() > 0 && ((CharSequence)value).length() > 0 ? TuplesKt.to((Object)name, (Object)value) : null;
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv));
    }

    private final String removeComments(String $this$removeComments) {
        CharSequence charSequence = $this$removeComments;
        Regex regex = COMMENT_PATTERN;
        String string = "";
        return regex.replace(charSequence, string);
    }

    private final String removeCDATAWrapper(String $this$removeCDATAWrapper) {
        CharSequence charSequence = $this$removeCDATAWrapper;
        Regex regex = new Regex("^\\s*<!\\[CDATA\\[");
        String string = "";
        charSequence = regex.replace(charSequence, string);
        regex = new Regex("]]>\\s*$");
        string = "";
        return ((Object)StringsKt.trim((CharSequence)regex.replace(charSequence, string))).toString();
    }

    private final Map<String, String> parseProperties(String propertiesText) {
        Map properties = new LinkedHashMap();
        Sequence $this$forEach$iv = Regex.findAll$default((Regex)PROPERTY_PATTERN, (CharSequence)propertiesText, (int)0, (int)2, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MatchResult match = (MatchResult)element$iv;
            boolean bl = false;
            MatchResult.Destructured destructured = match.getDestructured();
            String name = (String)destructured.getMatch().getGroupValues().get(1);
            String value = (String)destructured.getMatch().getGroupValues().get(2);
            String normalizedName = ((Object)StringsKt.trim((CharSequence)name)).toString();
            String normalizedValue = ((Object)StringsKt.trim((CharSequence)value)).toString();
            if (!(((CharSequence)normalizedName).length() > 0) || !(((CharSequence)normalizedValue).length() > 0)) continue;
            properties.put(normalizedName, normalizedValue);
        }
        return properties;
    }

    static {
        Object[] objectArray = new RegexOption[]{RegexOption.DOT_MATCHES_ALL, RegexOption.MULTILINE};
        RULE_PATTERN = new Regex("([^{]+)\\{([^}]+)\\}", SetsKt.setOf((Object[])objectArray));
        PROPERTY_PATTERN = new Regex("([^:]+):([^;]+);?");
        CLASS_SELECTOR_PATTERN = new Regex("^\\.[a-zA-Z0-9_-]+$");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/jewel/ui/painter/hints/CssParser$Companion;", "", "<init>", "()V", "COMMENT_PATTERN", "Lkotlin/text/Regex;", "RULE_PATTERN", "PROPERTY_PATTERN", "CLASS_SELECTOR_PATTERN", "intellij.platform.jewel.ui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

