/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.ir;

import com.intellij.rml.dfa.ir.IrProject;
import com.intellij.rml.dfa.ir.ast.IrCloner;
import com.intellij.rml.dfa.ir.ast.IrFunctionDecl;
import com.intellij.rml.dfa.ir.ast.IrFunctionID;
import com.intellij.rml.dfa.ir.ast.IrRecordDecl;
import com.intellij.rml.dfa.ir.ast.IrRecordID;
import com.intellij.rml.dfa.ir.ast.IrRecursiveVisitor;
import com.intellij.rml.dfa.ir.ast.IrStaticCallStmt;
import com.intellij.rml.dfa.ir.ast.IrTopLevelDecl;
import com.intellij.rml.dfa.ir.ast.IrTopLevelVisitor;
import com.intellij.rml.dfa.ir.ast.IrVirtualCallStmt;
import com.intellij.rml.dfa.ir.ast.IrVisitor;
import com.intellij.rml.dfa.utils.FormatHelperKt;
import com.intellij.rml.dfa.utils.graph.Graph;
import com.intellij.rml.dfa.utils.graph.GraphBuilder;
import com.intellij.rml.dfa.utils.graph.GraphKt;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020\u00012\u0006\u0010#\u001a\u00020$H\u0016J4\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120(2\u0006\u0010)\u001a\u00020\u000e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0+H\u0002J4\u0010,\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u00122\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120(2\u0006\u0010)\u001a\u00020\u000e2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000f0+H\u0002J\u0016\u0010-\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\u0006\u0010.\u001a\u00020/H\u0016J \u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00032\b\u0010&\u001a\u0004\u0018\u00010\u00122\u0006\u0010)\u001a\u00020\u000eH\u0016R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0015\u001a\"\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0012\u0004\u0012\u00020\u000e0\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00030\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001a\u00a8\u00061"}, d2={"Lcom/intellij/rml/dfa/impl/ir/IrProjectImpl;", "Lcom/intellij/rml/dfa/ir/IrProject;", "declarations", "", "Lcom/intellij/rml/dfa/ir/ast/IrTopLevelDecl;", "loggingEnabled", "", "buildCallGraph", "<init>", "(Ljava/util/List;ZZ)V", "getDeclarations", "()Ljava/util/List;", "allFunctions", "Lcom/intellij/util/containers/MultiMap;", "", "Lcom/intellij/rml/dfa/ir/ast/IrFunctionID;", "recordIdToDecl", "", "Lcom/intellij/rml/dfa/ir/ast/IrRecordID;", "Lcom/intellij/rml/dfa/ir/ast/IrRecordDecl;", "recordsHierarchy", "virtualResolveCache", "Lkotlin/Pair;", "callGraph", "Lcom/intellij/rml/dfa/utils/graph/Graph;", "getCallGraph", "()Lcom/intellij/rml/dfa/utils/graph/Graph;", "callGraph$delegate", "Lkotlin/Lazy;", "accept", "", "visitor", "Lcom/intellij/rml/dfa/ir/ast/IrVisitor;", "acceptChildren", "clone", "cloner", "Lcom/intellij/rml/dfa/ir/ast/IrCloner;", "processSuperRecords", "record", "processed", "", "signature", "targets", "", "processSubRecords", "getTargetsOfVirtualCall", "callStmt", "Lcom/intellij/rml/dfa/ir/ast/IrVirtualCallStmt;", "resolveTargetHierarchy", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nIrProjectImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrProjectImpl.kt\ncom/intellij/rml/dfa/impl/ir/IrProjectImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,110:1\n812#2,12:111\n1#3:123\n383#4,7:124\n*S KotlinDebug\n*F\n+ 1 IrProjectImpl.kt\ncom/intellij/rml/dfa/impl/ir/IrProjectImpl\n*L\n100#1:111,12\n84#1:124,7\n*E\n"})
public final class IrProjectImpl
implements IrProject {
    @NotNull
    private final List<IrTopLevelDecl> declarations;
    @NotNull
    private final MultiMap<String, IrFunctionID> allFunctions;
    @NotNull
    private final Map<IrRecordID, IrRecordDecl> recordIdToDecl;
    @NotNull
    private final MultiMap<IrRecordID, IrRecordID> recordsHierarchy;
    @NotNull
    private final Map<Pair<IrRecordID, String>, List<IrFunctionID>> virtualResolveCache;
    @NotNull
    private final Lazy callGraph$delegate;

    public IrProjectImpl(@NotNull List<? extends IrTopLevelDecl> declarations, boolean loggingEnabled, boolean buildCallGraph) {
        Intrinsics.checkNotNullParameter(declarations, (String)"declarations");
        this.declarations = declarations;
        this.allFunctions = new MultiMap();
        this.recordIdToDecl = new LinkedHashMap();
        this.recordsHierarchy = new MultiMap();
        this.virtualResolveCache = new LinkedHashMap();
        this.callGraph$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Graph<IrFunctionID>>(this, buildCallGraph, loggingEnabled){
            final /* synthetic */ IrProjectImpl this$0;
            final /* synthetic */ boolean $buildCallGraph;
            final /* synthetic */ boolean $loggingEnabled;
            {
                this.this$0 = $receiver;
                this.$buildCallGraph = $buildCallGraph;
                this.$loggingEnabled = $loggingEnabled;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final Graph<IrFunctionID> invoke() {
                void $this$filterIsInstanceTo$iv$iv;
                MultiMap calls = new MultiMap();
                Iterable $this$filterIsInstance$iv = this.this$0.getDeclarations();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof IrFunctionDecl)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List funcDecls = (List)destination$iv$iv;
                if (this.$buildCallGraph) {
                    FormatHelperKt.mapWithLogging((Collection)funcDecls, (boolean)this.$loggingEnabled, (String)"Building Call Graph", (Function1)((Function1)new Function1<IrFunctionDecl, Unit>((MultiMap<IrFunctionID, IrFunctionID>)calls, this.this$0){
                        final /* synthetic */ MultiMap<IrFunctionID, IrFunctionID> $calls;
                        final /* synthetic */ IrProjectImpl this$0;
                        {
                            this.$calls = $calls;
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(IrFunctionDecl function2) {
                            Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
                            function2.accept((IrTopLevelVisitor)new IrRecursiveVisitor(this.$calls, function2, this.this$0){
                                final /* synthetic */ MultiMap<IrFunctionID, IrFunctionID> $calls;
                                final /* synthetic */ IrFunctionDecl $function;
                                final /* synthetic */ IrProjectImpl this$0;
                                {
                                    this.$calls = $calls;
                                    this.$function = $function;
                                    this.this$0 = $receiver;
                                }

                                public void visitStaticCallStmt(IrStaticCallStmt stmt) {
                                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                                    this.$calls.putValue((Object)this.$function.getName(), (Object)stmt.getCallee());
                                }

                                public void visitVirtualCallStmt(IrVirtualCallStmt stmt) {
                                    Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
                                    this.$calls.putValues((Object)this.$function.getName(), (Collection)this.this$0.getTargetsOfVirtualCall(stmt));
                                }
                            });
                        }
                    }));
                }
                return GraphKt.buildGraph((Function1)((Function1)new Function1<GraphBuilder<IrFunctionID>, Unit>((List<IrFunctionDecl>)funcDecls, (MultiMap<IrFunctionID, IrFunctionID>)calls){
                    final /* synthetic */ List<IrFunctionDecl> $funcDecls;
                    final /* synthetic */ MultiMap<IrFunctionID, IrFunctionID> $calls;
                    {
                        this.$funcDecls = $funcDecls;
                        this.$calls = $calls;
                        super(1);
                    }

                    public final void invoke(GraphBuilder<IrFunctionID> $this$buildGraph) {
                        Intrinsics.checkNotNullParameter($this$buildGraph, (String)"$this$buildGraph");
                        for (IrFunctionDecl function2 : this.$funcDecls) {
                            $this$buildGraph.addNode((Object)function2.getName());
                        }
                        for (IrFunctionID caller : this.$calls.keySet()) {
                            for (IrFunctionID callee : this.$calls.get((Object)caller)) {
                                Intrinsics.checkNotNull((Object)caller);
                                Intrinsics.checkNotNull((Object)callee);
                                $this$buildGraph.addEdge((Object)caller, (Object)callee);
                            }
                        }
                    }
                }));
            }
        }));
        Iterable $this$filterIsInstance$iv = this.getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable object2 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : object2) {
            if (!(element$iv$iv instanceof IrRecordDecl)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (IrRecordDecl record : (List)destination$iv$iv) {
            this.recordIdToDecl.put(record.getName(), record);
            for (IrRecordID irRecordID : record.getSuperRecords()) {
                this.recordsHierarchy.putValue((Object)irRecordID, (Object)record.getName());
            }
            for (Map.Entry entry : record.getVirtualMethods().entrySet()) {
                String signature = (String)entry.getKey();
                IrFunctionID function2 = (IrFunctionID)entry.getValue();
                this.allFunctions.putValue((Object)signature, (Object)function2);
            }
        }
    }

    @NotNull
    public List<IrTopLevelDecl> getDeclarations() {
        return this.declarations;
    }

    @NotNull
    public Graph<IrFunctionID> getCallGraph() {
        Lazy lazy = this.callGraph$delegate;
        return (Graph)lazy.getValue();
    }

    public void accept(@NotNull IrVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        visitor2.visitProject((IrProject)this);
    }

    public void acceptChildren(@NotNull IrVisitor visitor2) {
        Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
        for (IrTopLevelDecl declaration : this.getDeclarations()) {
            declaration.accept((IrTopLevelVisitor)visitor2);
        }
    }

    @NotNull
    public IrProject clone(@NotNull IrCloner cloner) {
        Intrinsics.checkNotNullParameter((Object)cloner, (String)"cloner");
        return cloner.cloneProject((IrProject)this);
    }

    private final void processSuperRecords(IrRecordID record, Set<IrRecordID> processed, String signature, List<IrFunctionID> targets) {
        for (IrRecordID superRecord : ((IrRecordDecl)MapsKt.getValue(this.recordIdToDecl, (Object)record)).getSuperRecords()) {
            if (processed.contains(superRecord)) continue;
            ((Collection)processed).add(superRecord);
            IrFunctionID target = (IrFunctionID)((IrRecordDecl)MapsKt.getValue(this.recordIdToDecl, (Object)superRecord)).getVirtualMethods().get(signature);
            if (target == null) {
                this.processSuperRecords(superRecord, processed, signature, targets);
                continue;
            }
            ((Collection)targets).add(target);
        }
    }

    private final void processSubRecords(IrRecordID record, Set<IrRecordID> processed, String signature, List<IrFunctionID> targets) {
        ((Collection)processed).add(record);
        IrFunctionID irFunctionID = (IrFunctionID)((IrRecordDecl)MapsKt.getValue(this.recordIdToDecl, (Object)record)).getVirtualMethods().get(signature);
        if (irFunctionID != null) {
            IrFunctionID it = irFunctionID;
            boolean bl = false;
            ((Collection)targets).add(it);
        }
        for (IrRecordID subRecord : this.recordsHierarchy.get((Object)record)) {
            if (processed.contains(subRecord)) continue;
            Intrinsics.checkNotNull((Object)subRecord);
            this.processSubRecords(subRecord, processed, signature, targets);
        }
    }

    @NotNull
    public List<IrFunctionID> getTargetsOfVirtualCall(@NotNull IrVirtualCallStmt callStmt) {
        Intrinsics.checkNotNullParameter((Object)callStmt, (String)"callStmt");
        return this.resolveTargetHierarchy(callStmt.getReceiverDeclaredRecord(), callStmt.getSignature());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<IrFunctionID> resolveTargetHierarchy(@Nullable IrRecordID record, @NotNull String signature) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Map<Pair<IrRecordID, String>, List<IrFunctionID>> map2 = this.virtualResolveCache;
        Pair key$iv = TuplesKt.to((Object)record, (Object)signature);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            List list;
            boolean bl = false;
            if (record != null) {
                List targets = new ArrayList();
                this.processSubRecords(record, new LinkedHashSet(), signature, targets);
                if (!((IrRecordDecl)MapsKt.getValue(this.recordIdToDecl, (Object)record)).getVirtualMethods().containsKey(signature)) {
                    this.processSuperRecords(record, new LinkedHashSet(), signature, targets);
                }
                list = targets;
            } else {
                Collection collection = this.allFunctions.get((Object)signature);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"get(...)");
                list = CollectionsKt.toList((Iterable)collection);
            }
            List answer$iv = list;
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (List)object;
    }
}

