/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.impl.utils.graph;

import com.intellij.rml.dfa.impl.utils.graph.GraphAlgorithmsImpl;
import com.intellij.rml.dfa.impl.utils.graph.GraphAlgorithmsImplKt;
import com.intellij.rml.dfa.impl.utils.graph.LengauerTarjanAlgorithmKt;
import com.intellij.rml.dfa.utils.graph.CFGAlgorithms;
import com.intellij.rml.dfa.utils.graph.ControlFlowGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u001d\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u001eJ\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0014J\u001b\u0010\"\u001a\b\u0012\u0004\u0012\u00028\u00000\u00142\u0006\u0010#\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010$R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR)\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\rR)\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000b8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000f\u001a\u0004\b\u0011\u0010\rR!\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00148VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000f\u001a\u0004\b\u0015\u0010\u0016R \u0010\u0018\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00140\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/intellij/rml/dfa/impl/utils/graph/CFGAlgorithmsImpl;", "T", "Lcom/intellij/rml/dfa/impl/utils/graph/GraphAlgorithmsImpl;", "Lcom/intellij/rml/dfa/utils/graph/CFGAlgorithms;", "cfg", "Lcom/intellij/rml/dfa/utils/graph/ControlFlowGraph;", "<init>", "(Lcom/intellij/rml/dfa/utils/graph/ControlFlowGraph;)V", "getCfg", "()Lcom/intellij/rml/dfa/utils/graph/ControlFlowGraph;", "dominators", "", "getDominators", "()Ljava/util/Map;", "dominators$delegate", "Lkotlin/Lazy;", "postDominators", "getPostDominators", "postDominators$delegate", "loopEntryNodes", "", "getLoopEntryNodes", "()Ljava/util/Set;", "loopEntryNodes$delegate", "loopStatements", "", "dominates", "", "node1", "node2", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "postDominates", "findStartNodes", "", "getLoopStatement", "entry", "(Ljava/lang/Object;)Ljava/util/Set;", "intellij.rml.dfa.impl"})
@SourceDebugExtension(value={"SMAP\nGraphAlgorithmsImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GraphAlgorithmsImpl.kt\ncom/intellij/rml/dfa/impl/utils/graph/CFGAlgorithmsImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,285:1\n1#2:286\n777#3:287\n873#3,2:288\n1915#3,2:290\n*S KotlinDebug\n*F\n+ 1 GraphAlgorithmsImpl.kt\ncom/intellij/rml/dfa/impl/utils/graph/CFGAlgorithmsImpl\n*L\n264#1:287\n264#1:288,2\n266#1:290,2\n*E\n"})
public final class CFGAlgorithmsImpl<T>
extends GraphAlgorithmsImpl<T>
implements CFGAlgorithms<T> {
    @NotNull
    private final ControlFlowGraph<T> cfg;
    @NotNull
    private final Lazy dominators$delegate;
    @NotNull
    private final Lazy postDominators$delegate;
    @NotNull
    private final Lazy loopEntryNodes$delegate;
    @NotNull
    private final Map<T, Set<T>> loopStatements;

    public CFGAlgorithmsImpl(@NotNull ControlFlowGraph<T> cfg2) {
        Intrinsics.checkNotNullParameter(cfg2, (String)"cfg");
        super(cfg2.getGraph());
        this.cfg = cfg2;
        this.dominators$delegate = LazyKt.lazy((Function0)new Function0<Map<T, ? extends T>>(this){
            final /* synthetic */ CFGAlgorithmsImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<T, T> invoke() {
                return LengauerTarjanAlgorithmKt.findDominators(this.this$0.getCfg());
            }
        });
        this.postDominators$delegate = LazyKt.lazy((Function0)new Function0<Map<T, ? extends T>>(this){
            final /* synthetic */ CFGAlgorithmsImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Map<T, T> invoke() {
                return LengauerTarjanAlgorithmKt.findDominators(GraphAlgorithmsImplKt.inverted(this.this$0.getCfg()));
            }
        });
        this.loopEntryNodes$delegate = LazyKt.lazy((Function0)new Function0<Set<T>>(this){
            final /* synthetic */ CFGAlgorithmsImpl<T> this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Set<T> invoke() {
                return this.this$0.getBackEdges().keySet();
            }
        });
        this.loopStatements = new LinkedHashMap();
    }

    @NotNull
    public final ControlFlowGraph<T> getCfg() {
        return this.cfg;
    }

    @NotNull
    public Map<T, T> getDominators() {
        Lazy lazy = this.dominators$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public Map<T, T> getPostDominators() {
        Lazy lazy = this.postDominators$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public Set<T> getLoopEntryNodes() {
        Lazy lazy = this.loopEntryNodes$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (Set)object;
    }

    public boolean dominates(T node1, T node2) {
        T curNode = node2;
        while (curNode != null && !Intrinsics.areEqual(curNode, node1)) {
            curNode = this.getDominators().get(curNode);
        }
        return Intrinsics.areEqual(curNode, node1);
    }

    public boolean postDominates(T node1, T node2) {
        T curNode = node2;
        while (curNode != null && !Intrinsics.areEqual(curNode, node1)) {
            curNode = this.getPostDominators().get(curNode);
        }
        return Intrinsics.areEqual(curNode, node1);
    }

    @Override
    @NotNull
    protected List<T> findStartNodes() {
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.cfg.getStartNode()), (Iterable)CollectionsKt.minus((Iterable)super.findStartNodes(), (Object)this.cfg.getStartNode()));
    }

    @NotNull
    public Set<T> getLoopStatement(T entry) {
        Set<T> set = this.loopStatements.get(entry);
        if (set != null) {
            Set<T> it = set;
            boolean bl = false;
            return it;
        }
        Set nodes = new LinkedHashSet();
        ((Collection)nodes).add(entry);
        for (Object source : this.getBackEdges().get(entry)) {
            CFGAlgorithmsImpl.getLoopStatement$traverseBack(nodes, this, entry, source);
        }
        this.loopStatements.put(entry, nodes);
        return nodes;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> void getLoopStatement$traverseBack(Set<T> nodes, CFGAlgorithmsImpl<T> this$0, T $entry, T node) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        if (nodes.contains(node)) {
            return;
        }
        ((Collection)nodes).add(node);
        Iterable $this$filter$iv = this$0.getGraph().incomingNodes(node);
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            Object it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(this$0.topologicalIndex(it) > this$0.topologicalIndex($entry))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.iterator();
        while (object.hasNext()) {
            Object element$iv;
            Object it = element$iv = object.next();
            boolean bl = false;
            CFGAlgorithmsImpl.getLoopStatement$traverseBack(nodes, this$0, $entry, it);
        }
    }
}

