/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.text.CharArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005*\u00020\u00062\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0012\u0010\u000e\u001a\u00020\u000f*\u00020\n2\u0006\u0010\f\u001a\u00020\bJ \u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\n2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0006J%\u0010\u0013\u001a\u0004\u0018\u00010\b*\u00020\n2\u0006\u0010\f\u001a\u00020\b2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0014R\u001b\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016*\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0015\u0010\u001d\u001a\u00020\u0017*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0015\u0010 \u001a\u00020\u0011*\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListUtils;", "", "<init>", "()V", "getListItemAt", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "Lcom/intellij/psi/PsiFile;", "offset", "", "document", "Lcom/intellij/openapi/editor/Document;", "getListItemAtLine", "lineNumber", "getListItemAtLineSafely", "getLineIndentRange", "Lcom/intellij/openapi/util/TextRange;", "getLineIndentSpaces", "", "file", "getLineIndentInnerSpacesLength", "(Lcom/intellij/openapi/editor/Document;ILcom/intellij/psi/PsiFile;)Ljava/lang/Integer;", "items", "", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "getItems", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;)Ljava/util/List;", "sublists", "getSublists", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;)Ljava/util/List;", "list", "getList", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;)Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "normalizedMarker", "getNormalizedMarker", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;)Ljava/lang/String;", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nListUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListUtils.kt\norg/intellij/plugins/markdown/editor/lists/ListUtils\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n67#2:89\n627#3,6:90\n4253#4,12:96\n4253#4,12:108\n1#5:120\n*S KotlinDebug\n*F\n+ 1 ListUtils.kt\norg/intellij/plugins/markdown/editor/lists/ListUtils\n*L\n34#1:89\n74#1:90,6\n77#1:96,12\n79#1:108,12\n*E\n"})
public final class ListUtils {
    @NotNull
    public static final ListUtils INSTANCE = new ListUtils();

    private ListUtils() {
    }

    @Nullable
    public final MarkdownListItem getListItemAt(@NotNull PsiFile $this$getListItemAt, int offset, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getListItemAt, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return this.getListItemAtLine($this$getListItemAt, document.getLineNumber(offset), document);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final MarkdownListItem getListItemAtLine(@NotNull PsiFile $this$getListItemAtLine, int lineNumber, @NotNull Document document) {
        void $this$parentOfType$iv;
        PsiElement elementAtOffset;
        Intrinsics.checkNotNullParameter((Object)$this$getListItemAtLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        int lineStart = document.getLineStartOffset(lineNumber);
        int lineEnd = document.getLineEndOffset(lineNumber);
        int searchingOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)lineStart, (int)(lineEnd - 1), (String)" \t\n");
        if (searchingOffset < lineStart) {
            return null;
        }
        PsiElement psiElement = PsiUtilCore.getElementAtOffset((PsiFile)$this$getListItemAtLine, (int)searchingOffset);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElementAtOffset(...)");
        PsiElement psiElement2 = elementAtOffset = psiElement;
        boolean withSelf$iv = true;
        boolean $i$f$parentOfType = false;
        return (MarkdownListItem)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownListItem.class, (boolean)false);
    }

    @Nullable
    public final MarkdownListItem getListItemAtLineSafely(@NotNull PsiFile $this$getListItemAtLineSafely, int lineNumber, @NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)$this$getListItemAtLineSafely, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return (0 <= lineNumber ? lineNumber < document.getLineCount() : false) ? this.getListItemAtLine($this$getListItemAtLineSafely, lineNumber, document) : null;
    }

    @NotNull
    public final TextRange getLineIndentRange(@NotNull Document $this$getLineIndentRange, int lineNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineIndentRange, (String)"<this>");
        int lineStart = $this$getLineIndentRange.getLineStartOffset(lineNumber);
        int nonWsStart = CharArrayUtil.shiftForward((CharSequence)$this$getLineIndentRange.getCharsSequence(), (int)lineStart, (String)" \t>");
        TextRange textRange = TextRange.create((int)lineStart, (int)nonWsStart);
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        return textRange;
    }

    @Nullable
    public final String getLineIndentSpaces(@NotNull Document $this$getLineIndentSpaces, int lineNumber, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)$this$getLineIndentSpaces, (String)"<this>");
        PsiFile psiFile = file;
        if (psiFile == null) {
            Document $this$getLineIndentSpaces_u24lambda_u240 = $this$getLineIndentSpaces;
            boolean bl = false;
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile($this$getLineIndentSpaces_u24lambda_u240);
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            Project project = ProjectUtil.guessProjectForFile((VirtualFile)virtualFile2);
            if (project == null) {
                return null;
            }
            Project project2 = project;
            psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile($this$getLineIndentSpaces_u24lambda_u240);
            if (psiFile == null) {
                return null;
            }
        }
        PsiFile psiFile2 = psiFile;
        int tabSize = CodeStyle.getFacade((PsiFile)psiFile2).getTabSize();
        String string = $this$getLineIndentSpaces.getText(this.getLineIndentRange($this$getLineIndentSpaces, lineNumber));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String indentStr = string;
        return StringsKt.replace$default((String)indentStr, (String)"\t", (String)StringsKt.repeat((CharSequence)" ", (int)tabSize), (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String getLineIndentSpaces$default(ListUtils listUtils, Document document, int n, PsiFile psiFile, int n2, Object object) {
        if ((n2 & 2) != 0) {
            psiFile = null;
        }
        return listUtils.getLineIndentSpaces(document, n, psiFile);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final Integer getLineIndentInnerSpacesLength(@NotNull Document $this$getLineIndentInnerSpacesLength, int lineNumber, @Nullable PsiFile file) {
        String string;
        String string2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$getLineIndentInnerSpacesLength, (String)"<this>");
            String string3 = this.getLineIndentSpaces($this$getLineIndentInnerSpacesLength, lineNumber, file);
            string2 = string3;
            if (string3 == null) return null;
            String $this$takeLastWhile$iv = string2;
            boolean $i$f$takeLastWhile = false;
            for (int index$iv = StringsKt.getLastIndex((CharSequence)$this$takeLastWhile$iv); -1 < index$iv; --index$iv) {
                char it = $this$takeLastWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it == ' ') continue;
                String string4 = $this$takeLastWhile$iv;
                int n = index$iv + 1;
                String string5 = string4.substring(n);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                break block1;
            }
            string = $this$takeLastWhile$iv;
        }
        string2 = string;
        if (string == null) return null;
        Integer n = string2.length();
        return n;
    }

    public static /* synthetic */ Integer getLineIndentInnerSpacesLength$default(ListUtils listUtils, Document document, int n, PsiFile psiFile, int n2, Object object) {
        if ((n2 & 2) != 0) {
            psiFile = null;
        }
        return listUtils.getLineIndentInnerSpacesLength(document, n, psiFile);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownListItem> getItems(@NotNull MarkdownList $this$items) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$items, (String)"<this>");
        PsiElement[] psiElementArray = $this$items.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object[] $this$filterIsInstance$iv = psiElementArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MarkdownListItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<MarkdownList> getSublists(@NotNull MarkdownListItem $this$sublists) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sublists, (String)"<this>");
        PsiElement[] psiElementArray = $this$sublists.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        Object[] $this$filterIsInstance$iv = psiElementArray;
        boolean $i$f$filterIsInstance = false;
        Object[] objectArray = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MarkdownList)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final MarkdownList getList(@NotNull MarkdownListItem $this$list) {
        Intrinsics.checkNotNullParameter((Object)$this$list, (String)"<this>");
        PsiElement psiElement = $this$list.getParent();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.intellij.plugins.markdown.lang.psi.impl.MarkdownList");
        return (MarkdownList)psiElement;
    }

    @NotNull
    public final String getNormalizedMarker(@NotNull MarkdownListItem $this$normalizedMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$normalizedMarker, (String)"<this>");
        PsiElement psiElement = $this$normalizedMarker.getMarkerElement();
        Intrinsics.checkNotNull((Object)psiElement);
        String string = psiElement.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String it = ((Object)StringsKt.trim((CharSequence)string)).toString();
        boolean bl = false;
        return it + " ";
    }
}

