/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.tables.ui;

import com.intellij.codeInsight.daemon.impl.InlayHintsPassFactoryInternal;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.SoftWrapChangeListener;
import com.intellij.openapi.editor.ex.SoftWrapModelEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SlowOperations;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/intellij/plugins/markdown/editor/tables/ui/MarkdownInlayUpdateOnSoftWrapListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "isMarkdownEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.markdown"})
public final class MarkdownInlayUpdateOnSoftWrapListener
implements EditorFactoryListener {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editorCreated(@NotNull EditorFactoryEvent event) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor2 = event.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
        Editor editor3 = editor2;
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"IJPL-162344");
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            if (!((Boolean)ReadAction.compute(() -> MarkdownInlayUpdateOnSoftWrapListener.editorCreated$lambda$0$0(this, editor3))).booleanValue()) {
                return;
            }
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        unit = editor3.getSoftWrapModel();
        SoftWrapModelEx softWrapModelEx = unit instanceof SoftWrapModelEx ? (SoftWrapModelEx)unit : null;
        if (softWrapModelEx == null) {
            return;
        }
        SoftWrapModelEx softWrapModel = softWrapModelEx;
        softWrapModel.addSoftWrapChangeListener(new SoftWrapChangeListener(){

            public void softWrapsChanged() {
                InlayHintsPassFactoryInternal.Companion.forceHintsUpdateOnNextPass();
            }

            public void recalculationEnds() {
            }
        });
    }

    private final boolean isMarkdownEditor(Editor editor2) {
        VirtualFile virtualFile = editor2.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file = virtualFile;
        return FileTypeManager.getInstance().isFileOfType(file, (FileType)MarkdownFileType.INSTANCE);
    }

    private static final Boolean editorCreated$lambda$0$0(MarkdownInlayUpdateOnSoftWrapListener this$0, Editor $editor) {
        return this$0.isMarkdownEditor($editor);
    }
}

