/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.extensions.jcef.commandRunner;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.RunAnythingContext;
import com.intellij.ide.actions.runAnything.RunAnythingRunConfigurationProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingCommandProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProvider;
import com.intellij.ide.actions.runAnything.activity.RunAnythingRecentProjectProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.MarkdownUsageCollector;
import org.intellij.plugins.markdown.extensions.MarkdownBrowserPreviewExtension;
import org.intellij.plugins.markdown.extensions.MarkdownExtensionsUtil;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.MarkdownRunner;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.RunnerPlace;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.RunnerType;
import org.intellij.plugins.markdown.extensions.jcef.commandRunner.TrustedProjectUtil;
import org.intellij.plugins.markdown.injection.aliases.CodeFenceLanguageGuesser;
import org.intellij.plugins.markdown.settings.MarkdownExtensionsSettings;
import org.intellij.plugins.markdown.ui.preview.BrowserPipe;
import org.intellij.plugins.markdown.ui.preview.MarkdownHtmlPanel;
import org.intellij.plugins.markdown.ui.preview.ResourceProvider;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\b\b*\u0002#+\b\u0000\u0018\u0000 12\u00020\u0001:\u0004./01B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u001a\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\u0018\u0010\u001d\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\fH\u0002J\u0016\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fJ\r\u0010\"\u001a\u00020#H\u0002\u00a2\u0006\u0002\u0010$J\u0018\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\fH\u0002J\u0018\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020\f2\u0006\u0010(\u001a\u00020\fH\u0002J\r\u0010*\u001a\u00020+H\u0002\u00a2\u0006\u0002\u0010,J\b\u0010-\u001a\u00020&H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00062"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "provider", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;", "<init>", "(Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;)V", "getPanel", "()Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "scripts", "", "", "getScripts", "()Ljava/util/List;", "styles", "getStyles", "hash2Cmd", "", "resourceProvider", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "getResourceProvider", "()Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "processCodeLine", "rawCodeLine", "insideFence", "", "processLine", "allowRunConfigurations", "getHtmlForLineRunner", "hash", "processCodeBlock", "codeFenceRawContent", "language", "createRunLineHandler", "org/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$createRunLineHandler$1", "()Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$createRunLineHandler$1;", "executeLineCommand", "", "command", "executorId", "executeBlock", "createRunBlockHandler", "org/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$createRunBlockHandler$1", "()Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$createRunBlockHandler$1;", "dispose", "CommandRunnerResourceProvider", "CommandRunnerIconsResourceProvider", "Provider", "Companion", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nCommandRunnerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandRunnerExtension.kt\norg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,363:1\n296#2,2:364\n13#3:366\n*S KotlinDebug\n*F\n+ 1 CommandRunnerExtension.kt\norg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension\n*L\n133#1:364,2\n345#1:366\n*E\n"})
public final class CommandRunnerExtension
implements MarkdownBrowserPreviewExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MarkdownHtmlPanel panel;
    @NotNull
    private final Provider provider;
    @NotNull
    private final List<String> scripts;
    @NotNull
    private final List<String> styles;
    @NotNull
    private final Map<String, String> hash2Cmd;
    @NotNull
    private final ResourceProvider resourceProvider;
    @NotNull
    private static final String RUN_LINE_EVENT = "runLine";
    @NotNull
    private static final String RUN_BLOCK_EVENT = "runBlock";
    @NotNull
    private static final String RUN_LINE_ICON = "commandRunner/run.png";
    @NotNull
    private static final String RUN_BLOCK_ICON = "commandRunner/runrun.png";
    @NotNull
    public static final String extensionId = "MarkdownCommandRunnerExtension";
    @NotNull
    private static final Logger LOG;

    public CommandRunnerExtension(@NotNull MarkdownHtmlPanel panel2, @NotNull Provider provider) {
        Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this.panel = panel2;
        this.provider = provider;
        this.scripts = CollectionsKt.listOf((Object)"commandRunner/commandRunner.js");
        this.styles = CollectionsKt.listOf((Object)"commandRunner/commandRunner.css");
        this.hash2Cmd = new LinkedHashMap();
        createRunLineHandler.1 runLineHandler = this.createRunLineHandler();
        createRunBlockHandler.1 runBlockHandler = this.createRunBlockHandler();
        BrowserPipe browserPipe = this.panel.getBrowserPipe();
        if (browserPipe != null) {
            browserPipe.subscribe(RUN_LINE_EVENT, runLineHandler);
        }
        BrowserPipe browserPipe2 = this.panel.getBrowserPipe();
        if (browserPipe2 != null) {
            browserPipe2.subscribe(RUN_BLOCK_EVENT, runBlockHandler);
        }
        Disposer.register((Disposable)this, () -> CommandRunnerExtension._init_$lambda$0(this, runLineHandler, runBlockHandler));
        ResourceProvider[] resourceProviderArray = new ResourceProvider[]{new CommandRunnerResourceProvider(), new CommandRunnerIconsResourceProvider()};
        this.resourceProvider = ResourceProvider.Companion.aggregating(resourceProviderArray);
    }

    @NotNull
    public final MarkdownHtmlPanel getPanel() {
        return this.panel;
    }

    @Override
    @NotNull
    public List<String> getScripts() {
        return this.scripts;
    }

    @Override
    @NotNull
    public List<String> getStyles() {
        return this.styles;
    }

    @Override
    @NotNull
    public ResourceProvider getResourceProvider() {
        return this.resourceProvider;
    }

    @NotNull
    public final String processCodeLine(@NotNull String rawCodeLine, boolean insideFence) {
        Intrinsics.checkNotNullParameter((Object)rawCodeLine, (String)"rawCodeLine");
        String string = this.processLine(rawCodeLine, !insideFence);
        if (string != null) {
            String hash = string;
            boolean bl = false;
            return this.getHtmlForLineRunner(insideFence, hash);
        }
        return "";
    }

    private final String processLine(String rawCodeLine, boolean allowRunConfigurations) {
        try {
            Project project = this.panel.getProject();
            VirtualFile file = this.panel.getVirtualFile();
            if (project != null && file != null && file.getParent() != null && Companion.matches(project, file.getParent().getCanonicalPath(), true, ((Object)StringsKt.trim((CharSequence)rawCodeLine)).toString(), allowRunConfigurations)) {
                String hash = MarkdownUtil.INSTANCE.md5(rawCodeLine, "");
                this.hash2Cmd.put(hash, rawCodeLine);
                return hash;
            }
            return null;
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            if (e instanceof CancellationException) {
                throw e;
            }
            LOG.warn((Throwable)e);
            return null;
        }
    }

    private final String getHtmlForLineRunner(boolean insideFence, String hash) {
        String cssClass = "run-icon-line" + (insideFence ? " code-block" : "");
        return "<a class='" + cssClass + "' href='#' role='button' data-command='Run:" + hash + "'><img src='commandRunner/run.png'></a>";
    }

    @NotNull
    public final String processCodeBlock(@NotNull String codeFenceRawContent, @NotNull String language) {
        Intrinsics.checkNotNullParameter((Object)codeFenceRawContent, (String)"codeFenceRawContent");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        try {
            Object v0;
            Object it;
            block6: {
                Language lang = CodeFenceLanguageGuesser.guessLanguageForInjection(language);
                Iterable $this$firstOrNull$iv = MarkdownRunner.Companion.getEP_NAME$intellij_markdown().getExtensionList();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (MarkdownRunner)element$iv;
                    boolean bl = false;
                    if (!it.isApplicable(lang)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            MarkdownRunner runner = v0;
            if (runner == null) {
                return "";
            }
            String hash = MarkdownUtil.INSTANCE.md5(codeFenceRawContent, "");
            this.hash2Cmd.put(hash, codeFenceRawContent);
            List lines = StringsKt.lines((CharSequence)((Object)StringsKt.trimEnd((CharSequence)codeFenceRawContent)).toString());
            String firstLineHash = lines.size() > 1 ? this.processLine((String)lines.get(0), false) : null;
            it = firstLineHash;
            Object firstLineData = it == null || StringsKt.isBlank((CharSequence)it) ? "" : "data-firstLine='" + firstLineHash + "'";
            String cssClass = "run-icon code-block";
            return "<a class='" + cssClass + "' href='#' role='button' data-command='Run:" + hash + "' data-commandtype='block'" + (String)firstLineData + "><img src='commandRunner/runrun.png'></a>";
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            if (e instanceof CancellationException) {
                throw e;
            }
            LOG.warn((Throwable)e);
            return "";
        }
    }

    private final createRunLineHandler.1 createRunLineHandler() {
        return new BrowserPipe.Handler(this){
            final /* synthetic */ CommandRunnerExtension this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean processMessageReceived(String data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                String executorId = StringsKt.substringBefore$default((String)data, (String)":", null, (int)2, null);
                String cmdHash = StringsKt.substringAfter$default((String)data, (String)":", null, (int)2, null);
                String command = (String)CommandRunnerExtension.access$getHash2Cmd$p(this.this$0).get(cmdHash);
                if (command == null) {
                    CommandRunnerExtension.access$getLOG$cp().error("Command index " + cmdHash + " not found. Please attach .md file to error report. commandCache = " + CommandRunnerExtension.access$getHash2Cmd$p(this.this$0));
                    return true;
                }
                CommandRunnerExtension.access$executeLineCommand(this.this$0, command, executorId);
                return false;
            }
        };
    }

    private final void executeLineCommand(String command, String executorId) {
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            executor = DefaultRunExecutor.getRunExecutorInstance();
        }
        Executor executor2 = executor;
        Project project = this.panel.getProject();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        if (project != null && virtualFile != null) {
            String string = virtualFile.getParent().getCanonicalPath();
            Intrinsics.checkNotNull((Object)executor2);
            Companion.execute(project, string, true, command, executor2, RunnerPlace.PREVIEW);
        }
    }

    private final void executeBlock(String command, String executorId) {
        MarkdownRunner runner = (MarkdownRunner)CollectionsKt.first((List)MarkdownRunner.Companion.getEP_NAME$intellij_markdown().getExtensionList());
        Executor executor = ExecutorRegistry.getInstance().getExecutorById(executorId);
        if (executor == null) {
            executor = DefaultRunExecutor.getRunExecutorInstance();
        }
        Executor executor2 = executor;
        Project project = this.panel.getProject();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        if (project != null && virtualFile != null) {
            TrustedProjectUtil.INSTANCE.executeIfTrusted(project, (Function0<Unit>)((Function0)() -> CommandRunnerExtension.executeBlock$lambda$0(project, runner, command, virtualFile, executor2)));
        }
    }

    private final createRunBlockHandler.1 createRunBlockHandler() {
        return new BrowserPipe.Handler(this){
            final /* synthetic */ CommandRunnerExtension this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean processMessageReceived(String data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                String[] stringArray = new String[]{":"};
                List args = StringsKt.split$default((CharSequence)data, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String executorId = (String)args.get(0);
                String cmdHash = (String)args.get(1);
                String command = (String)CommandRunnerExtension.access$getHash2Cmd$p(this.this$0).get(cmdHash);
                String firstLineCommand = (String)CommandRunnerExtension.access$getHash2Cmd$p(this.this$0).get(args.get(2));
                if (command == null) {
                    CommandRunnerExtension.access$getLOG$cp().error("Command hash " + cmdHash + " not found. Please attach .md file to error report.\n" + CommandRunnerExtension.access$getHash2Cmd$p(this.this$0));
                    return true;
                }
                String trimmedCmd = CommandRunnerExtension.Companion.trimPrompt$intellij_markdown(command);
                if (firstLineCommand == null) {
                    ApplicationManager.getApplication().invokeLater(() -> createRunBlockHandler.1.processMessageReceived$lambda$0(this.this$0, trimmedCmd, executorId));
                    return false;
                }
                int x = Integer.parseInt((String)args.get(3));
                int y = Integer.parseInt((String)args.get(4));
                ActionManager actionManager = ActionManager.getInstance();
                DefaultActionGroup actionGroup = new DefaultActionGroup();
                Supplier<String> supplier = createRunBlockHandler.1::processMessageReceived$lambda$1;
                Object object = AllIcons.RunConfigurations.TestState.Run_run;
                AnAction runBlockAction2 = new AnAction(this.this$0, trimmedCmd, executorId, supplier, (Icon)object){
                    final /* synthetic */ CommandRunnerExtension this$0;
                    final /* synthetic */ String $trimmedCmd;
                    final /* synthetic */ String $executorId;
                    {
                        this.this$0 = $receiver;
                        this.$trimmedCmd = $trimmedCmd;
                        this.$executorId = $executorId;
                        super($super_call_param$1, $super_call_param$2);
                    }

                    public void actionPerformed(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        ApplicationManager.getApplication().invokeLater(() -> createRunBlockHandler.processMessageReceived.runBlockAction.1.actionPerformed$lambda$0(this.this$0, this.$trimmedCmd, this.$executorId));
                    }

                    private static final void actionPerformed$lambda$0(CommandRunnerExtension this$0, String $trimmedCmd, String $executorId) {
                        CommandRunnerExtension.access$executeBlock(this$0, $trimmedCmd, $executorId);
                    }
                };
                object = createRunBlockHandler.1::processMessageReceived$lambda$2;
                Icon icon = AllIcons.RunConfigurations.TestState.Run;
                AnAction runLineAction2 = new AnAction(this.this$0, firstLineCommand, executorId, (Supplier<String>)object, icon){
                    final /* synthetic */ CommandRunnerExtension this$0;
                    final /* synthetic */ String $firstLineCommand;
                    final /* synthetic */ String $executorId;
                    {
                        this.this$0 = $receiver;
                        this.$firstLineCommand = $firstLineCommand;
                        this.$executorId = $executorId;
                        super($super_call_param$1, $super_call_param$2);
                    }

                    public void actionPerformed(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        ApplicationManager.getApplication().invokeLater(() -> createRunBlockHandler.processMessageReceived.runLineAction.1.actionPerformed$lambda$0(this.this$0, this.$firstLineCommand, this.$executorId));
                    }

                    private static final void actionPerformed$lambda$0(CommandRunnerExtension this$0, String $firstLineCommand, String $executorId) {
                        CommandRunnerExtension.access$executeLineCommand(this$0, $firstLineCommand, $executorId);
                    }
                };
                actionGroup.add(runBlockAction2);
                actionGroup.add(runLineAction2);
                AppUIUtil.invokeOnEdt(() -> createRunBlockHandler.1.processMessageReceived$lambda$3(actionManager, actionGroup, this.this$0, x, y));
                return false;
            }

            private static final void processMessageReceived$lambda$0(CommandRunnerExtension this$0, String $trimmedCmd, String $executorId) {
                CommandRunnerExtension.access$executeBlock(this$0, $trimmedCmd, $executorId);
            }

            private static final String processMessageReceived$lambda$1() {
                return MarkdownBundle.message("markdown.runner.launch.block", new Object[0]);
            }

            private static final String processMessageReceived$lambda$2() {
                return MarkdownBundle.message("markdown.runner.launch.line", new Object[0]);
            }

            private static final void processMessageReceived$lambda$3(ActionManager $actionManager, DefaultActionGroup $actionGroup, CommandRunnerExtension this$0, int $x, int $y) {
                $actionManager.createActionPopupMenu("ICON_NAVIGATION_SECONDARY_BUTTON", (ActionGroup)$actionGroup).getComponent().show(this$0.getPanel().getComponent(), $x, $y);
            }
        };
    }

    public void dispose() {
        Map map = this.provider.getExtensions();
        VirtualFile virtualFile = this.panel.getVirtualFile();
        TypeIntrinsics.asMutableMap((Object)map).remove(virtualFile);
    }

    private static final void _init_$lambda$0(CommandRunnerExtension this$0, createRunLineHandler.1 $runLineHandler, createRunBlockHandler.1 $runBlockHandler) {
        block1: {
            BrowserPipe browserPipe = this$0.panel.getBrowserPipe();
            if (browserPipe != null) {
                browserPipe.removeSubscription(RUN_LINE_EVENT, $runLineHandler);
            }
            BrowserPipe browserPipe2 = this$0.panel.getBrowserPipe();
            if (browserPipe2 == null) break block1;
            browserPipe2.removeSubscription(RUN_BLOCK_EVENT, $runBlockHandler);
        }
    }

    private static final Unit executeBlock$lambda$0$0(MarkdownRunner $runner, String $command, Project $project, VirtualFile $virtualFile, Executor $executor) {
        String string = $virtualFile.getParent().getCanonicalPath();
        Intrinsics.checkNotNull((Object)$executor);
        $runner.run($command, $project, string, $executor);
        return Unit.INSTANCE;
    }

    private static final Unit executeBlock$lambda$0(Project $project, MarkdownRunner $runner, String $command, VirtualFile $virtualFile, Executor $executor) {
        MarkdownUsageCollector.INSTANCE.getRUNNER_EXECUTED().log($project, (Object)RunnerPlace.PREVIEW, (Object)RunnerType.BLOCK, $runner.getClass());
        ActionsKt.invokeLater$default(null, () -> CommandRunnerExtension.executeBlock$lambda$0$0($runner, $command, $project, $virtualFile, $executor), (int)1, null);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Map access$getHash2Cmd$p(CommandRunnerExtension $this) {
        return $this.hash2Cmd;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ void access$executeLineCommand(CommandRunnerExtension $this, String command, String executorId) {
        $this.executeLineCommand(command, executorId);
    }

    public static final /* synthetic */ void access$executeBlock(CommandRunnerExtension $this, String command, String executorId) {
        $this.executeBlock(command, executorId);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CommandRunnerExtension.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$CommandRunnerIconsResourceProvider;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "<init>", "()V", "canProvide", "", "resourceName", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "Companion", "intellij.markdown"})
    private static final class CommandRunnerIconsResourceProvider
    implements ResourceProvider {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private static final Set<String> icons;

        @Override
        public boolean canProvide(@NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            return icons.contains(resourceName);
        }

        @Override
        @Nullable
        public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
            Icon icon;
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            String string = resourceName;
            if (Intrinsics.areEqual((Object)string, (Object)CommandRunnerExtension.RUN_LINE_ICON)) {
                icon = AllIcons.RunConfigurations.TestState.Run;
            } else if (Intrinsics.areEqual((Object)string, (Object)CommandRunnerExtension.RUN_BLOCK_ICON)) {
                icon = AllIcons.RunConfigurations.TestState.Run_run;
            } else {
                return null;
            }
            Icon icon2 = icon;
            Intrinsics.checkNotNull((Object)icon2);
            Icon icon3 = icon2;
            String format = StringsKt.substringAfterLast$default((String)resourceName, (String)".", null, (int)2, null);
            return new ResourceProvider.Resource(MarkdownExtensionsUtil.INSTANCE.loadIcon(icon3, format), null, 2, null);
        }

        static {
            Object[] objectArray = new String[]{CommandRunnerExtension.RUN_LINE_ICON, CommandRunnerExtension.RUN_BLOCK_ICON};
            icons = SetsKt.setOf((Object[])objectArray);
        }

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$CommandRunnerIconsResourceProvider$Companion;", "", "<init>", "()V", "icons", "", "", "intellij.markdown"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$CommandRunnerResourceProvider;", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider;", "<init>", "(Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;)V", "canProvide", "", "resourceName", "", "loadResource", "Lorg/intellij/plugins/markdown/ui/preview/ResourceProvider$Resource;", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nCommandRunnerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandRunnerExtension.kt\norg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$CommandRunnerResourceProvider\n+ 2 ResourceProvider.kt\norg/intellij/plugins/markdown/ui/preview/ResourceProvider$Companion\n*L\n1#1,363:1\n106#2,2:364\n*S KotlinDebug\n*F\n+ 1 CommandRunnerExtension.kt\norg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$CommandRunnerResourceProvider\n*L\n69#1:364,2\n*E\n"})
    private final class CommandRunnerResourceProvider
    implements ResourceProvider {
        @Override
        public boolean canProvide(@NotNull String resourceName) {
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            return CommandRunnerExtension.this.getScripts().contains(resourceName) || CommandRunnerExtension.this.getStyles().contains(resourceName);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public ResourceProvider.Resource loadResource(@NotNull String resourceName) {
            void $this$iv;
            Intrinsics.checkNotNullParameter((Object)resourceName, (String)"resourceName");
            ResourceProvider.Companion companion = ResourceProvider.Companion;
            String path$iv = resourceName;
            String contentType$iv = null;
            boolean $i$f$loadInternalResource = false;
            return $this$iv.loadInternalResource(CommandRunnerResourceProvider.class, path$iv, contentType$iv);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ2\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\b\b\u0002\u0010\u0016\u001a\u00020\u000bJ8\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001e\u0010\u001e\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0002\b\u0003\u0018\u00010 2\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u0015\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b%R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Companion;", "", "<init>", "()V", "RUN_LINE_EVENT", "", "RUN_BLOCK_EVENT", "RUN_LINE_ICON", "RUN_BLOCK_ICON", "extensionId", "isExtensionEnabled", "", "getRunnerByFile", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "matches", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "localSession", "command", "allowRunConfigurations", "execute", "executor", "Lcom/intellij/execution/Executor;", "place", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/RunnerPlace;", "createDataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "checkForCLI", "it", "Lcom/intellij/ide/actions/runAnything/activity/RunAnythingProvider;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "trimPrompt", "cmd", "trimPrompt$intellij_markdown", "intellij.markdown"})
    @SourceDebugExtension(value={"SMAP\nCommandRunnerExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommandRunnerExtension.kt\norg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Companion\n+ 2 MarkdownExtensionsUtil.kt\norg/intellij/plugins/markdown/extensions/MarkdownExtensionsUtil\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,363:1\n33#2:364\n777#3:365\n873#3,2:366\n1276#4,2:368\n*S KotlinDebug\n*F\n+ 1 CommandRunnerExtension.kt\norg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Companion\n*L\n281#1:364\n349#1:365\n349#1:366,2\n295#1:368,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isExtensionEnabled() {
            Boolean bl = MarkdownExtensionsSettings.Companion.getInstance().getExtensionsEnabledState().get(CommandRunnerExtension.extensionId);
            return bl != null ? bl : true;
        }

        @Nullable
        public final CommandRunnerExtension getRunnerByFile(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            MarkdownExtensionsUtil this_$iv = MarkdownExtensionsUtil.INSTANCE;
            boolean $i$f$findBrowserExtensionProvider = false;
            Provider provider = (Provider)((MarkdownBrowserPreviewExtension.Provider)MarkdownBrowserPreviewExtension.Provider.Companion.getEP().findExtension(Provider.class));
            Object object = provider;
            return object != null && (object = ((Provider)object).getExtensions()) != null ? (CommandRunnerExtension)((ConcurrentHashMap)object).get(file) : null;
        }

        public final boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, boolean allowRunConfigurations) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            String trimmedCmd = ((Object)StringsKt.trim((CharSequence)command)).toString();
            if (((CharSequence)trimmedCmd).length() == 0) {
                return false;
            }
            DataContext dataContext = org.intellij.plugins.markdown.extensions.jcef.commandRunner.CommandRunnerExtension$Companion.createDataContext$default(this, project, localSession, workingDirectory, null, 8, null);
            return (Boolean)ActionsKt.runReadAction(() -> Companion.matches$lambda$0(allowRunConfigurations, dataContext, trimmedCmd));
        }

        public static /* synthetic */ boolean matches$default(Companion companion, Project project, String string, boolean bl, String string2, boolean bl2, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            return companion.matches(project, string, bl, string2, bl2);
        }

        public final boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull Executor executor, @NotNull RunnerPlace place) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)((Object)place), (String)"place");
            DataContext dataContext = this.createDataContext(project, localSession, workingDirectory, executor);
            String trimmedCmd = ((Object)StringsKt.trim((CharSequence)command)).toString();
            return (Boolean)ActionsKt.runReadAction(() -> Companion.execute$lambda$0(dataContext, trimmedCmd, project, place));
        }

        private final DataContext createDataContext(Project project, boolean localSession, String workingDirectory, Executor executor) {
            SimpleDataContext.Builder builder;
            VirtualFile virtualFile = localSession && workingDirectory != null ? LocalFileSystem.getInstance().findFileByPath(workingDirectory) : null;
            SimpleDataContext.Builder $this$createDataContext_u24lambda_u240 = builder = SimpleDataContext.builder().add(CommonDataKeys.PROJECT, (Object)project).add(RunAnythingAction.EXECUTOR_KEY, (Object)executor);
            boolean bl = false;
            if (virtualFile != null) {
                $this$createDataContext_u24lambda_u240.add(CommonDataKeys.VIRTUAL_FILE, (Object)virtualFile);
                String string = virtualFile.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                $this$createDataContext_u24lambda_u240.add(RunAnythingProvider.EXECUTING_CONTEXT, (Object)new RunAnythingContext.RecentDirectoryContext(string));
            }
            DataContext dataContext = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
            return dataContext;
        }

        static /* synthetic */ DataContext createDataContext$default(Companion companion, Project project, boolean bl, String string, Executor executor, int n, Object object) {
            if ((n & 8) != 0) {
                executor = null;
            }
            return companion.createDataContext(project, bl, string, executor);
        }

        private final boolean checkForCLI(RunAnythingProvider<?> it, boolean allowRunConfigurations) {
            return !(it instanceof RunAnythingCommandProvider) && !(it instanceof RunAnythingRecentProjectProvider) && (!(it instanceof RunAnythingRunConfigurationProvider) || allowRunConfigurations);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String trimPrompt$intellij_markdown(@NotNull String cmd) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)cmd, (String)"cmd");
            Iterable $this$filter$iv = StringsKt.lines((CharSequence)cmd);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String line = (String)element$iv$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)line).length() > 0;
                if (!bl2) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, Companion::trimPrompt$lambda$1, (int)30, null);
        }

        private static final boolean matches$lambda$0$0(boolean $allowRunConfigurations, RunAnythingProvider it) {
            return Companion.checkForCLI(it, $allowRunConfigurations);
        }

        private static final boolean matches$lambda$0(boolean $allowRunConfigurations, DataContext $dataContext, String $trimmedCmd) {
            boolean bl;
            block1: {
                Sequence $this$any$iv = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)RunAnythingProvider.EP_NAME.getExtensionList()), arg_0 -> Companion.matches$lambda$0$0($allowRunConfigurations, arg_0));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    RunAnythingProvider provider = (RunAnythingProvider)element$iv;
                    boolean bl2 = false;
                    if (!(provider.findMatchingValue($dataContext, $trimmedCmd) != null)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        private static final Unit execute$lambda$0$0$0(RunAnythingProvider $provider, DataContext $dataContext, Object $value) {
            $provider.execute($dataContext, $value);
            return Unit.INSTANCE;
        }

        private static final Unit execute$lambda$0$0(Project $project, RunnerPlace $place, RunAnythingProvider $provider, DataContext $dataContext, Object $value) {
            MarkdownUsageCollector.INSTANCE.getRUNNER_EXECUTED().log($project, (Object)$place, (Object)RunnerType.LINE, $provider.getClass());
            ActionsKt.invokeLater$default(null, () -> Companion.execute$lambda$0$0$0($provider, $dataContext, $value), (int)1, null);
            return Unit.INSTANCE;
        }

        private static final boolean execute$lambda$0(DataContext $dataContext, String $trimmedCmd, Project $project, RunnerPlace $place) {
            for (RunAnythingProvider provider : RunAnythingProvider.EP_NAME.getExtensionList()) {
                Object object = provider.findMatchingValue($dataContext, $trimmedCmd);
                if (object == null) continue;
                Object value = object;
                return TrustedProjectUtil.INSTANCE.executeIfTrusted($project, (Function0<Unit>)((Function0)() -> Companion.execute$lambda$0$0($project, $place, provider, $dataContext, value)));
            }
            return false;
        }

        private static final CharSequence trimPrompt$lambda$1(String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            return StringsKt.startsWith$default((String)line, (String)"$", (boolean)false, (int)2, null) ? (CharSequence)StringsKt.substringAfter$default((String)line, (String)"$", null, (int)2, null) : (CharSequence)line;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension$Provider;", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension$Provider;", "<init>", "()V", "extensions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/intellij/plugins/markdown/extensions/jcef/commandRunner/CommandRunnerExtension;", "getExtensions", "()Ljava/util/concurrent/ConcurrentHashMap;", "createBrowserExtension", "Lorg/intellij/plugins/markdown/extensions/MarkdownBrowserPreviewExtension;", "panel", "Lorg/intellij/plugins/markdown/ui/preview/MarkdownHtmlPanel;", "intellij.markdown"})
    public static final class Provider
    implements MarkdownBrowserPreviewExtension.Provider {
        @NotNull
        private final ConcurrentHashMap<VirtualFile, CommandRunnerExtension> extensions = new ConcurrentHashMap();

        @NotNull
        public final ConcurrentHashMap<VirtualFile, CommandRunnerExtension> getExtensions() {
            return this.extensions;
        }

        @Override
        @Nullable
        public MarkdownBrowserPreviewExtension createBrowserExtension(@NotNull MarkdownHtmlPanel panel2) {
            Intrinsics.checkNotNullParameter((Object)panel2, (String)"panel");
            VirtualFile virtualFile = panel2.getVirtualFile();
            if (virtualFile == null) {
                return null;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (!Companion.isExtensionEnabled()) {
                return null;
            }
            return this.extensions.computeIfAbsent(virtualFile2, arg_0 -> Provider.createBrowserExtension$lambda$1(arg_0 -> Provider.createBrowserExtension$lambda$0(panel2, this, arg_0), arg_0));
        }

        private static final CommandRunnerExtension createBrowserExtension$lambda$0(MarkdownHtmlPanel $panel, Provider this$0, VirtualFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new CommandRunnerExtension($panel, this$0);
        }

        private static final CommandRunnerExtension createBrowserExtension$lambda$1(Function1 $tmp0, Object p0) {
            return (CommandRunnerExtension)$tmp0.invoke(p0);
        }
    }
}

