/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.blocks.special;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownBlocks;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.MarkdownTextUtil;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownRangedFormattingBlock;
import org.intellij.plugins.markdown.lang.formatter.blocks.special.MarkdownWrappingFormattingBlockKt;
import org.intellij.plugins.markdown.lang.psi.util.AstUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0010\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0014J\n\u0010\u0015\u001a\u0004\u0018\u00010\u000bH\u0002J0\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00140\u00192\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u001a\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001d"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/blocks/special/MarkdownWrappingFormattingBlock;", "Lorg/intellij/plugins/markdown/lang/formatter/blocks/MarkdownFormattingBlock;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "spacing", "Lcom/intellij/formatting/SpacingBuilder;", "node", "Lcom/intellij/lang/ASTNode;", "alignment", "Lcom/intellij/formatting/Alignment;", "wrap", "Lcom/intellij/formatting/Wrap;", "<init>", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;Lcom/intellij/formatting/SpacingBuilder;Lcom/intellij/lang/ASTNode;Lcom/intellij/formatting/Alignment;Lcom/intellij/formatting/Wrap;)V", "newlines", "", "getNewlines", "()I", "buildChildren", "", "Lcom/intellij/formatting/Block;", "createWrapForChildren", "processTextElement", "", "result", "", "wrapping", "wrapFirstElement", "", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownWrappingFormattingBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownWrappingFormattingBlock.kt\norg/intellij/plugins/markdown/lang/formatter/blocks/special/MarkdownWrappingFormattingBlock\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,99:1\n1123#2,3:100\n1088#2,2:103\n*S KotlinDebug\n*F\n+ 1 MarkdownWrappingFormattingBlock.kt\norg/intellij/plugins/markdown/lang/formatter/blocks/special/MarkdownWrappingFormattingBlock\n*L\n28#1:100,3\n62#1:103,2\n*E\n"})
public class MarkdownWrappingFormattingBlock
extends MarkdownFormattingBlock {
    public MarkdownWrappingFormattingBlock(@NotNull CodeStyleSettings settings, @NotNull SpacingBuilder spacing, @NotNull ASTNode node, @Nullable Alignment alignment, @Nullable Wrap wrap) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)spacing, (String)"spacing");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        super(node, settings, spacing, alignment, wrap);
    }

    public /* synthetic */ MarkdownWrappingFormattingBlock(CodeStyleSettings codeStyleSettings, SpacingBuilder spacingBuilder, ASTNode aSTNode, Alignment alignment, Wrap wrap, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            alignment = null;
        }
        if ((n & 0x10) != 0) {
            wrap = null;
        }
        this(codeStyleSettings, spacingBuilder, aSTNode, alignment, wrap);
    }

    /*
     * WARNING - void declaration
     */
    public final int getNewlines() {
        void var3_3;
        String string = this.getNode().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        CharSequence $this$count$iv = string;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (int i = 0; i < $this$count$iv.length(); ++i) {
            char element$iv;
            char it = element$iv = $this$count$iv.charAt(i);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        return (int)var3_3;
    }

    @Override
    @NotNull
    protected List<Block> buildChildren() {
        ASTNode aSTNode = this.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
        Sequence<ASTNode> filtered = MarkdownBlocks.INSTANCE.filterFromWhitespaces(AstUtilsKt.children(aSTNode));
        Wrap childWrap = this.createWrapForChildren();
        ArrayList<MarkdownFormattingBlock> result = new ArrayList<MarkdownFormattingBlock>();
        for (ASTNode node : filtered) {
            if (Intrinsics.areEqual((Object)node.getElementType(), (Object)MarkdownTokenTypes.TEXT)) {
                this.processTextElement((Collection<Block>)result, node, childWrap, true);
                continue;
            }
            result.add(MarkdownBlocks.INSTANCE.create(node, this.getSettings(), this.getSpacing(), (Function1<? super ASTNode, ? extends Alignment>)((Function1)arg_0 -> MarkdownWrappingFormattingBlock.buildChildren$lambda$0(this, arg_0))));
        }
        return result;
    }

    private final Wrap createWrapForChildren() {
        WrapType wrapType = this.obtainCustomSettings().WRAP_TEXT_IF_LONG ? WrapType.NORMAL : WrapType.NONE;
        return Wrap.createWrap((WrapType)wrapType, (boolean)false);
    }

    protected void processTextElement(@NotNull Collection<Block> result, @NotNull ASTNode node, @Nullable Wrap wrapping, boolean wrapFirstElement) {
        Intrinsics.checkNotNullParameter(result, (String)"result");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        String string = node.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text2 = string;
        int shift = node.getTextRange().getStartOffset();
        Sequence splits = MarkdownWrappingFormattingBlockKt.access$splitTextForWrapping(text2);
        Wrap noneWrapping = Wrap.createWrap((WrapType)WrapType.NONE, (boolean)false);
        Iterator iterator = splits.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            TextRange range;
            boolean bl;
            TextRange split;
            int index;
            block2: {
                CharSequence $this$all$iv;
                index = n++;
                split = (TextRange)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)split.subSequence((CharSequence)text2), (String)"subSequence(...)");
                boolean $i$f$all = false;
                for (int i = 0; i < $this$all$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(i);
                    boolean bl2 = false;
                    if (MarkdownTextUtil.INSTANCE.isPunctuation(it)) continue;
                    bl = false;
                    break block2;
                }
                bl = true;
            }
            boolean isPunctuation = bl;
            boolean isNonWrappingFirstElement = index == 0 && !wrapFirstElement;
            Wrap actualWrapping = isPunctuation || isNonWrappingFirstElement ? noneWrapping : wrapping;
            Intrinsics.checkNotNullExpressionValue((Object)split.shiftRight(shift), (String)"shiftRight(...)");
            MarkdownRangedFormattingBlock block = new MarkdownRangedFormattingBlock(node, range, this.getSettings(), this.getSpacing(), this.getAlignment(), actualWrapping);
            result.add((Block)block);
        }
    }

    private static final Alignment buildChildren$lambda$0(MarkdownWrappingFormattingBlock this$0, ASTNode it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getAlignment();
    }
}

