/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.formatter.settings;

import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.intellij.lang.annotations.Language;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownLanguage;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCodeStyleConfigurable;
import org.intellij.plugins.markdown.lang.formatter.settings.MarkdownCustomCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\f0\f\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0017\u00a8\u0006\u001b"}, d2={"Lorg/intellij/plugins/markdown/lang/formatter/settings/MarkdownCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider;", "<init>", "()V", "getLanguage", "Lcom/intellij/lang/Language;", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "baseSettings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "modelSettings", "getConfigurableDisplayName", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "customizeSettings", "", "consumer", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsCustomizable;", "settingsType", "Lcom/intellij/psi/codeStyle/LanguageCodeStyleSettingsProvider$SettingsType;", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "settings", "getIndentOptionsEditor", "Lcom/intellij/application/options/IndentOptionsEditor;", "getCodeSample", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownCodeStyleSettingsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownCodeStyleSettingsProvider.kt\norg/intellij/plugins/markdown/lang/formatter/settings/MarkdownCodeStyleSettingsProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,153:1\n1#2:154\n*E\n"})
public final class MarkdownCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public com.intellij.lang.Language getLanguage() {
        MarkdownLanguage markdownLanguage = MarkdownLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)markdownLanguage), (String)"INSTANCE");
        return markdownLanguage;
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings baseSettings, @NotNull CodeStyleSettings modelSettings) {
        Intrinsics.checkNotNullParameter((Object)baseSettings, (String)"baseSettings");
        Intrinsics.checkNotNullParameter((Object)modelSettings, (String)"modelSettings");
        return (CodeStyleConfigurable)new MarkdownCodeStyleConfigurable(baseSettings, modelSettings);
    }

    @NotNull
    public String getConfigurableDisplayName() {
        String string = MarkdownBundle.message("markdown.settings.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        Intrinsics.checkNotNullParameter((Object)consumer, (String)"consumer");
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 1: {
                String[] stringArray = new String[]{"RIGHT_MARGIN", "WRAP_ON_TYPING"};
                consumer.showStandardOptions(stringArray);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "WRAP_TEXT_IF_LONG", MarkdownBundle.message("markdown.style.settings.text.wrapping", new Object[0]), null, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "WRAP_ON_TYPING", new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "WRAP_TEXT_INSIDE_BLOCKQUOTES", MarkdownBundle.message("markdown.style.settings.text.wrapping.inside.blockquotes", new Object[0]), null, CodeStyleSettingsCustomizable.OptionAnchor.AFTER, "WRAP_ON_TYPING", new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "KEEP_LINE_BREAKS_INSIDE_TEXT_BLOCKS", MarkdownBundle.message("markdown.style.settings.line.breaks.inside.text.blocks", new Object[0]), MarkdownBundle.message("markdown.style.settings.group.when.reformatting", new Object[0]), new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "INSERT_QUOTE_ARROWS_ON_WRAP", MarkdownBundle.message("markdown.style.settings.insert.quote.arrows", new Object[0]), MarkdownBundle.message("markdown.style.settings.group.when.reformatting", new Object[0]), new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "FORMAT_TABLES", MarkdownBundle.message("markdown.style.settings.format.tables", new Object[0]), MarkdownBundle.message("markdown.style.settings.group.when.reformatting", new Object[0]), new Object[0]);
                break;
            }
            case 2: {
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MAX_LINES_AROUND_HEADER", MarkdownBundle.message("markdown.style.settings.blank.lines.around.header", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MAX_LINES_AROUND_BLOCK_ELEMENTS", MarkdownBundle.message("markdown.style.settings.blank.lines.around.block.elements", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MAX_LINES_BETWEEN_PARAGRAPHS", MarkdownBundle.message("markdown.style.settings.blank.lines.between.paragraphs", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MIN_LINES_AROUND_HEADER", MarkdownBundle.message("markdown.style.settings.blank.lines.around.header", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MIN_LINES_AROUND_BLOCK_ELEMENTS", MarkdownBundle.message("markdown.style.settings.blank.lines.around.block.elements", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "MIN_LINES_BETWEEN_PARAGRAPHS", MarkdownBundle.message("markdown.style.settings.blank.lines.between.paragraphs", new Object[0]), CodeStyleSettingsCustomizableOptions.getInstance().BLANK_LINES_KEEP, new Object[0]);
                break;
            }
            case 3: {
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "FORCE_ONE_SPACE_BETWEEN_WORDS", MarkdownBundle.message("markdown.style.settings.spacing.between.words", new Object[0]), MarkdownBundle.message("markdown.style.settings.spacing.force.one.space", new Object[0]), new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "FORCE_ONE_SPACE_AFTER_HEADER_SYMBOL", MarkdownBundle.message("markdown.style.settings.spacing.after.header.symbol", new Object[0]), MarkdownBundle.message("markdown.style.settings.spacing.force.one.space", new Object[0]), new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "FORCE_ONE_SPACE_AFTER_LIST_BULLET", MarkdownBundle.message("markdown.style.settings.spacing.after.list.marker", new Object[0]), MarkdownBundle.message("markdown.style.settings.spacing.force.one.space", new Object[0]), new Object[0]);
                consumer.showCustomOption(MarkdownCustomCodeStyleSettings.class, "FORCE_ONE_SPACE_AFTER_BLOCKQUOTE_SYMBOL", MarkdownBundle.message("markdown.style.settings.spacing.after.blockquote.marker", new Object[0]), MarkdownBundle.message("markdown.style.settings.spacing.force.one.space", new Object[0]), new Object[0]);
            }
        }
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return new MarkdownCustomCodeStyleSettings(settings);
    }

    @NotNull
    public IndentOptionsEditor getIndentOptionsEditor() {
        return (IndentOptionsEditor)new SmartIndentOptionsEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Language(value="Markdown")
    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        String codeSample;
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)settingsType, (String)"settingsType");
        String sampleName = switch (WhenMappings.$EnumSwitchMapping$0[settingsType.ordinal()]) {
            case 4 -> "indent_settings.md";
            case 2 -> "blank_lines_settings.md";
            case 3 -> "spacing_settings.md";
            default -> "default.md";
        };
        InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(sampleName);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Object object2 = Charsets.UTF_8;
            Object object3 = new InputStreamReader((InputStream)closeable, (Charset)object2);
            int n = 8192;
            closeable = object3 instanceof BufferedReader ? (BufferedReader)object3 : new BufferedReader((Reader)object3, n);
            object2 = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                object3 = TextStreamsKt.readText((Reader)it);
                object = object3;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
        } else {
            object = null;
        }
        if ((string = (codeSample = object)) == null) {
            string = "Failed to get predefined code sample";
        }
        return string;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LanguageCodeStyleSettingsProvider.SettingsType.values().length];
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

