/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.parser.blocks;

import com.intellij.util.text.CharSequenceSubSequence;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.LinkReferenceDefinitionMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.LinkReferenceDefinitionProvider;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.intellij.plugins.markdown.lang.parser.blocks.CommentElementTypesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J*\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\"\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00062\n\u0010\b\u001a\u00060\tR\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001c\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u00060\tR\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/intellij/plugins/markdown/lang/parser/blocks/CommentAwareLinkReferenceDefinitionProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "<init>", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "position", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "processTitle", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "titleRange", "Lkotlin/ranges/IntRange;", "interruptsParagraph", "", "pos", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "intellij.markdown"})
public final class CommentAwareLinkReferenceDefinitionProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position position, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        LookaheadText.Position endPosition;
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkNotNullParameter((Object)stateInfo, (String)"stateInfo");
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(position, stateInfo.getCurrentConstraints())) {
            return CollectionsKt.emptyList();
        }
        CharSequenceSubSequence textFromPosition = new CharSequenceSubSequence(position.getOriginalText(), position.getOffset(), position.getOriginalText().length());
        List list2 = LinkReferenceDefinitionProvider.Companion.matchLinkDefinition((CharSequence)textFromPosition, 0);
        if (list2 == null) {
            return CollectionsKt.emptyList();
        }
        List matchResult = list2;
        Iterator iterator = ((Iterable)matchResult).iterator();
        int n = 0;
        block5: while (iterator.hasNext()) {
            IElementType iElementType;
            int index = n++;
            IntRange range = (IntRange)iterator.next();
            switch (index) {
                case 0: {
                    iElementType = MarkdownElementTypes.LINK_LABEL;
                    break;
                }
                case 1: {
                    iElementType = MarkdownElementTypes.LINK_DESTINATION;
                    break;
                }
                case 2: {
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("There are no more than three groups in this regex".toString());
                }
            }
            IElementType type = iElementType;
            SequentialParser.Node node = new SequentialParser.Node(LinkReferenceDefinitionProvider.Companion.addToRangeAndWiden(range, position.getOffset()), type);
            productionHolder.addProduction((Collection)CollectionsKt.listOf((Object)node));
        }
        int matchLength = ((IntRange)CollectionsKt.last((List)matchResult)).getLast() + 1;
        IntRange titleRange = (IntRange)CollectionsKt.getOrNull((List)matchResult, (int)2);
        if (titleRange != null) {
            List<SequentialParser.Node> nodes = this.processTitle(position, titleRange);
            productionHolder.addProduction((Collection)nodes);
        }
        if ((endPosition = position.nextPosition(matchLength)) != null && !LinkReferenceDefinitionProvider.Companion.isEndOfLine(endPosition)) {
            return CollectionsKt.emptyList();
        }
        LinkReferenceDefinitionMarkerBlock block = new LinkReferenceDefinitionMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder.mark(), position.getOffset() + matchLength);
        return CollectionsKt.listOf((Object)block);
    }

    private final List<SequentialParser.Node> processTitle(LookaheadText.Position position, IntRange titleRange) {
        if (!StringsKt.startsWith$default((CharSequence)position.getCurrentLineFromPosition(), (CharSequence)"[//]: #", (boolean)false, (int)2, null)) {
            IntRange range = LinkReferenceDefinitionProvider.Companion.addToRangeAndWiden(titleRange, position.getOffset());
            SequentialParser.Node node = new SequentialParser.Node(range, MarkdownElementTypes.LINK_TITLE);
            return CollectionsKt.listOf((Object)node);
        }
        LookaheadText.Position position2 = position.nextPosition(titleRange.getFirst());
        if (position2 == null) {
            return CollectionsKt.emptyList();
        }
        LookaheadText.Position titlePosition = position2;
        CharSequence textFromCurrentPosition = position.getTextFromPosition();
        CharSequence text2 = StringsKt.subSequence((CharSequence)textFromCurrentPosition, (IntRange)titleRange);
        if (StringsKt.startsWith$default((CharSequence)text2, (char)'(', (boolean)false, (int)2, null) && StringsKt.endsWith$default((CharSequence)StringsKt.trimEnd((CharSequence)text2), (char)')', (boolean)false, (int)2, null)) {
            int offset = titlePosition.getOffset();
            int actualTitleLength = StringsKt.trimEnd((CharSequence)text2).length();
            Object[] objectArray = new SequentialParser.Node[]{new SequentialParser.Node(LinkReferenceDefinitionProvider.Companion.addToRangeAndWiden(titleRange, position.getOffset()), CommentElementTypesKt.getCOMMENT(MarkdownElementTypes.INSTANCE)), new SequentialParser.Node(new IntRange(offset, offset + 1), MarkdownTokenTypes.LPAREN), new SequentialParser.Node(new IntRange(offset + 1, offset + actualTitleLength - 1), CommentElementTypesKt.getCOMMENT_VALUE(MarkdownElementTypes.INSTANCE)), new SequentialParser.Node(new IntRange(offset + actualTitleLength - 1, offset + actualTitleLength), MarkdownTokenTypes.RPAREN)};
            return CollectionsKt.listOf((Object[])objectArray);
        }
        return CollectionsKt.emptyList();
    }

    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)constraints, (String)"constraints");
        return false;
    }
}

