/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.library.abi.parser;

import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.library.abi.AbiClass;
import org.jetbrains.kotlin.library.abi.AbiClassKind;
import org.jetbrains.kotlin.library.abi.AbiCompoundName;
import org.jetbrains.kotlin.library.abi.AbiDeclaration;
import org.jetbrains.kotlin.library.abi.AbiEnumEntry;
import org.jetbrains.kotlin.library.abi.AbiFunction;
import org.jetbrains.kotlin.library.abi.AbiModality;
import org.jetbrains.kotlin.library.abi.AbiProperty;
import org.jetbrains.kotlin.library.abi.AbiPropertyKind;
import org.jetbrains.kotlin.library.abi.AbiQualifiedName;
import org.jetbrains.kotlin.library.abi.AbiSignatureVersion;
import org.jetbrains.kotlin.library.abi.AbiSignatures;
import org.jetbrains.kotlin.library.abi.AbiType;
import org.jetbrains.kotlin.library.abi.AbiValueParameter;
import org.jetbrains.kotlin.library.abi.ExperimentalLibraryAbiReader;
import org.jetbrains.kotlin.library.abi.LibraryAbi;
import org.jetbrains.kotlin.library.abi.LibraryManifest;
import org.jetbrains.kotlin.library.abi.impl.AbiAnnotationListImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiClassImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiConstructorImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiEnumEntryImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiFunctionImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiPropertyImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiSignaturesImpl;
import org.jetbrains.kotlin.library.abi.impl.AbiTopLevelDeclarationsImpl;
import org.jetbrains.kotlin.library.abi.parser.Cursor;
import org.jetbrains.kotlin.library.abi.parser.KlibParsingCursorExtensionsKt;

@ExperimentalLibraryAbiReader
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\tJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0019\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b\u0019J#\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ\u0019\u0010\u001f\u001a\u00020 2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b!J\u0017\u0010\"\u001a\u00020#2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0000\u00a2\u0006\u0002\b$J\u0014\u0010%\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000e0)2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J&\u0010*\u001a\u00020\u001b2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0002\u0010\u001c\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0002J\u0012\u0010-\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u0010.\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0012\u0010/\u001a\u00020\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\b\u00100\u001a\u000201H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0003H\u0002J\u0010\u00105\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/jetbrains/kotlin/library/abi/parser/KlibDumpParser;", "", "klibDump", "", "filePath", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "cursor", "Lorg/jetbrains/kotlin/library/abi/parser/Cursor;", "declarations", "", "Lorg/jetbrains/kotlin/library/abi/AbiDeclaration;", "uniqueName", "signatureVersions", "", "Lorg/jetbrains/kotlin/library/abi/AbiSignatureVersion;", "parse", "Lorg/jetbrains/kotlin/library/abi/LibraryAbi;", "parseClass", "Lorg/jetbrains/kotlin/library/abi/AbiClass;", "parentQualifiedName", "Lorg/jetbrains/kotlin/library/abi/AbiQualifiedName;", "parseClass$kotlin_util_klib_abi", "parseFunction", "Lorg/jetbrains/kotlin/library/abi/AbiFunction;", "isGetterOrSetter", "", "parseFunction$kotlin_util_klib_abi", "parseProperty", "Lorg/jetbrains/kotlin/library/abi/AbiProperty;", "parseProperty$kotlin_util_klib_abi", "parseEnumEntry", "Lorg/jetbrains/kotlin/library/abi/AbiEnumEntry;", "parseEnumEntry$kotlin_util_klib_abi", "parseDeclaration", "parseCommentLine", "", "parseChildDeclarations", "", "parseNonConstructorFunction", "modality", "Lorg/jetbrains/kotlin/library/abi/AbiModality;", "parseConstructor", "parseAbiQualifiedName", "parseAbiQualifiedNameForGetterOrSetter", "currentSignatures", "Lorg/jetbrains/kotlin/library/abi/AbiSignatures;", "parseException", "Ljava/text/ParseException;", "message", "formatErrorMessage", "kotlin-util-klib-abi"})
@SourceDebugExtension(value={"SMAP\nKLibDumpParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KLibDumpParser.kt\norg/jetbrains/kotlin/library/abi/parser/KlibDumpParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1#2:316\n1807#3,3:317\n1807#3,3:320\n*S KotlinDebug\n*F\n+ 1 KLibDumpParser.kt\norg/jetbrains/kotlin/library/abi/parser/KlibDumpParser\n*L\n296#1:317,3\n297#1:320,3\n*E\n"})
public final class KlibDumpParser {
    @Nullable
    private final String filePath;
    @NotNull
    private final Cursor cursor;
    @NotNull
    private final List<AbiDeclaration> declarations;
    @NotNull
    private String uniqueName;
    @NotNull
    private Set<AbiSignatureVersion> signatureVersions;

    public KlibDumpParser(@NotNull String klibDump, @Nullable String filePath) {
        Intrinsics.checkNotNullParameter((Object)klibDump, (String)"klibDump");
        this.filePath = filePath;
        this.cursor = new Cursor(klibDump);
        this.declarations = new ArrayList();
        this.uniqueName = "";
        this.signatureVersions = new LinkedHashSet();
    }

    public /* synthetic */ KlibDumpParser(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    public KlibDumpParser(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(FilesKt.readText$default((File)file, null, (int)1, null), file.getPath());
    }

    @NotNull
    public final LibraryAbi parse() {
        while (!this.cursor.isFinished()) {
            AbiDeclaration abiDeclaration;
            if (this.parseDeclaration(null) == null) continue;
            boolean bl = false;
            this.declarations.add(abiDeclaration);
        }
        String string = this.uniqueName;
        Set<AbiSignatureVersion> set = this.signatureVersions;
        AbiTopLevelDeclarationsImpl abiTopLevelDeclarationsImpl = new AbiTopLevelDeclarationsImpl(this.declarations);
        LibraryManifest libraryManifest = new LibraryManifest(null, CollectionsKt.emptyList(), null, null, null);
        return new LibraryAbi(libraryManifest, string, set, abiTopLevelDeclarationsImpl);
    }

    @NotNull
    public final AbiClass parseClass$kotlin_util_klib_abi(@Nullable AbiQualifiedName parentQualifiedName) {
        List<AbiDeclaration> list;
        AbiModality abiModality = KlibParsingCursorExtensionsKt.parseAbiModality(this.cursor);
        if (abiModality == null) {
            throw this.parseException("Failed to parse class modality");
        }
        AbiModality modality = abiModality;
        Set<String> modifiers = KlibParsingCursorExtensionsKt.parseClassModifiers(this.cursor);
        boolean isInner = modifiers.contains("inner");
        boolean isValue = modifiers.contains("value");
        boolean isFunction = modifiers.contains("fun");
        AbiClassKind abiClassKind = KlibParsingCursorExtensionsKt.parseClassKind(this.cursor);
        if (abiClassKind == null) {
            throw this.parseException("Failed to parse class kind");
        }
        AbiClassKind kind = abiClassKind;
        List list2 = KlibParsingCursorExtensionsKt.parseTypeParams$default(this.cursor, false, 1, null);
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List typeParams = list2;
        AbiQualifiedName abiQualifiedName = this.parseAbiQualifiedName(parentQualifiedName);
        Set<AbiType> superTypes = KlibParsingCursorExtensionsKt.parseSuperTypes(this.cursor);
        if (KlibParsingCursorExtensionsKt.parseOpenClassBody(this.cursor) != null) {
            this.cursor.nextLine();
            list = this.parseChildDeclarations(abiQualifiedName);
        } else {
            list = CollectionsKt.emptyList();
        }
        List<AbiDeclaration> childDeclarations = list;
        return new AbiClassImpl(abiQualifiedName, this.currentSignatures(), AbiAnnotationListImpl.Companion.getEMPTY(), modality, kind, isInner, isValue, isFunction, CollectionsKt.toList((Iterable)superTypes), childDeclarations, typeParams);
    }

    public static /* synthetic */ AbiClass parseClass$kotlin_util_klib_abi$default(KlibDumpParser klibDumpParser, AbiQualifiedName abiQualifiedName, int n, Object object) {
        if ((n & 1) != 0) {
            abiQualifiedName = null;
        }
        return klibDumpParser.parseClass$kotlin_util_klib_abi(abiQualifiedName);
    }

    @NotNull
    public final AbiFunction parseFunction$kotlin_util_klib_abi(@Nullable AbiQualifiedName parentQualifiedName, boolean isGetterOrSetter) {
        AbiFunction abiFunction;
        AbiModality modality = KlibParsingCursorExtensionsKt.parseAbiModality(this.cursor);
        boolean isConstructor = Intrinsics.areEqual((Object)KlibParsingCursorExtensionsKt.parseFunctionKind(this.cursor, true), (Object)"constructor");
        if (isConstructor) {
            abiFunction = this.parseConstructor(parentQualifiedName);
        } else {
            AbiModality abiModality = modality;
            if (abiModality == null) {
                throw this.parseException("Non constructor function must have modality");
            }
            abiFunction = this.parseNonConstructorFunction(parentQualifiedName, isGetterOrSetter, abiModality);
        }
        return abiFunction;
    }

    public static /* synthetic */ AbiFunction parseFunction$kotlin_util_klib_abi$default(KlibDumpParser klibDumpParser, AbiQualifiedName abiQualifiedName, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            abiQualifiedName = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return klibDumpParser.parseFunction$kotlin_util_klib_abi(abiQualifiedName, bl);
    }

    @NotNull
    public final AbiProperty parseProperty$kotlin_util_klib_abi(@Nullable AbiQualifiedName parentQualifiedName) {
        AbiModality abiModality = KlibParsingCursorExtensionsKt.parseAbiModality(this.cursor);
        if (abiModality == null) {
            throw this.parseException("Unable to parse modality for property");
        }
        AbiModality modality = abiModality;
        AbiPropertyKind abiPropertyKind = KlibParsingCursorExtensionsKt.parsePropertyKind(this.cursor);
        if (abiPropertyKind == null) {
            throw this.parseException("Unable to parse kind for property");
        }
        AbiPropertyKind kind = abiPropertyKind;
        AbiQualifiedName qualifiedName = this.parseAbiQualifiedName(parentQualifiedName);
        this.cursor.nextLine();
        AbiFunction getter = null;
        AbiFunction setter = null;
        while (!this.cursor.isFinished()) {
            if (KlibParsingCursorExtensionsKt.hasGetter(this.cursor)) {
                getter = this.parseFunction$kotlin_util_klib_abi(qualifiedName, true);
                continue;
            }
            if (!KlibParsingCursorExtensionsKt.hasSetter(this.cursor)) break;
            setter = this.parseFunction$kotlin_util_klib_abi(qualifiedName, true);
        }
        return new AbiPropertyImpl(qualifiedName, this.currentSignatures(), AbiAnnotationListImpl.Companion.getEMPTY(), modality, kind, getter, setter, null);
    }

    public static /* synthetic */ AbiProperty parseProperty$kotlin_util_klib_abi$default(KlibDumpParser klibDumpParser, AbiQualifiedName abiQualifiedName, int n, Object object) {
        if ((n & 1) != 0) {
            abiQualifiedName = null;
        }
        return klibDumpParser.parseProperty$kotlin_util_klib_abi(abiQualifiedName);
    }

    @NotNull
    public final AbiEnumEntry parseEnumEntry$kotlin_util_klib_abi(@Nullable AbiQualifiedName parentQualifiedName) {
        Object object;
        block5: {
            block4: {
                KlibParsingCursorExtensionsKt.parseEnumEntryKind$default(this.cursor, false, 1, null);
                String string = KlibParsingCursorExtensionsKt.parseEnumEntryName(this.cursor);
                if (string == null) {
                    throw this.parseException("Failed to parse enum name");
                }
                String enumName = string;
                object = parentQualifiedName;
                if (object == null) break block4;
                AbiQualifiedName it = object;
                boolean bl = false;
                String string2 = it.getRelativeName-l9-qHIQ() + '.' + enumName;
                object = string2;
                if (string2 != null) break block5;
            }
            throw this.parseException("Enum entry must have parent qualified name");
        }
        Object relativeName = object;
        AbiQualifiedName qualifiedName = new AbiQualifiedName(parentQualifiedName.getPackageName-l9-qHIQ(), AbiCompoundName.constructor-impl((String)relativeName), null);
        this.cursor.nextLine();
        return new AbiEnumEntryImpl(qualifiedName, this.currentSignatures(), AbiAnnotationListImpl.Companion.getEMPTY());
    }

    private final AbiDeclaration parseDeclaration(AbiQualifiedName parentQualifiedName) {
        if (KlibParsingCursorExtensionsKt.parseCommentMarker(this.cursor) != null) {
            this.parseCommentLine();
        } else {
            if (KlibParsingCursorExtensionsKt.hasClassKind(this.cursor)) {
                return this.parseClass$kotlin_util_klib_abi(parentQualifiedName);
            }
            if (KlibParsingCursorExtensionsKt.hasFunctionKind(this.cursor)) {
                return KlibDumpParser.parseFunction$kotlin_util_klib_abi$default(this, parentQualifiedName, false, 2, null);
            }
            if (KlibParsingCursorExtensionsKt.hasPropertyKind(this.cursor)) {
                return this.parseProperty$kotlin_util_klib_abi(parentQualifiedName);
            }
            if (KlibParsingCursorExtensionsKt.hasEnumEntry(this.cursor)) {
                return this.parseEnumEntry$kotlin_util_klib_abi(parentQualifiedName);
            }
            if (StringsKt.isBlank((CharSequence)this.cursor.getCurrentLine())) {
                this.cursor.nextLine();
            } else {
                throw this.parseException("Failed to parse unknown declaration");
            }
        }
        return null;
    }

    private final void parseCommentLine() {
        KlibParsingCursorExtensionsKt.parseCommentMarker(this.cursor);
        if (KlibParsingCursorExtensionsKt.hasLibraryUniqueName(this.cursor)) {
            String string = KlibParsingCursorExtensionsKt.parseLibraryUniqueName(this.cursor);
            if (string == null) {
                throw this.parseException("Failed to parse library unique name");
            }
            this.uniqueName = string;
        } else if (KlibParsingCursorExtensionsKt.hasSignatureVersion(this.cursor)) {
            AbiSignatureVersion abiSignatureVersion = KlibParsingCursorExtensionsKt.parseSignatureVersion(this.cursor);
            if (abiSignatureVersion == null) {
                throw this.parseException("Failed to parse signature version");
            }
            this.signatureVersions.add(abiSignatureVersion);
        }
        this.cursor.nextLine();
    }

    private final List<AbiDeclaration> parseChildDeclarations(AbiQualifiedName parentQualifiedName) {
        List childDeclarations = new ArrayList();
        while (KlibParsingCursorExtensionsKt.parseCloseClassBody(this.cursor, true) == null) {
            AbiDeclaration it;
            if (this.parseDeclaration(parentQualifiedName) == null) continue;
            boolean bl = false;
            childDeclarations.add(it);
        }
        this.cursor.nextLine();
        return childDeclarations;
    }

    private final AbiFunction parseNonConstructorFunction(AbiQualifiedName parentQualifiedName, boolean isGetterOrSetter, AbiModality modality) {
        Set<String> modifiers = KlibParsingCursorExtensionsKt.parseFunctionModifiers(this.cursor);
        boolean isInline = modifiers.contains("inline");
        boolean isSuspend = modifiers.contains("suspend");
        KlibParsingCursorExtensionsKt.parseFunctionKind$default(this.cursor, false, 1, null);
        List list = KlibParsingCursorExtensionsKt.parseTypeParams$default(this.cursor, false, 1, null);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        List typeParams = list;
        List<AbiValueParameter> contextAndReceiverParams = KlibParsingCursorExtensionsKt.parseContextAndReceiverParams(this.cursor);
        AbiQualifiedName abiQualifiedName = isGetterOrSetter ? this.parseAbiQualifiedNameForGetterOrSetter(parentQualifiedName) : this.parseAbiQualifiedName(parentQualifiedName);
        List list2 = KlibParsingCursorExtensionsKt.parseValueParameters$default(this.cursor, null, 1, null);
        if (list2 == null) {
            throw this.parseException("Couldn't parse value params");
        }
        List valueParameters = list2;
        AbiType returnType = KlibParsingCursorExtensionsKt.parseReturnType(this.cursor);
        this.cursor.nextLine();
        return new AbiFunctionImpl(abiQualifiedName, this.currentSignatures(), AbiAnnotationListImpl.Companion.getEMPTY(), modality, isInline, isSuspend, typeParams, CollectionsKt.plus((Collection)contextAndReceiverParams, (Iterable)valueParameters), returnType);
    }

    static /* synthetic */ AbiFunction parseNonConstructorFunction$default(KlibDumpParser klibDumpParser, AbiQualifiedName abiQualifiedName, boolean bl, AbiModality abiModality, int n, Object object) {
        if ((n & 1) != 0) {
            abiQualifiedName = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return klibDumpParser.parseNonConstructorFunction(abiQualifiedName, bl, abiModality);
    }

    private final AbiFunction parseConstructor(AbiQualifiedName parentQualifiedName) {
        AbiQualifiedName abiQualifiedName = parentQualifiedName;
        if (abiQualifiedName == null) {
            throw this.parseException("Cannot parse constructor outside of class context");
        }
        AbiQualifiedName it = abiQualifiedName;
        boolean bl = false;
        AbiQualifiedName abiQualifiedName2 = new AbiQualifiedName(parentQualifiedName.getPackageName-l9-qHIQ(), AbiCompoundName.constructor-impl(parentQualifiedName.getRelativeName-l9-qHIQ() + ".<init>"), null);
        KlibParsingCursorExtensionsKt.parseConstructorName(this.cursor);
        List list = KlibParsingCursorExtensionsKt.parseValueParameters$default(this.cursor, null, 1, null);
        if (list == null) {
            throw this.parseException("Couldn't parse value parameters for constructor");
        }
        List valueParameters = list;
        this.cursor.nextLine();
        return new AbiConstructorImpl(abiQualifiedName2, this.currentSignatures(), AbiAnnotationListImpl.Companion.getEMPTY(), false, valueParameters);
    }

    private final AbiQualifiedName parseAbiQualifiedName(AbiQualifiedName parentQualifiedName) {
        if (parentQualifiedName != null) {
            String identifier = KlibParsingCursorExtensionsKt.parseValidIdentifierAndMaybeTrim$default(this.cursor, false, false, 3, null);
            String relativeName = parentQualifiedName.getRelativeName-l9-qHIQ() + '.' + identifier;
            return new AbiQualifiedName(parentQualifiedName.getPackageName-l9-qHIQ(), AbiCompoundName.constructor-impl(relativeName), null);
        }
        AbiQualifiedName abiQualifiedName = KlibParsingCursorExtensionsKt.parseAbiQualifiedName$default(this.cursor, false, 1, null);
        if (abiQualifiedName == null) {
            throw this.parseException("Failed to parse qName");
        }
        return abiQualifiedName;
    }

    private final AbiQualifiedName parseAbiQualifiedNameForGetterOrSetter(AbiQualifiedName parentQualifiedName) {
        if (parentQualifiedName == null) {
            throw this.parseException("Failed to parse qName");
        }
        String string = KlibParsingCursorExtensionsKt.parseGetterOrSetterName$default(this.cursor, false, 1, null);
        if (string == null) {
            throw this.parseException("Failed to parse qName");
        }
        String identifier = string;
        String relativeName = parentQualifiedName.getRelativeName-l9-qHIQ() + '.' + identifier;
        return new AbiQualifiedName(parentQualifiedName.getPackageName-l9-qHIQ(), AbiCompoundName.constructor-impl(relativeName), null);
    }

    private final AbiSignatures currentSignatures() {
        boolean bl;
        boolean hasV1;
        block7: {
            boolean bl2;
            block6: {
                Iterable $this$any$iv = this.signatureVersions;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AbiSignatureVersion it = (AbiSignatureVersion)element$iv;
                        boolean bl3 = false;
                        if (!(it.getVersionNumber() == 1)) continue;
                        bl2 = true;
                        break block6;
                    }
                    bl2 = false;
                }
            }
            hasV1 = bl2;
            Iterable $this$any$iv = this.signatureVersions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbiSignatureVersion it = (AbiSignatureVersion)element$iv;
                    boolean bl4 = false;
                    if (!(it.getVersionNumber() == 2)) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        boolean hasV2 = bl;
        return new AbiSignaturesImpl(hasV1 ? "v1" : null, hasV2 ? "v2" : null);
    }

    private final ParseException parseException(String message) {
        return new ParseException(this.formatErrorMessage(message), this.cursor.getOffset());
    }

    private final String formatErrorMessage(String message) {
        String string;
        block3: {
            block2: {
                string = this.filePath;
                if (string == null) break block2;
                String it = string;
                boolean bl = false;
                String string2 = it + ':';
                string = string2;
                if (string2 != null) break block3;
            }
            string = "";
        }
        String maybeFilePath = string;
        String location = maybeFilePath + this.cursor.getRowIndex() + ':' + this.cursor.getColumnIndex();
        return message + " at " + location + ": '" + this.cursor.getCurrentLine() + '\'';
    }
}

