/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiMethod;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationArgumentImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMemberImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementPsiSource;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementSourceFactory;
import org.jetbrains.kotlin.name.Name;

public class JavaMethodImpl
extends JavaMemberImpl<PsiMethod>
implements JavaMethod {
    public JavaMethodImpl(@NotNull JavaElementPsiSource<PsiMethod> psiMethodSource) {
        if (psiMethodSource == null) {
            JavaMethodImpl.$$$reportNull$$$0(0);
        }
        super(psiMethodSource);
        PsiMethod method = psiMethodSource.getPsi();
        assert (!method.isConstructor()) : "PsiMethod which is a constructor should be wrapped in JavaConstructorImpl: " + method.getName();
    }

    public JavaMethodImpl(PsiMethod psiMethod) {
        this(JavaElementSourceFactory.getInstance(psiMethod.getProject()).createPsiSource(psiMethod));
    }

    @Override
    @NotNull
    public Name getName() {
        Name name2 = Name.identifier(((PsiMethod)this.getPsi()).getName());
        if (name2 == null) {
            JavaMethodImpl.$$$reportNull$$$0(1);
        }
        return name2;
    }

    @Override
    @NotNull
    public List<JavaTypeParameter> getTypeParameters() {
        List<JavaTypeParameter> list = JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiMethod)this.getPsi()).getTypeParameters(), this.getSourceFactory());
        if (list == null) {
            JavaMethodImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    @NotNull
    public List<JavaValueParameter> getValueParameters() {
        List<JavaValueParameter> list = JavaElementCollectionFromPsiArrayUtil.valueParameters(((PsiMethod)this.getPsi()).getParameterList().getParameters(), this.getSourceFactory());
        if (list == null) {
            JavaMethodImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @Nullable
    public JavaAnnotationArgument getAnnotationParameterDefaultValue() {
        PsiAnnotationMemberValue defaultValue;
        PsiMethod psiMethod = (PsiMethod)this.getPsi();
        if (psiMethod instanceof PsiAnnotationMethod && (defaultValue = ((PsiAnnotationMethod)psiMethod).getDefaultValue()) != null) {
            return JavaAnnotationArgumentImpl.Factory.create(defaultValue, null, this.getSourceFactory());
        }
        return null;
    }

    @Override
    public boolean getHasAnnotationParameterDefaultValue() {
        PsiMethod psiMethod = (PsiMethod)this.getPsi();
        return psiMethod instanceof PsiAnnotationMethod && ((PsiAnnotationMethod)psiMethod).getDefaultValue() != null;
    }

    @Override
    @NotNull
    public JavaType getReturnType() {
        JavaTypeImpl<?> javaTypeImpl = JavaTypeImpl.create(Objects.requireNonNull(((PsiMethod)this.getPsi()).getReturnType()), this.createMethodReturnTypeSource(this.psiElementSource));
        if (javaTypeImpl == null) {
            JavaMethodImpl.$$$reportNull$$$0(4);
        }
        return javaTypeImpl;
    }

    @Override
    public boolean isNative() {
        return JavaElementUtil.isNative(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethodSource";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/structure/impl/JavaMethodImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/structure/impl/JavaMethodImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

