/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi.psiUtil;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.stubs.IStubElementType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtClassLikeDeclaration;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtObjectLiteralExpression;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.psi.utils.ConstantExpressionUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/psi/psiUtil/ClassIdCalculator;", "", "<init>", "()V", "calculateClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "declaration", "Lorg/jetbrains/kotlin/psi/KtClassLikeDeclaration;", "inferConstantExpressionClassIdByPsi", "expression", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "psi-api"})
@SourceDebugExtension(value={"SMAP\nClassIdCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassIdCalculator.kt\norg/jetbrains/kotlin/psi/psiUtil/ClassIdCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1586#2:106\n1661#2,3:107\n*S KotlinDebug\n*F\n+ 1 ClassIdCalculator.kt\norg/jetbrains/kotlin/psi/psiUtil/ClassIdCalculator\n*L\n51#1:106\n51#1:107,3\n*E\n"})
public final class ClassIdCalculator {
    @NotNull
    public static final ClassIdCalculator INSTANCE = new ClassIdCalculator();

    private ClassIdCalculator() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassId calculateClassId(@NotNull KtClassLikeDeclaration declaration) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object element2;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        KtFile ktFile = null;
        List containingClasses = new ArrayList();
        for (Object element2 : PsiUtilsKt.getParentsWithSelf(declaration)) {
            PsiElement psiElement = element2;
            if (psiElement instanceof KtEnumEntry || psiElement instanceof KtCallElement || psiElement instanceof KtObjectLiteralExpression || psiElement instanceof KtCodeFragment || psiElement instanceof PsiErrorElement) {
                return null;
            }
            if (psiElement instanceof KtClassLikeDeclaration) {
                ((Collection)containingClasses).add(element2);
                continue;
            }
            if (psiElement instanceof KtFile) {
                ktFile = (KtFile)element2;
                break;
            }
            if (psiElement instanceof KtScript || !(psiElement instanceof KtDeclaration)) continue;
            return null;
        }
        if (ktFile == null) {
            return null;
        }
        element2 = CollectionsKt.asReversedMutable((List)containingClasses);
        FqName.Companion companion = FqName.Companion;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void containingClass;
            KtClassLikeDeclaration ktClassLikeDeclaration = (KtClassLikeDeclaration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = containingClass.getName();
            if (string == null) {
                String string2 = SpecialNames.NO_NAME_PROVIDED.asString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
            }
            collection.add(string);
        }
        FqName relativeClassName = companion.fromSegments((List)destination$iv$iv);
        return new ClassId(ktFile.getPackageFqName(), relativeClassName, false);
    }

    @Nullable
    public final ClassId inferConstantExpressionClassIdByPsi(@NotNull KtConstantExpression expression) {
        ClassId classId;
        Serializable serializable;
        IStubElementType elementType;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        IStubElementType iStubElementType = expression.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iStubElementType, (String)"getElementType(...)");
        IStubElementType iStubElementType2 = elementType = iStubElementType;
        if (Intrinsics.areEqual((Object)iStubElementType2, (Object)KtNodeTypes.INTEGER_CONSTANT) || Intrinsics.areEqual((Object)iStubElementType2, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
            boolean isFloatingPoint = Intrinsics.areEqual((Object)elementType, (Object)KtNodeTypes.FLOAT_CONSTANT);
            String string = expression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (ConstantExpressionUtils.hasIllegallyPositionedUnderscore(string, isFloatingPoint)) {
                return null;
            }
            String string2 = expression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            serializable = ConstantExpressionUtils.parseNumericLiteral(string2, isFloatingPoint);
        } else if (Intrinsics.areEqual((Object)iStubElementType2, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
            String string = expression.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            serializable = Boolean.valueOf(ConstantExpressionUtils.parseBooleanLiteral(string));
        } else {
            serializable = null;
        }
        Serializable convertedText = serializable;
        iStubElementType2 = elementType;
        if (Intrinsics.areEqual((Object)iStubElementType2, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
            if (!(convertedText instanceof Long)) {
                classId = null;
            } else {
                String string = expression.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (ConstantExpressionUtils.hasUnsignedLongNumericLiteralSuffix(string)) {
                    classId = StandardClassIds.INSTANCE.getULong();
                } else {
                    String string3 = expression.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                    if (ConstantExpressionUtils.hasLongNumericLiteralSuffix(string3)) {
                        classId = StandardClassIds.INSTANCE.getLong();
                    } else {
                        String string4 = expression.getText();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                        classId = ConstantExpressionUtils.hasUnsignedNumericLiteralSuffix(string4) ? (Long.compareUnsigned(ULong.constructor-impl((long)((Number)convertedText).longValue()), ULong.constructor-impl((long)((long)-1 & 0xFFFFFFFFL))) > 0 || Long.compareUnsigned(ULong.constructor-impl((long)((Number)convertedText).longValue()), ULong.constructor-impl((long)(0L & 0xFFFFFFFFL))) < 0 ? StandardClassIds.INSTANCE.getULong() : StandardClassIds.INSTANCE.getUInt()) : (((Number)convertedText).longValue() > Integer.MAX_VALUE || ((Number)convertedText).longValue() < Integer.MIN_VALUE ? StandardClassIds.INSTANCE.getLong() : StandardClassIds.INSTANCE.getInt());
                    }
                }
            }
        } else {
            classId = Intrinsics.areEqual((Object)iStubElementType2, (Object)KtNodeTypes.FLOAT_CONSTANT) ? (convertedText instanceof Float ? StandardClassIds.INSTANCE.getFloat() : StandardClassIds.INSTANCE.getDouble()) : (Intrinsics.areEqual((Object)iStubElementType2, (Object)KtNodeTypes.CHARACTER_CONSTANT) ? StandardClassIds.INSTANCE.getChar() : (Intrinsics.areEqual((Object)iStubElementType2, (Object)KtNodeTypes.BOOLEAN_CONSTANT) ? StandardClassIds.INSTANCE.getBoolean() : null));
        }
        return classId;
    }
}

