/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.configurations.yaml.icon;

import com.intellij.ide.IconProvider;
import com.intellij.ktor.KtorStarterIcons;
import com.intellij.ktor.configurations.yaml.YamlConfigUtilsKt;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyReference;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/ktor/configurations/yaml/icon/KtorYamlIconProvider;", "Lcom/intellij/ide/IconProvider;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getIcon", "Ljavax/swing/Icon;", "element", "Lcom/intellij/psi/PsiElement;", "flags", "", "intellij.ktor"})
public final class KtorYamlIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        MetaConfigKey metaConfigKey;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (element instanceof YAMLFile && YamlConfigUtilsKt.isKtorYamlConfigFile((YAMLFile)element)) {
            return KtorStarterIcons.Ktor;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return null;
        }
        return element instanceof YAMLKeyValue && YamlConfigUtilsKt.isInsideKtorYamlFile(element) ? ((metaConfigKey = MetaConfigKeyReference.getResolvedMetaConfigKey((PsiElement)element)) != null && (metaConfigKey = metaConfigKey.getPresentation()) != null ? metaConfigKey.getIcon() : null) : null;
    }
}

