/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.initializr.plugins;

import com.intellij.ide.IdeBundle;
import com.intellij.ktor.initializr.json.KtorPluginSearchResult;
import com.intellij.ktor.initializr.plugins.KtorPluginEventHandler;
import com.intellij.ktor.initializr.plugins.KtorPluginsGroupComponent;
import com.intellij.ktor.initializr.plugins.ListKtorPluginComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.AsyncProcessIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0002J\u0006\u0010\u0016\u001a\u00020\u0011J\u0006\u0010\u0017\u001a\u00020\u0011J\b\u0010\u0018\u001a\u00020\u0011H\u0002J\u0006\u0010\u0019\u001a\u00020\u0011J\b\u0010\u001a\u001a\u00020\u0011H\u0016J\u000e\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u000fJ\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroupComponentWithProgress;", "Lcom/intellij/ktor/initializr/plugins/KtorPluginsGroupComponent;", "layout", "Ljava/awt/LayoutManager;", "eventHandler", "Lcom/intellij/ktor/initializr/plugins/KtorPluginEventHandler;", "function", "Lkotlin/Function1;", "Lcom/intellij/ktor/initializr/json/KtorPluginSearchResult;", "Lcom/intellij/ktor/initializr/plugins/ListKtorPluginComponent;", "<init>", "(Ljava/awt/LayoutManager;Lcom/intellij/ktor/initializr/plugins/KtorPluginEventHandler;Lkotlin/jvm/functions/Function1;)V", "myIcon", "Lcom/intellij/util/ui/AsyncProcessIcon;", "myVisibleRunnable", "Ljava/lang/Runnable;", "doLayout", "", "paint", "g", "Ljava/awt/Graphics;", "updateIconLocation", "startLoading", "stopLoading", "fullRepaint", "dispose", "clear", "setVisibleRunnable", "visibleRunnable", "setVisible", "aFlag", "", "intellij.ktor"})
public final class KtorPluginsGroupComponentWithProgress
extends KtorPluginsGroupComponent {
    @Nullable
    private AsyncProcessIcon myIcon;
    @Nullable
    private Runnable myVisibleRunnable;

    public KtorPluginsGroupComponentWithProgress(@NotNull LayoutManager layout, @NotNull KtorPluginEventHandler eventHandler, @NotNull Function1<? super KtorPluginSearchResult, ListKtorPluginComponent> function) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)eventHandler, (String)"eventHandler");
        Intrinsics.checkNotNullParameter(function, (String)"function");
        super(layout, eventHandler, function);
        this.myIcon = (AsyncProcessIcon)new AsyncProcessIcon.BigCentered(IdeBundle.message((String)"progress.text.loading", (Object[])new Object[0]));
        AsyncProcessIcon asyncProcessIcon = this.myIcon;
        Intrinsics.checkNotNull((Object)asyncProcessIcon);
        asyncProcessIcon.setOpaque(false);
        AsyncProcessIcon asyncProcessIcon2 = this.myIcon;
        Intrinsics.checkNotNull((Object)asyncProcessIcon2);
        asyncProcessIcon2.setPaintPassiveIcon(false);
        this.add((Component)this.myIcon);
        AsyncProcessIcon asyncProcessIcon3 = this.myIcon;
        Intrinsics.checkNotNull((Object)asyncProcessIcon3);
        asyncProcessIcon3.resume();
    }

    public void doLayout() {
        super.doLayout();
        this.updateIconLocation();
    }

    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        super.paint(g);
        this.updateIconLocation();
    }

    private final void updateIconLocation() {
        if (this.myIcon != null) {
            AsyncProcessIcon asyncProcessIcon = this.myIcon;
            Intrinsics.checkNotNull((Object)asyncProcessIcon);
            if (asyncProcessIcon.isVisible()) {
                AsyncProcessIcon asyncProcessIcon2 = this.myIcon;
                Intrinsics.checkNotNull((Object)asyncProcessIcon2);
                asyncProcessIcon2.updateLocation((JComponent)((Object)this));
            }
        }
    }

    public final void startLoading() {
        if (this.myIcon != null) {
            AsyncProcessIcon asyncProcessIcon = this.myIcon;
            Intrinsics.checkNotNull((Object)asyncProcessIcon);
            asyncProcessIcon.setVisible(true);
            AsyncProcessIcon asyncProcessIcon2 = this.myIcon;
            Intrinsics.checkNotNull((Object)asyncProcessIcon2);
            asyncProcessIcon2.resume();
            this.fullRepaint();
        }
    }

    public final void stopLoading() {
        if (this.myIcon != null) {
            AsyncProcessIcon asyncProcessIcon = this.myIcon;
            Intrinsics.checkNotNull((Object)asyncProcessIcon);
            asyncProcessIcon.suspend();
            AsyncProcessIcon asyncProcessIcon2 = this.myIcon;
            Intrinsics.checkNotNull((Object)asyncProcessIcon2);
            asyncProcessIcon2.setVisible(false);
            this.fullRepaint();
        }
    }

    private final void fullRepaint() {
        this.doLayout();
        this.revalidate();
        this.repaint();
    }

    public final void dispose() {
        if (this.myIcon != null) {
            this.remove((Component)this.myIcon);
            AsyncProcessIcon asyncProcessIcon = this.myIcon;
            Intrinsics.checkNotNull((Object)asyncProcessIcon);
            Disposer.dispose((Disposable)((Disposable)asyncProcessIcon));
            this.myIcon = null;
        }
    }

    @Override
    public void clear() {
        super.clear();
        if (this.myIcon != null) {
            this.add((Component)this.myIcon);
        }
    }

    public final void setVisibleRunnable(@NotNull Runnable visibleRunnable) {
        Intrinsics.checkNotNullParameter((Object)visibleRunnable, (String)"visibleRunnable");
        this.myVisibleRunnable = visibleRunnable;
    }

    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag && this.myVisibleRunnable != null) {
            Runnable runnable = this.myVisibleRunnable;
            Intrinsics.checkNotNull((Object)runnable);
            Runnable runnable2 = runnable;
            this.myVisibleRunnable = null;
            runnable2.run();
        }
    }
}

