/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.lang.ir.ControlFlow;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.database.Dbms;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DdlBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.SqlInspectionBase;
import com.intellij.sql.inspections.dataflow.SqlDataFlowInstructionVisitor;
import com.intellij.sql.inspections.dataflow.SqlDataFlowRunner;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblem;
import com.intellij.sql.inspections.dataflow.sql.problems.SqlNullabilityProblemKind;
import com.intellij.sql.psi.SqlBinaryExpression;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlDmlStatement;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlHavingClause;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlLiteralExpression;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlSpecialLiteralExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUnaryExpression;
import com.intellij.sql.psi.SqlWhereClause;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlConstantExpressionInspection;", "Lcom/intellij/sql/inspections/SqlInspectionBase;", "<init>", "()V", "createAnnotationVisitor", "Lcom/intellij/sql/inspections/SqlInspectionBase$SqlAnnotationVisitor;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "result", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "onTheFly", "", "MyConvertFix", "intellij.database.sql.impl"})
public final class SqlConstantExpressionInspection
extends SqlInspectionBase {
    @NotNull
    protected SqlInspectionBase.SqlAnnotationVisitor createAnnotationVisitor(@NotNull SqlLanguageDialectEx dialect, @NotNull InspectionManager manager, @NotNull List<ProblemDescriptor> result, boolean onTheFly) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        return new SqlInspectionBase.SqlAnnotationVisitor(manager, dialect, result, onTheFly){
            private int inQuery;
            private int inConditionClause;
            private final HashSet<PsiElement> processedElements;
            final /* synthetic */ InspectionManager $manager;
            final /* synthetic */ SqlLanguageDialectEx $dialect;
            final /* synthetic */ boolean $onTheFly;
            {
                this.$manager = $manager;
                this.$dialect = $dialect;
                this.$onTheFly = $onTheFly;
                super($manager, (SqlLanguageDialect)$dialect, (Collection)$result);
                this.processedElements = new HashSet<E>();
            }

            public final int getInQuery() {
                return this.inQuery;
            }

            public final void setInQuery(int n) {
                this.inQuery = n;
            }

            public final int getInConditionClause() {
                return this.inConditionClause;
            }

            public final void setInConditionClause(int n) {
                this.inConditionClause = n;
            }

            public final HashSet<PsiElement> getProcessedElements() {
                return this.processedElements;
            }

            private final void runDFA(SqlStatement statement) {
                Dbms dbms = this.$dialect.getDbms();
                Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
                Dbms dbms2 = dbms;
                if (dbms2.isPostgres() || dbms2.isMysql() || dbms2.isMicrosoft()) {
                    Project project = statement.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    SqlDataFlowRunner runner = new SqlDataFlowRunner(project, null, 2, null);
                    List<DfaMemoryState> list = Collections.singletonList(runner.createMemoryState());
                    Intrinsics.checkNotNullExpressionValue(list, (String)"singletonList(...)");
                    this.analyseStatement(statement, runner, list);
                }
            }

            public void visitSqlStatement(SqlStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlStatement(o);
                this.inQuery = 0;
            }

            public void visitSqlSelectStatement(SqlSelectStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlSelectStatement(o);
                this.runDFA((SqlStatement)o);
            }

            public void visitSqlDmlStatement(SqlDmlStatement o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlDmlStatement(o);
                this.runDFA((SqlStatement)o);
            }

            public void visitSqlQueryExpression(SqlQueryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlQueryExpression(o);
                int n = this.inQuery;
                this.inQuery = n + 1;
            }

            public void visitSqlWhereClause(SqlWhereClause o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.inConditionClause((SqlElement)o);
            }

            public void visitSqlHavingClause(SqlHavingClause o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.inConditionClause((SqlElement)o);
            }

            public void visitSqlJoinExpression(SqlJoinExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                this.inConditionClause((SqlElement)o);
            }

            public void elementFinished(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                if (element instanceof SqlQueryExpression) {
                    int n = this.inQuery;
                    this.inQuery = n + -1;
                } else if (element instanceof SqlWhereClause || element instanceof SqlHavingClause || element instanceof SqlJoinExpression) {
                    int n = this.inConditionClause;
                    this.inConditionClause = n + -1;
                }
            }

            public void visitSqlBinaryExpression(SqlBinaryExpression o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                super.visitSqlElement((SqlElement)o);
                this.checkConstantExpression(o);
                this.checkNullComparison(o);
            }

            private final void checkConstantExpression(SqlBinaryExpression o) {
                for (PsiElement e : PsiTreeUtilKt.parents((PsiElement)((PsiElement)o), (boolean)true)) {
                    if (!this.processedElements.contains(e)) continue;
                    return;
                }
                if (this.inConditionClause == 0) {
                    return;
                }
                if (this.inConditionClause % 2 != this.inQuery % 2) {
                    return;
                }
                SqlExpression sqlExpression = o.getLOperand();
                Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
                SqlExpression left = sqlExpression;
                SqlExpression right = o.getROperand();
                IElementType sign = o.getOpSign();
                if (left instanceof SqlSpecialLiteralExpression || right instanceof SqlSpecialLiteralExpression) {
                    return;
                }
                if (left instanceof SqlLiteralExpression && right instanceof SqlLiteralExpression && this.isComparisonOperator(sign) && StringUtil.equals((CharSequence)left.getText(), (CharSequence)((SqlLiteralExpression)right).getText())) {
                    this.reportProblem(o);
                    return;
                }
                if (!(left instanceof SqlReferenceExpression) || !(right instanceof SqlReferenceExpression)) {
                    return;
                }
                if (((SqlReferenceExpression)left).getReferenceElementType().getTargetKind() == ObjectKind.COLUMN && ((SqlReferenceExpression)right).getReferenceElementType().getTargetKind() == ObjectKind.COLUMN && this.isComparisonOperator(sign)) {
                    if (!this.sameTargets((PsiElement)left, (PsiElement)right)) {
                        return;
                    }
                    PsiElement leftTarget = ((SqlReferenceExpression)left).resolve();
                    if (leftTarget instanceof DasColumn && !((DasColumn)leftTarget).isNotNull()) {
                        return;
                    }
                    this.reportProblem(o);
                }
            }

            private final boolean checkNullComparison(SqlBinaryExpression o) {
                if (this.processedElements.contains(o)) {
                    return false;
                }
                if (PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlFunctionCallExpression.class) != null) {
                    return false;
                }
                return this.checkNullComparison(o, true) || this.checkNullComparison(o, false);
            }

            public final boolean checkNullComparison(SqlBinaryExpression o, boolean left) {
                boolean neq;
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                IElementType sign = o.getOpSign();
                SqlExpression r = o.getROperand();
                SqlExpression sqlExpression = o.getLOperand();
                Intrinsics.checkNotNullExpressionValue((Object)sqlExpression, (String)"getLOperand(...)");
                SqlExpression l = sqlExpression;
                SqlExpression operand = left ? l : r;
                SqlExpression opposite = left ? r : l;
                boolean eq = sign == SqlCommonTokens.SQL_OP_EQ;
                boolean bl = neq = sign == SqlCommonTokens.SQL_OP_NEQ || sign == SqlCommonTokens.SQL_OP_NEQ2 || sign == SqlCommonTokens.SQL_OP_NEQ3 || sign == SqlCommonTokens.SQL_OP_NEQ_WS || sign == SqlCommonTokens.SQL_OP_NEQ2_WS || sign == SqlCommonTokens.SQL_OP_NEQ3_WS;
                if ((eq || neq) && opposite != null && operand instanceof SqlSpecialLiteralExpression && ((SqlSpecialLiteralExpression)operand).isNull()) {
                    if (this.$dialect.getDbms().isTransactSql() && opposite instanceof SqlReferenceExpression && ((SqlReferenceExpression)opposite).getReferenceElementType().getTargetKind() == ObjectKind.VARIABLE) {
                        SqlSelectClause selectClause;
                        SqlQueryExpression query;
                        SqlQueryExpression sqlQueryExpression = query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)o), SqlQueryExpression.class);
                        Object object = selectClause = sqlQueryExpression != null ? sqlQueryExpression.getSelectClause() : null;
                        if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)selectClause), (PsiElement)((PsiElement)o), (boolean)true)) {
                            return false;
                        }
                    }
                    DdlBuilder ddlBuilder = new DdlBuilder().applyCodeStyle(o.getProject(), (SqlLanguageDialect)SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)o))).keyword("IS");
                    Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"keyword(...)");
                    DdlBuilder builder = ddlBuilder;
                    if (neq) {
                        builder.space().keyword("NOT");
                    }
                    String string = builder.space().keyword("NULL").getStatement();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
                    String what = string;
                    Object[] objectArray = new Object[]{what};
                    String string2 = SqlBundle.message((String)"inspection.message.suspicious.comparison.with.null.probably.operator.should.be.used", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    String text = string2;
                    Object[] objectArray2 = new Object[]{StringUtil.toUpperCase((String)what)};
                    String string3 = SqlBundle.message((String)"intention.family.name.use.operator", (Object[])objectArray2);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    String title = string3;
                    String replacement = opposite.getText() + " " + what;
                    this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)o, text, (LocalQuickFix)new MyConvertFix(title, replacement), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                    return true;
                }
                return false;
            }

            private final void reportProblem(SqlBinaryExpression expression) {
                IElementType sign = expression.getOpSign();
                boolean messageTrue = sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_GE;
                Object[] objectArray = new Object[]{expression.getText()};
                String string = SqlBundle.message((String)(messageTrue ? "condition.always.true" : "condition.always.false"), (Object[])objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                String message = string;
                this.addDescriptor(this.myManager.createProblemDescriptor((PsiElement)expression, message, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
            }

            private final void inConditionClause(SqlElement o) {
                int n;
                super.visitSqlElement(o);
                if (this.inQuery == 0) {
                    n = this.inQuery;
                    this.inQuery = n + 1;
                }
                n = this.inConditionClause;
                this.inConditionClause = n + 1;
            }

            private final boolean sameTargets(PsiElement left, PsiElement right) {
                List list = SqlImplUtil.resolveQualified((SqlReferenceExpression)(left instanceof SqlReferenceExpression ? (SqlReferenceExpression)left : null));
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"resolveQualified(...)");
                List leftResolve = list;
                List list2 = SqlImplUtil.resolveQualified((SqlReferenceExpression)(right instanceof SqlReferenceExpression ? (SqlReferenceExpression)right : null));
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"resolveQualified(...)");
                List rightResolve = list2;
                return leftResolve.size() == 1 && rightResolve.size() == 1 && Intrinsics.areEqual(leftResolve.get(0), rightResolve.get(0));
            }

            private final boolean isComparisonOperator(IElementType sign) {
                return sign == SqlTokens.SQL_OP_EQ || sign == SqlTokens.SQL_OP_LE || sign == SqlTokens.SQL_OP_GE || sign == SqlTokens.SQL_OP_LT || sign == SqlTokens.SQL_OP_GT || sign == SqlTokens.SQL_OP_NEQ || sign == SqlTokens.SQL_OP_NEQ2;
            }

            private final void analyseStatement(SqlStatement statement, SqlDataFlowRunner runner, List<? extends DfaMemoryState> initialStates) {
                ControlFlow flow = runner.buildFlow((PsiElement)statement, this.$dialect);
                if (flow != null) {
                    SqlNullabilityProblem it;
                    SqlNullabilityProblem element$iv;
                    SqlDataFlowInstructionVisitor listener2 = new SqlDataFlowInstructionVisitor();
                    if (runner.analyzeFlow((DfaListener)listener2, (Collection)initialStates, flow) != RunnerResult.OK) {
                        return;
                    }
                    Object $this$forEach$iv = listener2.getConstantExpressions();
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        it = element$iv = iterator.next();
                        boolean bl = false;
                        if (!(it.getKey() instanceof SqlBinaryExpression) && !(it.getKey() instanceof SqlUnaryExpression)) continue;
                        this.reportConstantCondition((PsiElement)it.getKey(), (SqlDataFlowInstructionVisitor.ConstantResult)it.getValue());
                    }
                    $this$forEach$iv = listener2.getNullabilityProblems();
                    $i$f$forEach = false;
                    iterator = $this$forEach$iv.iterator();
                    while (iterator.hasNext()) {
                        element$iv = iterator.next();
                        it = element$iv;
                        boolean bl = false;
                        if (it.getAnchor() instanceof SqlLiteralExpression) continue;
                        this.reportNullabilityProblem(it);
                    }
                }
            }

            public final void reportConstantCondition(PsiElement element, SqlDataFlowInstructionVisitor.ConstantResult cResult) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)cResult, (String)"cResult");
                if (cResult == SqlDataFlowInstructionVisitor.ConstantResult.TRUE || cResult == SqlDataFlowInstructionVisitor.ConstantResult.FALSE) {
                    if (!this.processedElements.add(element)) {
                        return;
                    }
                    boolean isTrue = cResult == SqlDataFlowInstructionVisitor.ConstantResult.TRUE;
                    Object[] objectArray = new Object[]{element.getText()};
                    String string = SqlBundle.message((String)(isTrue ? "condition.always.true" : "condition.always.false"), (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String message = string;
                    this.addDescriptor(this.$manager.createProblemDescriptor(element, message, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                }
            }

            public final void reportNullabilityProblem(SqlNullabilityProblem<?> problem) {
                Intrinsics.checkNotNullParameter(problem, (String)"problem");
                if (Intrinsics.areEqual((Object)problem.getKind(), (Object)SqlNullabilityProblemKind.NullExpression.INSTANCE)) {
                    PsiElement expression = problem.getAnchor();
                    if (!(expression instanceof SqlBinaryExpression) || !this.checkNullComparison((SqlBinaryExpression)expression)) {
                        String string;
                        PsiElement dereferencedExpr = problem.getDereferencedExpression();
                        if (!Intrinsics.areEqual((Object)dereferencedExpr, (Object)expression)) {
                            var6_4 = new Object[]{expression.getText()};
                            string = SqlBundle.message((String)"inspection.message.null.reference", (Object[])var6_4);
                        } else {
                            var6_4 = new Object[]{expression.getText()};
                            string = SqlBundle.message((String)"inspection.message.expression.always.null", (Object[])var6_4);
                        }
                        String string2 = string;
                        Intrinsics.checkNotNull((Object)string2);
                        String message = string2;
                        this.addDescriptor(this.$manager.createProblemDescriptor(expression, message, null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.$onTheFly));
                    }
                    this.processedElements.add(expression);
                }
            }
        };
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\b\b\u0001\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/sql/inspections/SqlConstantExpressionInspection$MyConvertFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "Lcom/intellij/openapi/project/DumbAware;", "title", "", "replacement", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "myReplacement", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.database.sql.impl"})
    private static final class MyConvertFix
    implements LocalQuickFix,
    DumbAware {
        @NotNull
        private final String title;
        @NotNull
        private final String myReplacement;

        public MyConvertFix(@IntentionFamilyName @NotNull String title, @NotNull String replacement) {
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
            this.title = title;
            this.myReplacement = replacement;
        }

        @NotNull
        public String getFamilyName() {
            return this.title;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            PsiElement element = descriptor.getPsiElement();
            SqlExpression sqlExpression = SqlPsiElementFactory.createExpressionFromText((String)this.myReplacement, (SqlLanguageDialect)((SqlLanguageDialect)SqlPsiUtilKt.getSqlDialect((PsiElement)element)), (Project)element.getProject(), null);
            if (sqlExpression == null) {
                return;
            }
            SqlExpression replacementExpr = sqlExpression;
            element.replace((PsiElement)replacementExpr);
        }
    }
}

