/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionBase;
import com.intellij.spring.model.highlighting.jam.SpringUastInspectionUtil;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;

public final class SpringJavaStaticMembersAutowiringInspection
extends SpringUastInspectionBase {
    public ProblemDescriptor[] checkMethod(@NotNull UMethod method, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (method == null) {
            SpringJavaStaticMembersAutowiringInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringJavaStaticMembersAutowiringInspection.$$$reportNull$$$0(1);
        }
        PsiElement sourcePsi = method.getSourcePsi();
        PsiMethod javaPsiMethod = method.getJavaPsi();
        if (sourcePsi == null) {
            return null;
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)sourcePsi.getContainingFile()) && method.isStatic() && SpringJavaStaticMembersAutowiringInspection.isAutowiredByAnnotation((PsiMember)javaPsiMethod)) {
            ProblemDescriptor[] problemDescriptorArray;
            PsiElement identifierSource = SpringUastInspectionUtil.INSTANCE.identifierSourcePsi(method);
            if (identifierSource == null) {
                problemDescriptorArray = null;
            } else {
                ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
                problemDescriptorArray = problemDescriptorArray2;
                problemDescriptorArray2[0] = SpringJavaStaticMembersAutowiringInspection.createDescriptor(identifierSource, manager, isOnTheFly);
            }
            return problemDescriptorArray;
        }
        return null;
    }

    private static boolean isAutowiredByAnnotation(PsiMember owner) {
        Collection<String> autowireAnnotations = SpringAutowireUtil.getAutowiredAnnotations(ModuleUtilCore.findModuleForPsiElement((PsiElement)owner));
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, autowireAnnotations, (int)0);
    }

    public ProblemDescriptor[] checkField(@NotNull UField field, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement sourcePsiElement;
        if (field == null) {
            SpringJavaStaticMembersAutowiringInspection.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            SpringJavaStaticMembersAutowiringInspection.$$$reportNull$$$0(3);
        }
        if ((sourcePsiElement = field.getSourcePsi()) == null) {
            return null;
        }
        if (!JamCommonUtil.isPlainJavaFile((PsiElement)sourcePsiElement.getContainingFile())) {
            return null;
        }
        PsiElement psiElement = field.getJavaPsi();
        if (psiElement instanceof PsiField) {
            PsiField javaPsiField = (PsiField)psiElement;
            if (field.isStatic() && SpringJavaStaticMembersAutowiringInspection.isAutowiredByAnnotation((PsiMember)javaPsiField)) {
                return new ProblemDescriptor[]{SpringJavaStaticMembersAutowiringInspection.createDescriptor((PsiElement)javaPsiField.getNameIdentifier(), manager, isOnTheFly)};
            }
        }
        return null;
    }

    private static ProblemDescriptor createDescriptor(PsiElement psiElement, InspectionManager manager, boolean isOnTheFly) {
        return manager.createProblemDescriptor(psiElement, SpringBundle.message("static.members.autowiring", new Object[0]), isOnTheFly, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/SpringJavaStaticMembersAutowiringInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

