/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.jam;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.jam.javaConfig.ContextJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.uast.UastHintedVisitorAdapter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationKt;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u001e\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/spring/model/highlighting/jam/SpringConfigurationProxyMethodsInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "hints", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "[Ljava/lang/Class;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isSpringComponentOrBeanSource", "sourcePsiClass", "Lcom/intellij/psi/PsiClass;", "checkMethodCall", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "configurationAnnotation", "Lcom/intellij/spring/model/jam/stereotype/SpringConfiguration;", "isSuperMethodCall", "uCallExpression", "callExprMethod", "Lcom/intellij/psi/PsiMethod;", "intellij.spring.core"})
@SourceDebugExtension(value={"SMAP\nSpringConfigurationProxyMethodsInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringConfigurationProxyMethodsInspection.kt\ncom/intellij/spring/model/highlighting/jam/SpringConfigurationProxyMethodsInspection\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n18#2:101\n18#2:102\n13225#3,2:103\n*S KotlinDebug\n*F\n+ 1 SpringConfigurationProxyMethodsInspection.kt\ncom/intellij/spring/model/highlighting/jam/SpringConfigurationProxyMethodsInspection\n*L\n89#1:101\n92#1:102\n95#1:103,2\n*E\n"})
public final class SpringConfigurationProxyMethodsInspection
extends LocalInspectionTool {
    @NotNull
    private final Class<? extends UElement>[] hints;

    public SpringConfigurationProxyMethodsInspection() {
        Class[] classArray = new Class[]{UCallExpression.class};
        this.hints = classArray;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)holder.getFile()));
        if (module == null || !SpringCommonUtils.isSpringConfigured((Module)module)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        Language language = holder.getFile().getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        return UastHintedVisitorAdapter.Companion.create$default((UastHintedVisitorAdapter.Companion)UastHintedVisitorAdapter.Companion, (Language)language, (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(this, holder){
            final /* synthetic */ SpringConfigurationProxyMethodsInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public boolean visitCallExpression(UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                this.visit(node);
                return super.visitCallExpression(node);
            }

            private final void visit(UCallExpression node) {
                if (node.hasKind(UastCallKind.METHOD_CALL)) {
                    UElement $this$getParentOfType_u24default$iv = (UElement)node;
                    boolean strict$iv = true;
                    boolean $i$f$getParentOfType22 = false;
                    UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UMethod.class, (boolean)strict$iv);
                    UDeclaration $i$f$getParentOfType22 = UDeclarationKt.getContainingDeclaration((UElement)((UElement)uMethod));
                    UClass uClass = $i$f$getParentOfType22 instanceof UClass ? (UClass)$i$f$getParentOfType22 : null;
                    if (uClass == null) {
                        return;
                    }
                    UClass uClass2 = uClass;
                    PsiClass sourcePsiClass = uClass2.getJavaPsi();
                    if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)sourcePsiClass)) {
                        return;
                    }
                    SpringConfiguration configurationAnnotation = (SpringConfiguration)SpringConfiguration.META.getJamElement((PsiModifierListOwner)sourcePsiClass);
                    if (configurationAnnotation != null && configurationAnnotation.isProxyBeanMethods()) {
                        return;
                    }
                    if (!SpringConfigurationProxyMethodsInspection.access$isSpringComponentOrBeanSource(this.this$0, sourcePsiClass)) {
                        return;
                    }
                    SpringConfigurationProxyMethodsInspection.access$checkMethodCall(this.this$0, node, configurationAnnotation, sourcePsiClass, this.$holder);
                }
            }
        }, (Class[])this.hints, (boolean)false, (int)8, null);
    }

    private final boolean isSpringComponentOrBeanSource(PsiClass sourcePsiClass) {
        if (SpringCommonUtils.isConfigurationOrMeta((PsiClass)sourcePsiClass)) {
            return true;
        }
        return SpringCommonUtils.isStereotypeComponentOrMeta((PsiClass)sourcePsiClass);
    }

    private final void checkMethodCall(UCallExpression node, SpringConfiguration configurationAnnotation, PsiClass sourcePsiClass, ProblemsHolder holder) {
        UIdentifier uIdentifier = node.getMethodIdentifier();
        if (uIdentifier == null || (uIdentifier = uIdentifier.getSourcePsi()) == null) {
            return;
        }
        UIdentifier methodName = uIdentifier;
        PsiMethod psiMethod = node.resolve();
        if (psiMethod == null) {
            return;
        }
        PsiMethod callExprMethod = psiMethod;
        PsiClass psiClass = callExprMethod.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass callTargetClass = psiClass;
        if (ContextJavaBean.METHOD_META.getJamElement((PsiModifierListOwner)callExprMethod) == null || !InheritanceUtil.isInheritorOrSelf((PsiClass)sourcePsiClass, (PsiClass)callTargetClass, (boolean)true)) {
            return;
        }
        if (this.isSuperMethodCall(node, callExprMethod)) {
            return;
        }
        String message = configurationAnnotation != null ? SpringBundle.message("bean.method.called.from.configuration.without.proxy", new Object[0]) : SpringBundle.message("bean.method.called.without.proxy", new Object[0]);
        holder.registerProblem((PsiElement)methodName, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isSuperMethodCall(UCallExpression uCallExpression, PsiMethod callExprMethod) {
        UElement $this$getParentOfType_u24default$iv = (UElement)uCallExpression;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UQualifiedReferenceExpression uQualifiedReferenceExpression = (UQualifiedReferenceExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv, UQualifiedReferenceExpression.class, (boolean)strict$iv);
        boolean isSuperCall = (uQualifiedReferenceExpression != null ? uQualifiedReferenceExpression.getReceiver() : null) instanceof USuperExpression;
        UElement $this$getParentOfType_u24default$iv2 = (UElement)uCallExpression;
        boolean strict$iv2 = true;
        boolean $i$f$getParentOfType2 = false;
        UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)$this$getParentOfType_u24default$iv2, UMethod.class, (boolean)strict$iv2);
        UMethod uMethod2 = uMethod;
        if (uMethod == null) return false;
        if ((uMethod2 = uMethod2.getJavaPsi()) == null) {
            return false;
        }
        UMethod psiMethod = uMethod2;
        PsiManager psiManager = psiMethod.getManager();
        if (!isSuperCall) return false;
        PsiMethod[] psiMethodArray = psiMethod.findSuperMethods();
        Intrinsics.checkNotNullExpressionValue((Object)psiMethodArray, (String)"findSuperMethods(...)");
        Object[] $this$any$iv = psiMethodArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            Object element$iv = $this$any$iv[n];
            PsiMethod superMethod = (PsiMethod)element$iv;
            boolean bl = false;
            if (psiManager.areElementsEquivalent((PsiElement)callExprMethod, (PsiElement)superMethod)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static final /* synthetic */ boolean access$isSpringComponentOrBeanSource(SpringConfigurationProxyMethodsInspection $this, PsiClass sourcePsiClass) {
        return $this.isSpringComponentOrBeanSource(sourcePsiClass);
    }

    public static final /* synthetic */ void access$checkMethodCall(SpringConfigurationProxyMethodsInspection $this, UCallExpression node, SpringConfiguration configurationAnnotation, PsiClass sourcePsiClass, ProblemsHolder holder) {
        $this.checkMethodCall(node, configurationAnnotation, sourcePsiClass, holder);
    }
}

