/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.diff.SwDiffUtilsKt;
import com.intellij.swagger.core.diff.actions.ComputeSwaggerDiffActionBase;
import com.intellij.swagger.core.diff.model.SwModifiedSpecification;
import com.intellij.swagger.core.diff.render.DiffMarkdownRenderer;
import com.intellij.testFramework.LightVirtualFile;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u0007H$J\u001e\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/swagger/core/diff/actions/ComputeSwaggerDiffActionBase;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isAvailable", "", "collectSpecifications", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiFile;", "actionPerformed", "intellij.swagger.core"})
public abstract class ComputeSwaggerDiffActionBase
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(this.isAvailable(e));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    protected abstract boolean isAvailable(@NotNull AnActionEvent var1);

    @Nullable
    protected abstract Pair<PsiFile, PsiFile> collectSpecifications(@NotNull AnActionEvent var1);

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        String string = SwaggerBundle.message("diff.computation.task.title", new Object[0]);
        PerformInBackgroundOption performInBackgroundOption = ComputeSwaggerDiffActionBase::actionPerformed$lambda$0;
        new Task.ConditionalModal(project2, this, e, string, performInBackgroundOption){
            final /* synthetic */ Project $project;
            final /* synthetic */ ComputeSwaggerDiffActionBase this$0;
            final /* synthetic */ AnActionEvent $e;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$e = $e;
                super($project, $super_call_param$1, true, $super_call_param$2);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Pair<PsiFile, PsiFile> pair = this.this$0.collectSpecifications(this.$e);
                if (pair == null) {
                    return;
                }
                Pair<PsiFile, PsiFile> pair2 = pair;
                PsiFile original = (PsiFile)pair2.component1();
                PsiFile modified = (PsiFile)pair2.component2();
                String string = (String)ActionsKt.runReadAction(() -> actionPerformed.1.run$lambda$0(original, modified));
                if (string == null) {
                    return;
                }
                String diffResultText = string;
                LightVirtualFile lightVirtualFile = new LightVirtualFile("API Diff " + modified.getName() + ".md", (CharSequence)diffResultText);
                OpenFileDescriptor descriptor = new OpenFileDescriptor(this.$project, (VirtualFile)lightVirtualFile);
                ApplicationManager.getApplication().invokeLater(() -> actionPerformed.1.run$lambda$1(this.$project, descriptor));
            }

            private static final String run$lambda$0(PsiFile $original, PsiFile $modified) {
                SwModifiedSpecification swModifiedSpecification = SwDiffUtilsKt.computeSwaggerDiff($original, $modified);
                if (swModifiedSpecification == null) {
                    return null;
                }
                SwModifiedSpecification diff = swModifiedSpecification;
                return DiffMarkdownRenderer.INSTANCE.renderDiff(diff);
            }

            private static final void run$lambda$1(Project $project, OpenFileDescriptor $descriptor) {
                FileEditorManager.getInstance((Project)$project).openEditor($descriptor, true);
            }
        }.queue();
    }

    private static final boolean actionPerformed$lambda$0() {
        return false;
    }
}

