/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.diff.model;

import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.diff.SwDiffResult;
import com.intellij.swagger.core.diff.SwDiffUtilsKt;
import com.intellij.swagger.core.diff.SwModificationType;
import com.intellij.swagger.core.diff.model.SwModifiedElement;
import com.intellij.swagger.core.diff.model.SwModifiedHttpOperation;
import com.intellij.swagger.core.diff.model.SwModifiedMediaType;
import com.intellij.swagger.core.diff.model.SwModifiedParameter;
import com.intellij.swagger.core.diff.model.SwModifiedPrimitive;
import com.intellij.swagger.core.diff.model.SwModifiedResponse;
import com.intellij.swagger.core.diff.model.SwModifiedRootElement;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwMediaType;
import com.intellij.swagger.core.model.api.SwParameter;
import com.intellij.swagger.core.model.api.SwResponse;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020%0\u00160$H\u0016R\u0014\u0010\u0003\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR!\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0014\u001a\u0004\b\u0018\u0010\u0019R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u0014\u001a\u0004\b\u001d\u0010\u0019R!\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0014\u001a\u0004\b!\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/intellij/swagger/core/diff/model/SwModifiedHttpOperation;", "Lcom/intellij/swagger/core/diff/model/SwModifiedElement;", "Lcom/intellij/swagger/core/model/api/SwHttpOperation;", "original", "modified", "root", "Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "<init>", "(Lcom/intellij/swagger/core/model/api/SwHttpOperation;Lcom/intellij/swagger/core/model/api/SwHttpOperation;Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;)V", "getOriginal", "()Lcom/intellij/swagger/core/model/api/SwHttpOperation;", "getModified", "getRoot", "()Lcom/intellij/swagger/core/diff/model/SwModifiedRootElement;", "myDeprecatedModified", "Lcom/intellij/swagger/core/diff/model/SwModifiedPrimitive;", "", "getMyDeprecatedModified", "()Lcom/intellij/swagger/core/diff/model/SwModifiedPrimitive;", "myDeprecatedModified$delegate", "Lkotlin/Lazy;", "myParametersDiff", "Lcom/intellij/swagger/core/diff/SwDiffResult;", "Lcom/intellij/swagger/core/model/api/SwParameter;", "getMyParametersDiff", "()Lcom/intellij/swagger/core/diff/SwDiffResult;", "myParametersDiff$delegate", "myResponsesDiff", "Lcom/intellij/swagger/core/model/api/SwResponse;", "getMyResponsesDiff", "myResponsesDiff$delegate", "myConsumedMediaTypesDiff", "Lcom/intellij/swagger/core/model/api/SwMediaType;", "getMyConsumedMediaTypesDiff", "myConsumedMediaTypesDiff$delegate", "computeChildrenDiffs", "", "", "intellij.swagger.core"})
public final class SwModifiedHttpOperation
implements SwModifiedElement<SwHttpOperation> {
    @NotNull
    private final SwHttpOperation original;
    @NotNull
    private final SwHttpOperation modified;
    @NotNull
    private final SwModifiedRootElement root;
    @NotNull
    private final Lazy myDeprecatedModified$delegate;
    @NotNull
    private final Lazy myParametersDiff$delegate;
    @NotNull
    private final Lazy myResponsesDiff$delegate;
    @NotNull
    private final Lazy myConsumedMediaTypesDiff$delegate;

    public SwModifiedHttpOperation(@NotNull SwHttpOperation original, @NotNull SwHttpOperation modified, @NotNull SwModifiedRootElement root) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        Intrinsics.checkNotNullParameter((Object)modified, (String)"modified");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        this.original = original;
        this.modified = modified;
        this.root = root;
        this.myDeprecatedModified$delegate = LazyKt.lazy(() -> SwModifiedHttpOperation.myDeprecatedModified_delegate$lambda$0(this));
        this.myParametersDiff$delegate = LazyKt.lazy(() -> SwModifiedHttpOperation.myParametersDiff_delegate$lambda$0(this));
        this.myResponsesDiff$delegate = LazyKt.lazy(() -> SwModifiedHttpOperation.myResponsesDiff_delegate$lambda$0(this));
        this.myConsumedMediaTypesDiff$delegate = LazyKt.lazy(() -> SwModifiedHttpOperation.myConsumedMediaTypesDiff_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public SwHttpOperation getOriginal() {
        return this.original;
    }

    @Override
    @NotNull
    public SwHttpOperation getModified() {
        return this.modified;
    }

    @Override
    @NotNull
    public SwModifiedRootElement getRoot() {
        return this.root;
    }

    private final SwModifiedPrimitive<Boolean> getMyDeprecatedModified() {
        Lazy lazy = this.myDeprecatedModified$delegate;
        return (SwModifiedPrimitive)lazy.getValue();
    }

    private final SwDiffResult<SwParameter> getMyParametersDiff() {
        Lazy lazy = this.myParametersDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    private final SwDiffResult<SwResponse> getMyResponsesDiff() {
        Lazy lazy = this.myResponsesDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    private final SwDiffResult<SwMediaType> getMyConsumedMediaTypesDiff() {
        Lazy lazy = this.myConsumedMediaTypesDiff$delegate;
        return (SwDiffResult)lazy.getValue();
    }

    @NotNull
    public Collection<SwDiffResult<? extends Object>> computeChildrenDiffs() {
        Object[] objectArray = new SwDiffResult[4];
        objectArray[0] = this.getMyParametersDiff();
        objectArray[1] = this.getMyResponsesDiff();
        objectArray[2] = this.getMyConsumedMediaTypesDiff();
        SwModifiedElement[] swModifiedElementArray = new SwModifiedElement[]{this.getMyDeprecatedModified()};
        objectArray[3] = SwDiffResult.Companion.fromModifications(swModifiedElementArray);
        return SetsKt.setOf((Object[])objectArray);
    }

    private static final SwModificationType myDeprecatedModified_delegate$lambda$0$0(SwModifiedPrimitive $this$SwModifiedPrimitive) {
        Intrinsics.checkNotNullParameter((Object)$this$SwModifiedPrimitive, (String)"$this$SwModifiedPrimitive");
        return (Boolean)$this$SwModifiedPrimitive.getOriginal() == false && (Boolean)$this$SwModifiedPrimitive.getModified() != false ? SwModificationType.DEPRECATION : SwModificationType.NO_CHANGES;
    }

    private static final SwModifiedPrimitive myDeprecatedModified_delegate$lambda$0(SwModifiedHttpOperation this$0) {
        return new SwModifiedPrimitive<Boolean>(SwaggerBundle.message("diff.fields.deprecated.title", new Object[0]), this$0.getOriginal().isDeprecated().getValue(), this$0.getModified().isDeprecated().getValue(), this$0.getRoot(), SwModifiedHttpOperation::myDeprecatedModified_delegate$lambda$0$0);
    }

    private static final Object myParametersDiff_delegate$lambda$0$0(SwParameter $this$calculateDiffBetween) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateDiffBetween, (String)"$this$calculateDiffBetween");
        return SwaggerUtilsKt.or($this$calculateDiffBetween.getParameterName(), "Unknown");
    }

    private static final SwModifiedElement myParametersDiff_delegate$lambda$0$1(SwModifiedHttpOperation this$0, SwParameter before, SwParameter after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return new SwModifiedParameter(before, after, this$0.getRoot());
    }

    private static final SwDiffResult myParametersDiff_delegate$lambda$0(SwModifiedHttpOperation this$0) {
        return SwDiffUtilsKt.calculateDiffBetween((Collection)this$0.getOriginal().getParameters(), (Collection)this$0.getModified().getParameters(), SwModifiedHttpOperation::myParametersDiff_delegate$lambda$0$0, (arg_0, arg_1) -> SwModifiedHttpOperation.myParametersDiff_delegate$lambda$0$1(this$0, arg_0, arg_1));
    }

    private static final Object myResponsesDiff_delegate$lambda$0$0(SwResponse $this$calculateDiffBetween) {
        Intrinsics.checkNotNullParameter((Object)$this$calculateDiffBetween, (String)"$this$calculateDiffBetween");
        return SwaggerUtilsKt.or($this$calculateDiffBetween.getHttpCode(), "Unknown");
    }

    private static final SwModifiedElement myResponsesDiff_delegate$lambda$0$1(SwModifiedHttpOperation this$0, SwResponse before, SwResponse after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return new SwModifiedResponse(before, after, this$0.getRoot());
    }

    private static final SwDiffResult myResponsesDiff_delegate$lambda$0(SwModifiedHttpOperation this$0) {
        return SwDiffUtilsKt.calculateDiffBetween((Collection)this$0.getOriginal().getResponses(), (Collection)this$0.getModified().getResponses(), SwModifiedHttpOperation::myResponsesDiff_delegate$lambda$0$0, (arg_0, arg_1) -> SwModifiedHttpOperation.myResponsesDiff_delegate$lambda$0$1(this$0, arg_0, arg_1));
    }

    private static final SwModifiedElement myConsumedMediaTypesDiff_delegate$lambda$0$0(SwModifiedHttpOperation this$0, SwMediaType before, SwMediaType after) {
        Intrinsics.checkNotNullParameter((Object)before, (String)"before");
        Intrinsics.checkNotNullParameter((Object)after, (String)"after");
        return new SwModifiedMediaType(before, after, this$0.getRoot());
    }

    private static final SwDiffResult myConsumedMediaTypesDiff_delegate$lambda$0(SwModifiedHttpOperation this$0) {
        return SwDiffUtilsKt.calculateDiffBetween(this$0.getOriginal().getConsumes(), this$0.getModified().getConsumes(), (Function1)myConsumedMediaTypesDiff.2.1.INSTANCE, (arg_0, arg_1) -> SwModifiedHttpOperation.myConsumedMediaTypesDiff_delegate$lambda$0$0(this$0, arg_0, arg_1));
    }
}

