/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.hub;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.swagger.core.SwConnectionTuner;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.hub.ApisJson;
import com.intellij.swagger.core.hub.HubRequest;
import com.intellij.swagger.core.hub.HubSpecification;
import com.intellij.swagger.core.hub.HubSpecificationModel;
import com.intellij.swagger.core.hub.Property;
import com.intellij.swagger.core.settings.SwaggerSettings;
import com.intellij.swagger.core.settings.SwaggerSettingsState;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.http.client.utils.URIBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u0007J\u0012\u0010\u0011\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00052\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001a\u001a\u00020 H\u0002J\u001a\u0010!\u001a\u0004\u0018\u00010\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002R\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/swagger/core/hub/SwaggerHubManager;", "", "<init>", "()V", "DEFAULT_SWAGGER_HUB_HOST", "", "GENERIC_HUB_SPECIFICATION_URL_PATTERN", "Lkotlin/text/Regex;", "OWNER_GROUP_INDEX", "", "PASSWORD_SAFE_ATTRIBUTES", "Lcom/intellij/credentialStore/CredentialAttributes;", "getPASSWORD_SAFE_ATTRIBUTES$intellij_swagger_core", "()Lcom/intellij/credentialStore/CredentialAttributes;", "mapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "retrieveToken", "retrieveHubHost", "project", "Lcom/intellij/openapi/project/Project;", "isSwaggerHubUrl", "", "host", "retrieveSpecifications", "", "Lcom/intellij/swagger/core/hub/HubSpecificationModel;", "request", "Lcom/intellij/swagger/core/hub/HubRequest;", "assembleSpecificationUrl", "partialUrl", "tryParseResponse", "Lcom/intellij/swagger/core/hub/ApisJson;", "Lcom/intellij/util/io/HttpRequests$Request;", "collectApisInformation", "specification", "Lcom/intellij/swagger/core/hub/HubSpecification;", "buildUrl", "getOwnerFromUrl", "url", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerHubManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerHubManager.kt\ncom/intellij/swagger/core/hub/SwaggerHubManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1#2:114\n1#2:126\n1#2:140\n1642#3,10:115\n1915#3:125\n1916#3:127\n1652#3:128\n1642#3,10:129\n1915#3:139\n1916#3:141\n1652#3:142\n*S KotlinDebug\n*F\n+ 1 SwaggerHubManager.kt\ncom/intellij/swagger/core/hub/SwaggerHubManager\n*L\n42#1:126\n70#1:140\n42#1:115,10\n42#1:125\n42#1:127\n42#1:128\n70#1:129,10\n70#1:139\n70#1:141\n70#1:142\n*E\n"})
public final class SwaggerHubManager {
    @NotNull
    public static final SwaggerHubManager INSTANCE = new SwaggerHubManager();
    @NlsSafe
    @NotNull
    public static final String DEFAULT_SWAGGER_HUB_HOST = "api.swaggerhub.com";
    @NotNull
    private static final Regex GENERIC_HUB_SPECIFICATION_URL_PATTERN = new Regex("https?://.*/apis/([^/&]+)/.*");
    private static final int OWNER_GROUP_INDEX = 1;
    @NotNull
    private static final CredentialAttributes PASSWORD_SAFE_ATTRIBUTES = new CredentialAttributes(CredentialAttributesKt.generateServiceName((String)"OpenAPI Specifications", (String)"api.swaggerhub.com"));
    @NotNull
    private static final ObjectMapper mapper = new ObjectMapper();

    private SwaggerHubManager() {
    }

    @NotNull
    public final CredentialAttributes getPASSWORD_SAFE_ATTRIBUTES$intellij_swagger_core() {
        return PASSWORD_SAFE_ATTRIBUTES;
    }

    @RequiresBackgroundThread
    @Nullable
    public final String retrieveToken() {
        return PasswordSafe.Companion.getInstance().getPassword(PASSWORD_SAFE_ATTRIBUTES);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String retrieveHubHost(Project project) {
        String string;
        Object object = project;
        if (object != null) {
            Project it = object;
            boolean bl = false;
            SwaggerSettings swaggerSettings = SwaggerSettings.Companion.getInstance(it);
            object = swaggerSettings;
            if (swaggerSettings != null && (object = (SwaggerSettingsState)object.getState()) != null) {
                string = ((SwaggerSettingsState)((Object)object)).getLocalHubAddress();
                return SwaggerUtilsKt.or(string, DEFAULT_SWAGGER_HUB_HOST);
            }
        }
        string = null;
        return SwaggerUtilsKt.or(string, DEFAULT_SWAGGER_HUB_HOST);
    }

    public final boolean isSwaggerHubUrl(@NotNull String host, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        return Intrinsics.areEqual((Object)host, (Object)this.retrieveHubHost(project));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<HubSpecificationModel> retrieveSpecifications(@NotNull HubRequest request) {
        List list;
        List list2;
        List<HubSpecification> list3;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ApisJson apisJson = (ApisJson)HttpRequests.request((String)this.buildUrl(request)).forceHttps(true).tuner(arg_0 -> SwaggerHubManager.retrieveSpecifications$lambda$0(request, arg_0)).connect(INSTANCE::tryParseResponse);
        if (apisJson != null && (list3 = apisJson.getApis()) != null) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Iterable iterable = list3;
            boolean $i$f$mapNotNull = false;
            void var6_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                HubSpecificationModel it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                HubSpecification it = (HubSpecification)element$iv$iv;
                boolean bl2 = false;
                if (INSTANCE.collectApisInformation(it, request) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = list = null;
        }
        if (list2 == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final String assembleSpecificationUrl(@NotNull String partialUrl) {
        String string;
        URIBuilder uRIBuilder;
        Intrinsics.checkNotNullParameter((Object)partialUrl, (String)"partialUrl");
        if (StringsKt.endsWith$default((String)partialUrl, (String)".yaml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)partialUrl, (String)".json", (boolean)false, (int)2, null)) {
            return partialUrl;
        }
        URIBuilder uRIBuilder2 = SwaggerUtilsKt.buildUrlFrom(partialUrl);
        return uRIBuilder2 != null && (uRIBuilder = SwaggerUtilsKt.addPathSegment(uRIBuilder2, "swagger.yaml")) != null && (string = uRIBuilder.toString()) != null ? string : partialUrl;
    }

    private final ApisJson tryParseResponse(HttpRequests.Request request) {
        ApisJson apisJson;
        try {
            apisJson = (ApisJson)mapper.readValue(request.getInputStream(), ApisJson.class);
        }
        catch (JsonProcessingException ex) {
            Logger.getInstance(SwaggerHubManager.class).warn("Unable to map swagger hub response into jackson wrapper", (Throwable)ex);
            apisJson = null;
        }
        catch (IOException ex) {
            Logger.getInstance(SwaggerHubManager.class).warn("Unable to read specifications from swagger hub into apis.json format", (Throwable)ex);
            apisJson = null;
        }
        return apisJson;
    }

    /*
     * WARNING - void declaration
     */
    private final HubSpecificationModel collectApisInformation(HubSpecification specification, HubRequest request) {
        Object object;
        String description2;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        List list = specification.getProperties();
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable iterable = list;
        boolean $i$f$mapNotNull = false;
        void var6_6 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv$iv$iv.iterator();
        while (object2.hasNext()) {
            Pair it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object2.next();
            boolean bl = false;
            Property it = (Property)element$iv$iv;
            boolean bl2 = false;
            if ((it.getType() != null ? TuplesKt.to((Object)it.getType(), (Object)it) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map properties = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String string = specification.getName();
        if (string == null) {
            return null;
        }
        String name2 = string;
        String string2 = specification.getDescription();
        if (string2 == null) {
            string2 = description2 = "";
        }
        if ((object = (Property)properties.get("Swagger")) == null || (object = ((Property)object).getUrl()) == null) {
            return null;
        }
        Object url2 = object;
        Object object3 = (Property)properties.get("X-Private");
        boolean isPrivate = object3 != null && (object3 = ((Property)object3).getValue()) != null ? Boolean.parseBoolean((String)object3) : false;
        Object object4 = (Property)properties.get("X-Published");
        boolean isPublished = object4 != null && (object4 = ((Property)object4).getValue()) != null ? Boolean.parseBoolean((String)object4) : false;
        Object it = object2 = request.getOwner();
        boolean bl = false;
        CharSequence charSequence = (CharSequence)it;
        Object object5 = !(charSequence == null || charSequence.length() == 0) ? object2 : null;
        if (object5 == null) {
            object5 = this.getOwnerFromUrl((String)url2);
        }
        Object owner = object5;
        Property property = (Property)properties.get("X-OASVersion");
        String string3 = property != null ? property.getValue() : null;
        if (string3 == null) {
            string3 = "";
        }
        String versionString = string3;
        SwSpecificationType.SwaggerLikeRestAPI specificationType = StringsKt.startsWith$default((String)versionString, (String)"2", (boolean)false, (int)2, null) ? (SwSpecificationType.SwaggerLikeRestAPI)SwSpecificationType.SWAGGER_2.INSTANCE : (StringsKt.startsWith$default((String)versionString, (String)"3", (boolean)false, (int)2, null) ? (SwSpecificationType.SwaggerLikeRestAPI)SwSpecificationType.OPENAPI_3.INSTANCE : null);
        return new HubSpecificationModel(name2, description2, (String)url2, isPrivate, isPublished, (String)owner, specificationType);
    }

    private final String buildUrl(HubRequest request) {
        String hubHost = this.retrieveHubHost(request.getProject());
        URIBuilder uRIBuilder = SwaggerUtilsKt.buildUrlFrom(hubHost);
        if (uRIBuilder == null) {
            URIBuilder uRIBuilder2;
            URIBuilder $this$buildUrl_u24lambda_u240 = uRIBuilder2 = new URIBuilder();
            boolean bl = false;
            $this$buildUrl_u24lambda_u240.setScheme("https");
            $this$buildUrl_u24lambda_u240.setHost(StringsKt.removeSuffix((String)StringsKt.removePrefix((String)hubHost, (CharSequence)"/"), (CharSequence)"/"));
            uRIBuilder = uRIBuilder2;
        }
        URIBuilder localOrDefaultHubAddress = uRIBuilder;
        String string = SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addParameterIfNotNull(SwaggerUtilsKt.addQueryParameter(SwaggerUtilsKt.addPathSegment(localOrDefaultHubAddress, "specs"), "query", request.getSearchedValue()), "owner", request.getOwner()), "state", request.getStateType().getState()), "visibility", request.getVisibilityType().getVisibility()), "specType", "API"), "order", request.getSortingAndOrdering().getOrder()), "sort", request.getSortingAndOrdering().getSort()), "limit", String.valueOf(request.getLimit())), "page", String.valueOf(request.getPage())).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getOwnerFromUrl(String url2) {
        Object object = GENERIC_HUB_SPECIFICATION_URL_PATTERN.matchEntire((CharSequence)url2);
        return object != null && (object = object.getGroupValues()) != null ? (String)object.get(1) : null;
    }

    private static final void retrieveSpecifications$lambda$0(HubRequest $request, URLConnection it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SwConnectionTuner.INSTANCE.tuneConnection(it, $request.getProject());
    }
}

