/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers.resolve;

import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.api.SwAuthority;
import com.intellij.swagger.core.model.api.SwEndpoint;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwModelBase;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwSchema;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.providers.resolve.SwEndpointTargetInfo;
import com.intellij.swagger.core.providers.resolve.SwUrlPathSpecification;
import com.intellij.swagger.core.providers.resolve.SwUrlTargetInfo;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006\u001a&\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00012\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u0007\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00012\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u001a\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a8\u0006\u0019"}, d2={"getOrComputeUrlOrEndpointTargets", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "url", "Lcom/intellij/swagger/core/model/api/SwUrl;", "isRemote", "", "computeUrlOrEndpointTargets", "urlPsiElement", "Lcom/intellij/psi/PsiElement;", "computeEndpointTargets", "endpoints", "Lcom/intellij/swagger/core/model/api/SwHttpOperation;", "computeUrlTargets", "computeBasePaths", "", "specification", "Lcom/intellij/swagger/core/model/api/SwModelBase;", "computeAuthorities", "Lcom/intellij/microservices/url/Authority$Exact;", "computeSchemes", "httpMethodUppercase", "", "modelElement", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwUrlTargetUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwUrlTargetUtils.kt\ncom/intellij/swagger/core/providers/resolve/SwUrlTargetUtilsKt\n+ 2 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,185:1\n35#2,2:186\n38#2,2:189\n38#2,2:209\n1#3:188\n1391#4:191\n1480#4,2:192\n1586#4:194\n1661#4,3:195\n1586#4:198\n1661#4,3:199\n1586#4:202\n1661#4,3:203\n1482#4,3:206\n1586#4:211\n1661#4,3:212\n1586#4:215\n1661#4,3:216\n1586#4:219\n1661#4,3:220\n1586#4:223\n1661#4,3:224\n1586#4:227\n1661#4,3:228\n1586#4:231\n1661#4,3:232\n37#5,2:235\n*S KotlinDebug\n*F\n+ 1 SwUrlTargetUtils.kt\ncom/intellij/swagger/core/providers/resolve/SwUrlTargetUtilsKt\n*L\n27#1:186,2\n36#1:189,2\n50#1:209,2\n41#1:191\n41#1:192,2\n43#1:194\n43#1:195,3\n44#1:198\n44#1:199,3\n45#1:202\n45#1:203,3\n41#1:206,3\n55#1:211\n55#1:212,3\n56#1:215\n56#1:216,3\n57#1:219\n57#1:220,3\n61#1:223\n61#1:224,3\n66#1:227\n66#1:228,3\n69#1:231\n69#1:232,3\n70#1:235,2\n*E\n"})
public final class SwUrlTargetUtilsKt {
    @NotNull
    public static final List<UrlTargetInfo> getOrComputeUrlOrEndpointTargets(@NotNull SwUrl url2, boolean isRemote) {
        Intrinsics.checkNotNullParameter((Object)url2, (String)"url");
        PsiElement psiElement = url2.getSourcePsi();
        if (psiElement == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement sourcePsi = psiElement;
        Object object = CachedValuesManager.getCachedValue((PsiElement)sourcePsi, () -> SwUrlTargetUtilsKt.getOrComputeUrlOrEndpointTargets$lambda$0(sourcePsi, isRemote));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    public static /* synthetic */ List getOrComputeUrlOrEndpointTargets$default(SwUrl swUrl, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return SwUrlTargetUtilsKt.getOrComputeUrlOrEndpointTargets(swUrl, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<UrlTargetInfo> computeUrlOrEndpointTargets(@NotNull PsiElement urlPsiElement, boolean isRemote) {
        List<UrlTargetInfo> list;
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)urlPsiElement, (String)"urlPsiElement");
        SwTreeUtil swTreeUtil = SwTreeUtil.INSTANCE;
        PsiElement psiElement$iv = urlPsiElement;
        boolean withSelf$iv = true;
        boolean $i$f$getParentOfType = false;
        SwUrl swUrl = $this$iv.getParentOfType(psiElement$iv, SwUrl.class, withSelf$iv);
        if (swUrl == null) {
            return CollectionsKt.emptyList();
        }
        SwUrl url2 = swUrl;
        List<UrlTargetInfo> list2 = SwUrlTargetUtilsKt.computeEndpointTargets(url2.getSupportedOperations(), isRemote);
        if (list2.isEmpty()) {
            boolean bl = false;
            list = SwUrlTargetUtilsKt.computeUrlTargets(url2);
        } else {
            list = list2;
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @ApiStatus.Internal
    @NotNull
    public static final List<UrlTargetInfo> computeEndpointTargets(@NotNull List<? extends SwHttpOperation> endpoints, boolean isRemote) {
        void $this$flatMapTo$iv$iv;
        void $this$iv;
        Intrinsics.checkNotNullParameter(endpoints, (String)"endpoints");
        if (endpoints.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        SwTreeUtil swTreeUtil = SwTreeUtil.INSTANCE;
        SwModelElement swElement$iv = (SwModelElement)CollectionsKt.first(endpoints);
        boolean withSelf$iv = false;
        boolean $i$f$getParentOfType = false;
        SwModelBase swModelBase = $this$iv.getParentOfType(swElement$iv.getSourcePsi(), SwModelBase.class, withSelf$iv);
        if (swModelBase == null) {
            return CollectionsKt.emptyList();
        }
        SwModelBase specification = swModelBase;
        List<String> schemes2 = SwUrlTargetUtilsKt.computeSchemes(specification);
        List<Authority.Exact> authorities2 = SwUrlTargetUtilsKt.computeAuthorities(specification);
        List<String> basePaths2 = SwUrlTargetUtilsKt.computeBasePaths(specification);
        Iterable $this$flatMap$iv = endpoints;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Object item$iv$iv;
            void $this$mapTo$iv$iv;
            Collection collection;
            Object item$iv$iv22;
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv;
            SwHttpOperation endpoint = (SwHttpOperation)element$iv$iv;
            boolean bl = false;
            Iterable iterable2 = basePaths2;
            boolean $i$f$map32 = false;
            void var17_19 = $this$map$iv;
            Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv22 : $this$mapTo$iv$iv2) {
                void basePath2;
                String string = (String)item$iv$iv22;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                String[] stringArray = new String[]{basePath2, endpoint.getUrl()};
                collection.add(SwaggerUtilsKt.buildUrlFromSegments(stringArray));
            }
            $this$map$iv = (List)destination$iv$iv2;
            SwUrlPathSpecification $i$f$map32 = SwUrlPathSpecification.INSTANCE;
            boolean $i$f$map22 = false;
            destination$iv$iv2 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            item$iv$iv22 = $this$mapTo$iv$iv.iterator();
            while (item$iv$iv22.hasNext()) {
                void p0;
                item$iv$iv = item$iv$iv22.next();
                String bl2 = (String)item$iv$iv;
                collection = destination$iv$iv3;
                boolean bl3 = false;
                collection.add($i$f$map32.parsePath((String)p0));
            }
            $this$map$iv = (List)destination$iv$iv3;
            $i$f$map32 = false;
            Iterable $i$f$map22 = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv22 : $this$mapTo$iv$iv2) {
                void parsedUrlPath;
                item$iv$iv = (UrlPath)item$iv$iv22;
                collection = destination$iv$iv2;
                boolean bl4 = false;
                collection.add(new SwEndpointTargetInfo(endpoint, (UrlPath)parsedUrlPath, schemes2, authorities2, isRemote));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List computeEndpointTargets$default(List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return SwUrlTargetUtilsKt.computeEndpointTargets(list, bl);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<UrlTargetInfo> computeUrlTargets(SwUrl url2) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Collection collection;
        void $this$mapTo$iv$iv3;
        Iterable $this$map$iv;
        void $this$iv;
        SwTreeUtil swTreeUtil = SwTreeUtil.INSTANCE;
        SwModelElement swElement$iv = url2;
        boolean withSelf$iv22 = false;
        boolean $i$f$getParentOfType = false;
        SwModelBase swModelBase = $this$iv.getParentOfType(swElement$iv.getSourcePsi(), SwModelBase.class, withSelf$iv22);
        if (swModelBase == null) {
            return CollectionsKt.emptyList();
        }
        SwModelBase specification = swModelBase;
        List<String> schemes2 = SwUrlTargetUtilsKt.computeSchemes(specification);
        List<Authority.Exact> authorities2 = SwUrlTargetUtilsKt.computeAuthorities(specification);
        List<String> basePaths2 = SwUrlTargetUtilsKt.computeBasePaths(specification);
        Iterable withSelf$iv22 = basePaths2;
        boolean $i$f$map22 = false;
        void var7_10 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void basePath2;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray = new String[]{basePath2, url2.getUrlString()};
            collection.add(SwaggerUtilsKt.buildUrlFromSegments(stringArray));
        }
        $this$map$iv = (List)destination$iv$iv;
        SwUrlPathSpecification $i$f$map22 = SwUrlPathSpecification.INSTANCE;
        boolean $i$f$map32 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void p0;
            String bl = (String)item$iv$iv2;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add($i$f$map22.parsePath((String)p0));
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        Iterable $i$f$map32 = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void parsedUrlPath;
            Object item$iv$iv2;
            item$iv$iv2 = (UrlPath)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SwUrlTargetInfo(url2, (UrlPath)parsedUrlPath, schemes2, authorities2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> computeBasePaths(SwModelBase specification) {
        String[] stringArray;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = specification.getBasePaths();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            SwUrl swUrl = (SwUrl)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getUrlString());
        }
        String[] p0 = stringArray = (String[])destination$iv$iv;
        boolean bl = false;
        Object object = !((Collection)p0).isEmpty() ? stringArray : null;
        stringArray = new String[]{""};
        return SwaggerUtilsKt.orDefaultValues(object, stringArray);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Authority.Exact> computeAuthorities(SwModelBase specification) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = specification.getAuthorities();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwAuthority swAuthority = (SwAuthority)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Authority.Exact(it.getAuthorityValue().getValue()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> computeSchemes(SwModelBase specification) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = specification.getSchemes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwSchema swSchema = (SwSchema)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SwaggerUtilsKt.withEndingSlash(it.getSchemaValue().getValue()));
        }
        Collection $this$toTypedArray$iv = UrlConstants.HTTP_SCHEMES;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        return SwaggerUtilsKt.orDefaultValues((List)destination$iv$iv, Arrays.copyOf(stringArray, stringArray.length));
    }

    @NotNull
    public static final Set<String> httpMethodUppercase(@NotNull SwModelElement modelElement) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)modelElement, (String)"modelElement");
        SwModelElement swModelElement = modelElement;
        if (swModelElement instanceof SwEndpoint) {
            String string = ((SwEndpoint)modelElement).getHttpMethod().getValue();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            set = SetsKt.setOf((Object)string2);
        } else {
            set = swModelElement instanceof SwUrl ? SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((SwUrl)modelElement).getSupportedOperations()), SwUrlTargetUtilsKt::httpMethodUppercase$lambda$0)) : SetsKt.emptySet();
        }
        return set;
    }

    private static final CachedValueProvider.Result getOrComputeUrlOrEndpointTargets$lambda$0(PsiElement $sourcePsi, boolean $isRemote) {
        List<UrlTargetInfo> list = SwUrlTargetUtilsKt.computeUrlOrEndpointTargets($sourcePsi, $isRemote);
        Object[] objectArray = new Object[1];
        Project project = $sourcePsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = SwaggerUtilsKt.getYamlJsonModificationTracker(project);
        return CachedValueProvider.Result.create(list, (Object[])objectArray);
    }

    private static final String httpMethodUppercase$lambda$0(SwHttpOperation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getHttpMethod().getValue();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toUpperCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        return string2;
    }
}

