/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.structureView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.navigation.ColoredItemPresentation;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.index.SwIndexUtilsKt;
import com.intellij.swagger.core.model.api.SwDefinition;
import com.intellij.swagger.core.model.api.SwHttpOperation;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.api.SwSyntheticContainer;
import com.intellij.swagger.core.model.api.SwSyntheticContainerKt;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.model.specification.SwaggerFileHelper;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Callback;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Example;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Header;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3Link;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3RequestBody;
import com.intellij.swagger.core.structureView.OpenapiStructureViewBuilder;
import com.intellij.swagger.core.structureView.OpenapiStructureViewElement;
import com.intellij.swagger.core.traverser.SpecificationTraverser;
import com.intellij.swagger.core.traverser.SpecificationTraverserFactory;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\t*\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\rH\u0002\u001a4\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002\u00a8\u0006\u0016"}, d2={"getStructureViewBuilderOrNull", "Lcom/intellij/ide/structureView/StructureViewBuilder;", "psiFile", "Lcom/intellij/psi/PsiFile;", "needShowElementInStructure", "", "modelElement", "Lcom/intellij/swagger/core/model/api/SwModelElement;", "traverser", "Lcom/intellij/swagger/core/traverser/SpecificationTraverser;", "Lcom/intellij/swagger/core/structureView/OpenapiStructureViewElement;", "createCategoryPresentation", "Lcom/intellij/navigation/ItemPresentation;", "Lcom/intellij/swagger/core/model/api/SwSyntheticContainer;", "createItemPresentation", "presentableText", "", "locationString", "icon", "Ljavax/swing/Icon;", "attributesKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nOpenapiStructureView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenapiStructureView.kt\ncom/intellij/swagger/core/structureView/OpenapiStructureViewKt\n+ 2 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n*L\n1#1,178:1\n38#2,2:179\n*S KotlinDebug\n*F\n+ 1 OpenapiStructureView.kt\ncom/intellij/swagger/core/structureView/OpenapiStructureViewKt\n*L\n136#1:179,2\n*E\n"})
public final class OpenapiStructureViewKt {
    private static final StructureViewBuilder getStructureViewBuilderOrNull(PsiFile psiFile) {
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (SwIndexUtilsKt.isIndexingRightNow(project) || !SwSpecificationDetectionKt.detectIsSwaggerLikeSpecificationFile(psiFile, false)) {
            return null;
        }
        VirtualFile virtualFile = psiFile.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile virtualFile2 = virtualFile;
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        SwSpecificationFile swSpecificationFile = SwaggerFileHelper.createSpecificationFile$default(SwaggerFileHelper.INSTANCE, psiFile, virtualFile2, project2, false, false, 24, null);
        if (swSpecificationFile == null) {
            return null;
        }
        SwSpecificationFile specification = swSpecificationFile;
        return (StructureViewBuilder)new OpenapiStructureViewBuilder(specification, psiFile);
    }

    private static final boolean needShowElementInStructure(SwModelElement modelElement) {
        SwModelElement swModelElement = modelElement;
        return swModelElement instanceof SwSpecificationFile || swModelElement instanceof SwUrl || swModelElement instanceof SwHttpOperation || swModelElement instanceof SwDefinition || swModelElement instanceof SwSyntheticContainer || swModelElement instanceof Openapi3RequestBody || swModelElement instanceof Openapi3Link || swModelElement instanceof Openapi3Header || swModelElement instanceof Openapi3Example || swModelElement instanceof Openapi3Callback;
    }

    private static final SpecificationTraverser traverser(OpenapiStructureViewElement $this$traverser) {
        FileType fileType = $this$traverser.getSourcePsi().getContainingFile().getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"getFileType(...)");
        SpecificationTraverser specificationTraverser = SpecificationTraverserFactory.INSTANCE.getTraverserFor(fileType);
        Intrinsics.checkNotNull((Object)specificationTraverser);
        return specificationTraverser;
    }

    /*
     * WARNING - void declaration
     */
    private static final ItemPresentation createCategoryPresentation(SwSyntheticContainer modelElement) {
        ItemPresentation itemPresentation;
        if (SwSyntheticContainerKt.isPathsContainer(modelElement)) {
            itemPresentation = OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.paths", new Object[0]), null, AllIcons.General.Web, null, 8, null);
        } else if (SwSyntheticContainerKt.isComponentsContainer(modelElement)) {
            itemPresentation = OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.components", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null);
        } else if (SwSyntheticContainerKt.isDefinitionsContainer(modelElement)) {
            void $this$iv;
            SwTreeUtil swTreeUtil = SwTreeUtil.INSTANCE;
            SwModelElement swElement$iv = modelElement;
            boolean withSelf$iv = false;
            boolean $i$f$getParentOfType = false;
            SwSpecificationFile swSpecificationFile = $this$iv.getParentOfType(swElement$iv.getSourcePsi(), SwSpecificationFile.class, withSelf$iv);
            SwSpecificationType specificationType = swSpecificationFile != null ? swSpecificationFile.getSpecificationType() : null;
            String presentableText = specificationType instanceof SwSpecificationType.OpenAPI3Family ? SwaggerBundle.message("structure.view.categories.openapi.v3.top.level.schemes", new Object[0]) : SwaggerBundle.message("structure.view.categories.swagger.v2.definitions", new Object[0]);
            itemPresentation = OpenapiStructureViewKt.createItemPresentation$default(presentableText, null, AllIcons.Hierarchy.Subtypes, null, 8, null);
        } else {
            itemPresentation = SwSyntheticContainerKt.isParametersContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.parameters", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isResponsesContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.responses", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isRequestBodiesContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.request.bodies", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isCallBacksContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.callbacks", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isExamplesContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.examples", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isHeadersContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.headers", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isLinksContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.links", new Object[0]), null, AllIcons.Hierarchy.Subtypes, null, 8, null) : (SwSyntheticContainerKt.isSecuritySchemesContainer(modelElement) ? OpenapiStructureViewKt.createItemPresentation$default(SwaggerBundle.message("structure.view.categories.openapi.v3.security.schemes", new Object[0]), null, AllIcons.Nodes.Padlock, null, 8, null) : OpenapiStructureViewKt.createItemPresentation$default(modelElement.getContainerName(), null, null, null, 14, null))))))));
        }
        return itemPresentation;
    }

    private static final ItemPresentation createItemPresentation(String presentableText, String locationString, Icon icon, TextAttributesKey attributesKey) {
        return (ItemPresentation)new ColoredItemPresentation(presentableText, locationString, icon, attributesKey){
            final /* synthetic */ String $presentableText;
            final /* synthetic */ String $locationString;
            final /* synthetic */ Icon $icon;
            final /* synthetic */ TextAttributesKey $attributesKey;
            {
                this.$presentableText = $presentableText;
                this.$locationString = $locationString;
                this.$icon = $icon;
                this.$attributesKey = $attributesKey;
            }

            public String getPresentableText() {
                return this.$presentableText;
            }

            public String getLocationString() {
                return this.$locationString;
            }

            public Icon getIcon(boolean unused) {
                return this.$icon;
            }

            public TextAttributesKey getTextAttributesKey() {
                return this.$attributesKey;
            }
        };
    }

    static /* synthetic */ ItemPresentation createItemPresentation$default(String string, String string2, Icon icon, TextAttributesKey textAttributesKey, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            icon = null;
        }
        if ((n & 8) != 0) {
            textAttributesKey = null;
        }
        return OpenapiStructureViewKt.createItemPresentation(string, string2, icon, textAttributesKey);
    }

    public static final /* synthetic */ StructureViewBuilder access$getStructureViewBuilderOrNull(PsiFile psiFile) {
        return OpenapiStructureViewKt.getStructureViewBuilderOrNull(psiFile);
    }

    public static final /* synthetic */ SpecificationTraverser access$traverser(OpenapiStructureViewElement $receiver) {
        return OpenapiStructureViewKt.traverser($receiver);
    }

    public static final /* synthetic */ ItemPresentation access$createItemPresentation(String presentableText, String locationString, Icon icon, TextAttributesKey attributesKey) {
        return OpenapiStructureViewKt.createItemPresentation(presentableText, locationString, icon, attributesKey);
    }

    public static final /* synthetic */ ItemPresentation access$createCategoryPresentation(SwSyntheticContainer modelElement) {
        return OpenapiStructureViewKt.createCategoryPresentation(modelElement);
    }

    public static final /* synthetic */ boolean access$needShowElementInStructure(SwModelElement modelElement) {
        return OpenapiStructureViewKt.needShowElementInStructure(modelElement);
    }
}

