/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.ui;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import com.intellij.swagger.core.ErrorType;
import com.intellij.swagger.core.SwaggerBundle;
import com.intellij.swagger.core.SwaggerFailure;
import com.intellij.swagger.core.SwaggerNavigableError;
import com.intellij.swagger.core.SwaggerValidationError;
import com.intellij.swagger.core.ui.ValidationData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t2\u0006\u0010\f\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007H\u0000\u001a\"\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002\u001a\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nH\u0002\u00a8\u0006\u001d"}, d2={"generateValidationError", "Lcom/intellij/swagger/core/SwaggerValidationError;", "exception", "Lcom/fasterxml/jackson/core/JsonProcessingException;", "containingFile", "Lcom/intellij/psi/PsiFile;", "getValidationResult", "", "validationResult", "", "", "Lcom/intellij/swagger/core/ui/ValidationData;", "originalSpecFile", "swaggerValidationFailure", "Lcom/intellij/swagger/core/SwaggerFailure;", "validationErrors", "swaggerNavigableError", "Lcom/intellij/swagger/core/SwaggerNavigableError;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "referenceName", "getPathRelativeToProjectRoot", "getReferenceOffsets", "Lkotlin/sequences/Sequence;", "", "fileContent", "reference", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSpecificationReferenceValidationHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecificationReferenceValidationHelper.kt\ncom/intellij/swagger/core/ui/SpecificationReferenceValidationHelperKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n129#3:96\n158#3,3:97\n11705#4:100\n12052#4,3:101\n296#5,2:104\n*S KotlinDebug\n*F\n+ 1 SpecificationReferenceValidationHelper.kt\ncom/intellij/swagger/core/ui/SpecificationReferenceValidationHelperKt\n*L\n35#1:96\n35#1:97,3\n83#1:100\n83#1:101,3\n84#1:104,2\n*E\n"})
public final class SpecificationReferenceValidationHelperKt {
    @NotNull
    public static final SwaggerValidationError generateValidationError(@NotNull JsonProcessingException exception, @NotNull PsiFile containingFile) {
        Object object;
        String string;
        VirtualFile virtualFile;
        block6: {
            block5: {
                LineColumn lineColumn;
                Intrinsics.checkNotNullParameter((Object)((Object)exception), (String)"exception");
                Intrinsics.checkNotNullParameter((Object)containingFile, (String)"containingFile");
                JsonLocation location = exception.getLocation();
                virtualFile = containingFile.getVirtualFile();
                JsonLocation jsonLocation = location;
                if (jsonLocation != null) {
                    JsonLocation it = jsonLocation;
                    boolean bl = false;
                    lineColumn = LineColumn.of((int)it.getLineNr(), (int)it.getColumnNr());
                } else {
                    lineColumn = null;
                }
                LineColumn coordinates = lineColumn;
                String string2 = exception.getOriginalMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOriginalMessage(...)");
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                object = coordinates;
                if (object == null) break block5;
                LineColumn it = object;
                boolean bl = false;
                Set set = SetsKt.setOf((Object)it);
                object = set;
                if (set != null) break block6;
            }
            object = SetsKt.emptySet();
        }
        Object object2 = object;
        Project project = containingFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Intrinsics.checkNotNull((Object)virtualFile);
        String string3 = SpecificationReferenceValidationHelperKt.getPathRelativeToProjectRoot(project, virtualFile);
        return new SwaggerValidationError(string, "error", string3, (Set<LineColumn>)object2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<SwaggerValidationError> getValidationResult(@NotNull Map<String, ValidationData> validationResult, @NotNull PsiFile originalSpecFile) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(validationResult, (String)"validationResult");
        Intrinsics.checkNotNullParameter((Object)originalSpecFile, (String)"originalSpecFile");
        String fileContent = ((Object)LoadTextUtil.loadText((VirtualFile)originalSpecFile.getVirtualFile())).toString();
        Project project = originalSpecFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = originalSpecFile.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        String relativePath = SpecificationReferenceValidationHelperKt.getPathRelativeToProjectRoot(project2, virtualFile);
        Map<String, ValidationData> $this$map$iv = validationResult;
        boolean $i$f$map = false;
        Map<String, ValidationData> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String currentFileReference = (String)entry.getKey();
            ValidationData validationData = (ValidationData)entry.getValue();
            Sequence<Integer> offsets = SpecificationReferenceValidationHelperKt.getReferenceOffsets(fileContent, currentFileReference);
            Sequence referenceCoordinates = SequencesKt.map(offsets, arg_0 -> SpecificationReferenceValidationHelperKt.getValidationResult$lambda$0$0(fileContent, arg_0));
            SwaggerNavigableError invalidSource = Intrinsics.areEqual((Object)validationData.getFile(), (Object)virtualFile) ? null : SpecificationReferenceValidationHelperKt.swaggerNavigableError(project2, validationData.getFile(), validationData.getReferenceName());
            collection.add(new SwaggerValidationError(validationData.getError(), currentFileReference, relativePath, SequencesKt.toSet((Sequence)referenceCoordinates), invalidSource));
        }
        List validationErrors = (List)destination$iv$iv;
        return validationErrors;
    }

    @NotNull
    public static final SwaggerFailure swaggerValidationFailure(@NotNull PsiFile originalSpecFile, @NotNull List<SwaggerValidationError> validationErrors) {
        Intrinsics.checkNotNullParameter((Object)originalSpecFile, (String)"originalSpecFile");
        Intrinsics.checkNotNullParameter(validationErrors, (String)"validationErrors");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)originalSpecFile.getName(), (String)"getName(...)");
        return new SwaggerFailure(ErrorType.VALIDATION, SwaggerBundle.message("preview.error.validation", objectArray), "Validation for file: " + originalSpecFile.getName() + " failed with errors: " + validationErrors, validationErrors);
    }

    private static final SwaggerNavigableError swaggerNavigableError(Project project, VirtualFile file, String referenceName) {
        String fileContent = VirtualFileUtil.readText((VirtualFile)file);
        Integer n = (Integer)SequencesKt.firstOrNull(SpecificationReferenceValidationHelperKt.getReferenceOffsets(fileContent, referenceName));
        if (n == null) {
            return null;
        }
        int offset = n;
        LineColumn lineColumn = StringUtil.offsetToLineColumn((CharSequence)fileContent, (int)offset);
        String string = SpecificationReferenceValidationHelperKt.getPathRelativeToProjectRoot(project, file);
        Intrinsics.checkNotNull((Object)lineColumn);
        return new SwaggerNavigableError(referenceName, string, lineColumn);
    }

    /*
     * WARNING - void declaration
     */
    private static final String getPathRelativeToProjectRoot(Project project, VirtualFile file) {
        String string;
        Object v3;
        block3: {
            void $this$mapTo$iv$iv;
            VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project).getContentRoots();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
            Object[] $this$map$iv = virtualFileArray;
            boolean $i$f$map = false;
            Object[] objectArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getPath());
            }
            Iterable $this$firstOrNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                String string2 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                CharSequence charSequence = string2;
                Intrinsics.checkNotNull((Object)it);
                if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        if ((string = (String)v3) == null) {
            string = "";
        }
        String rootPath = string;
        String string3 = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
        return StringsKt.substringAfter$default((String)string3, (String)rootPath, null, (int)2, null);
    }

    private static final Sequence<Integer> getReferenceOffsets(String fileContent, String reference) {
        Sequence matches = Regex.findAll$default((Regex)new Regex("[\"']" + reference + "[\"']"), (CharSequence)fileContent, (int)0, (int)2, null);
        return SequencesKt.sorted((Sequence)SequencesKt.distinct((Sequence)SequencesKt.map((Sequence)matches, SpecificationReferenceValidationHelperKt::getReferenceOffsets$lambda$0)));
    }

    private static final LineColumn getValidationResult$lambda$0$0(String $fileContent, int offset) {
        return StringUtil.offsetToLineColumn((CharSequence)$fileContent, (int)offset);
    }

    private static final int getReferenceOffsets$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getRange().getFirst();
    }
}

