/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.visualEditing;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.swagger.core.SwSpecificationDetectionKt;
import com.intellij.swagger.core.meta.SwElementProvider;
import com.intellij.swagger.core.model.api.SwModelElement;
import com.intellij.swagger.core.model.remote.RemoteSpecificationModel;
import com.intellij.swagger.core.settings.SwaggerSettings;
import com.intellij.swagger.core.settings.SwaggerSettingsState;
import com.intellij.swagger.core.visualEditing.SwGutterActionData;
import com.intellij.swagger.core.visualEditing.SwVisualEditingActionChooserKt;
import com.intellij.swagger.core.visualEditing.SwVisualEditingActionLineMarker;
import com.intellij.swagger.core.visualEditing.utils.SwInterval;
import com.intellij.swagger.core.visualEditing.utils.SwIntervalTreeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H&J,\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\f2\u0012\u0010\r\u001a\u000e\u0012\n\b\u0000\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/swagger/core/visualEditing/SwVisualEditingLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "<init>", "()V", "isSuitableElement", "", "psiElement", "Lcom/intellij/psi/PsiElement;", "getKeyOfKeyValue", "collectSlowLineMarkers", "", "elements", "", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getLineMarkerInfo", "element", "markerForElement", "Lcom/intellij/swagger/core/visualEditing/SwVisualEditingActionLineMarker;", "shouldDrawMarkers", "psiFile", "Lcom/intellij/psi/PsiFile;", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwVisualEditingLineMarkerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwVisualEditingLineMarkerProvider.kt\ncom/intellij/swagger/core/visualEditing/SwVisualEditingLineMarkerProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,82:1\n1642#2,10:83\n1915#2:93\n1916#2:95\n1652#2:96\n1586#2:97\n1661#2,3:98\n1#3:94\n*S KotlinDebug\n*F\n+ 1 SwVisualEditingLineMarkerProvider.kt\ncom/intellij/swagger/core/visualEditing/SwVisualEditingLineMarkerProvider\n*L\n53#1:83,10\n53#1:93\n53#1:95\n53#1:96\n55#1:97\n55#1:98,3\n53#1:94\n*E\n"})
public abstract class SwVisualEditingLineMarkerProvider
implements LineMarkerProvider {
    public abstract boolean isSuitableElement(@NotNull PsiElement var1);

    @Nullable
    public abstract PsiElement getKeyOfKeyValue(@NotNull PsiElement var1);

    /*
     * WARNING - void declaration
     */
    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        Collection<SwInterval> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        PsiElement psiElement = (PsiElement)CollectionsKt.firstOrNull(elements);
        if (psiElement == null) {
            return;
        }
        PsiElement anyElement = psiElement;
        PsiFile psiFile = anyElement.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        if (!this.shouldDrawMarkers(psiFile)) {
            return;
        }
        PsiFile psiFile2 = anyElement.getContainingFile();
        if (psiFile2 == null || (psiFile2 = psiFile2.getViewProvider()) == null || (psiFile2 = psiFile2.getDocument()) == null) {
            return;
        }
        PsiFile document = psiFile2;
        Iterable $this$mapNotNull$iv = elements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            SwVisualEditingActionLineMarker it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            PsiElement p0 = (PsiElement)element$iv$iv;
            boolean bl2 = false;
            if (this.markerForElement(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List markers = (List)destination$iv$iv;
        result2.addAll(markers);
        Project project = anyElement.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        $this$mapNotNull$iv = markers;
        Project project2 = project;
        PsiFile psiFile3 = document;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            object = (SwVisualEditingActionLineMarker)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getLineRange$intellij_swagger_core());
        }
        collection = (List)destination$iv$iv;
        SwIntervalTreeUtilsKt.rememberHighlightedRanges((Document)psiFile3, project2, (List<SwInterval>)collection);
    }

    @Nullable
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return null;
    }

    private final SwVisualEditingActionLineMarker markerForElement(PsiElement psiElement) {
        if (!this.isSuitableElement(psiElement)) {
            return null;
        }
        PsiElement psiElement2 = this.getKeyOfKeyValue(psiElement);
        if (psiElement2 == null) {
            return null;
        }
        PsiElement anchor = psiElement2;
        TextRange textRange = anchor.getTextRange();
        if (textRange == null) {
            return null;
        }
        TextRange textRange2 = textRange;
        Document document = psiElement.getContainingFile().getViewProvider().getDocument();
        if (document == null) {
            return null;
        }
        Document document2 = document;
        SwModelElement swModelElement = SwElementProvider.INSTANCE.getModelElement(psiElement);
        if (swModelElement == null) {
            return null;
        }
        SwModelElement modelElement = swModelElement;
        SwGutterActionData swGutterActionData = SwVisualEditingActionChooserKt.chooseSuitableActionForElement(modelElement);
        if (swGutterActionData == null) {
            return null;
        }
        SwGutterActionData actionData = swGutterActionData;
        SwInterval range = new SwInterval(document2.getLineNumber(PsiTreeUtilKt.getStartOffset((PsiElement)psiElement)), document2.getLineNumber(PsiTreeUtilKt.getEndOffset((PsiElement)psiElement)));
        Project project = anchor.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return new SwVisualEditingActionLineMarker(anchor, textRange2, actionData, range, document2, project);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldDrawMarkers(PsiFile psiFile) {
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (!((SwaggerSettingsState)SwaggerSettings.Companion.getInstance(project).getState()).getVisualEditingEnabled()) return false;
        if (psiFile.getTextLength() >= 1024000) return false;
        if (!SwSpecificationDetectionKt.detectIsSwaggerLikeSpecificationFile$default(psiFile, false, 2, null)) return false;
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        if (RemoteSpecificationModel.Companion.getInstance(project2).isRemoteSpecification(psiFile)) return false;
        return true;
    }
}

