/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.highlighting.beans;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.micronaut.MicronautBundle;
import com.intellij.micronaut.highlighting.beans.MnInjectionGeneratorHelper;
import com.intellij.micronaut.highlighting.beans.MnInjectionGeneratorHelperKt;
import com.intellij.micronaut.highlighting.beans.MnInjectionGeneratorService;
import com.intellij.microservices.jvm.inject.InjectionCommandContext;
import com.intellij.microservices.jvm.inject.InjectionGeneratorContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/micronaut/highlighting/beans/MnInjectionQuickFixProvider;", "Lcom/intellij/codeInsight/quickfix/UnresolvedReferenceQuickFixProvider;", "Lcom/intellij/psi/PsiReference;", "<init>", "()V", "registerFixes", "", "ref", "registrar", "Lcom/intellij/codeInsight/daemon/QuickFixActionRegistrar;", "getReferenceClass", "Ljava/lang/Class;", "AddDependencyIntention", "intellij.micronaut"})
public final class MnInjectionQuickFixProvider
extends UnresolvedReferenceQuickFixProvider<PsiReference> {
    public void registerFixes(@NotNull PsiReference ref, @NotNull QuickFixActionRegistrar registrar) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        PsiElement psiElement = ref.getElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getElement(...)");
        PsiElement psiElement2 = psiElement;
        USimpleNameReferenceExpression uSimpleNameReferenceExpression = (USimpleNameReferenceExpression)UastContextKt.toUElement((PsiElement)psiElement2, USimpleNameReferenceExpression.class);
        if (uSimpleNameReferenceExpression == null) {
            return;
        }
        USimpleNameReferenceExpression uExpression = uSimpleNameReferenceExpression;
        UClass uClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)uExpression), UClass.class, (boolean)false, (int)2, null);
        if (uClass == null) {
            return;
        }
        UClass uClass2 = uClass;
        PsiClass psiClass = uClass2.getJavaPsi();
        if (!MnInjectionGeneratorHelperKt.isSuitableForInjection(psiClass)) {
            return;
        }
        UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)uExpression), UMethod.class, (boolean)false, (int)2, null);
        if (uMethod == null) {
            return;
        }
        UMethod uMethod2 = uMethod;
        if (uMethod2.getJavaPsi().hasModifier(JvmModifier.STATIC)) {
            return;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement2);
        if (module == null) {
            return;
        }
        Module module2 = module;
        registrar.register((IntentionAction)new AddDependencyIntention(psiElement2, uExpression.getIdentifier(), uClass2, module2));
    }

    @NotNull
    public Class<PsiReference> getReferenceClass() {
        return PsiReference.class;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J$\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J!\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0096\u0002J\b\u0010\u001a\u001a\u00020\u0011H\u0016J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0017H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/micronaut/highlighting/beans/MnInjectionQuickFixProvider$AddDependencyIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "psiElement", "Lcom/intellij/psi/PsiElement;", "name", "", "uClass", "Lorg/jetbrains/uast/UClass;", "module", "Lcom/intellij/openapi/module/Module;", "<init>", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;Lorg/jetbrains/uast/UClass;Lcom/intellij/openapi/module/Module;)V", "elementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "getText", "getFamilyName", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "startInWriteAction", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "getElementToMakeWritable", "currentFile", "intellij.micronaut"})
    private static final class AddDependencyIntention
    implements IntentionAction {
        @NotNull
        private final String name;
        @NotNull
        private final UClass uClass;
        @NotNull
        private final Module module;
        @NotNull
        private final SmartPsiElementPointer<PsiElement> elementPointer;

        public AddDependencyIntention(@NotNull PsiElement psiElement, @NotNull String name, @NotNull UClass uClass, @NotNull Module module) {
            Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)uClass, (String)"uClass");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            this.name = name;
            this.uClass = uClass;
            this.module = module;
            this.elementPointer = SmartPointersKt.createSmartPointer((PsiElement)psiElement);
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.name};
            return MicronautBundle.message("micronaut.add.bean.dependency.fix.text", objectArray);
        }

        @NotNull
        public String getFamilyName() {
            return MicronautBundle.message("micronaut.add.bean.dependency.fix.family.name", new Object[0]);
        }

        public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            PsiElement psiElement = this.elementPointer.getElement();
            return Intrinsics.areEqual((Object)this.name, psiElement != null && (psiElement = (USimpleNameReferenceExpression)UastContextKt.toUElement((PsiElement)psiElement, USimpleNameReferenceExpression.class)) != null ? psiElement.getIdentifier() : null);
        }

        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            InjectionCommandContext commandContext = new InjectionCommandContext(MnInjectionGeneratorService.Companion.getInstance(project).getScope(), new Object(), this.getText());
            InjectionGeneratorContext context = new InjectionGeneratorContext(this.uClass, project, psiFile, editor, commandContext, false, null, 96, null);
            SmartPsiElementPointer<PsiElement> smartPsiElementPointer = this.elementPointer;
            String string = this.name;
            Module module = this.module;
            MnInjectionGeneratorHelper generator2 = new MnInjectionGeneratorHelper(context, smartPsiElementPointer, string, module){

                protected String getElementIdentifier(PsiElement psiElement) {
                    Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
                    USimpleNameReferenceExpression uSimpleNameReferenceExpression = (USimpleNameReferenceExpression)UastContextKt.toUElement((PsiElement)psiElement, USimpleNameReferenceExpression.class);
                    return uSimpleNameReferenceExpression != null ? uSimpleNameReferenceExpression.getIdentifier() : null;
                }
            };
            generator2.invoke();
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }

        @NotNull
        public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
            Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
            return (PsiElement)currentFile;
        }
    }
}

