/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.profilers.async.core.actions;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.profilers.Profiler;
import com.jetbrains.performancePlugin.profilers.ProfilerHandlerUtils;
import com.jetbrains.performancePlugin.profilers.async.core.AsyncProfilerHandler;
import com.jetbrains.performancePlugin.profilers.async.core.actions.StartStopAsyncProfilerAction;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0007J\r\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/jetbrains/performancePlugin/profilers/async/core/actions/CpuSnapshotManager;", "", "<init>", "()V", "myActiveDumpPath", "", "triggerEnabled", "", "project", "Lcom/intellij/openapi/project/Project;", "isRunning", "", "isRunning$intellij_performanceTesting_async_core", "intellij.performanceTesting.async.core"})
public final class CpuSnapshotManager {
    @NotNull
    public static final CpuSnapshotManager INSTANCE = new CpuSnapshotManager();
    @Nullable
    private static volatile String myActiveDumpPath;

    private CpuSnapshotManager() {
    }

    @JvmStatic
    public static final void triggerEnabled(@Nullable Project project) {
        AsyncProfilerHandler profiler = AsyncProfilerHandler.Companion.getInstance();
        if (!INSTANCE.isRunning$intellij_performanceTesting_async_core()) {
            try {
                myActiveDumpPath = FileUtil.createTempFile((String)"cpu-profiling", (String)".jfr").getAbsolutePath();
                String cpuEvent = profiler.getCpuEvent();
                Object[] objectArray = new String[]{"event=" + cpuEvent, "interval=10000000", "jfr", "jfrsync=profile", "file=" + myActiveDumpPath};
                profiler.startProfiling("cpu-usage", CollectionsKt.mutableListOf((Object[])objectArray), false);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            String dumpPath = myActiveDumpPath != null ? myActiveDumpPath : profiler.getSnapshotPath();
            myActiveDumpPath = null;
            String string = PerformanceTestingBundle.message((String)"profiling.compress.snapshot.progress", (Object[])new Object[0]);
            new Task.Backgroundable(project, profiler, dumpPath, string){
                final /* synthetic */ AsyncProfilerHandler $profiler;
                final /* synthetic */ String $dumpPath;
                {
                    this.$profiler = $profiler;
                    this.$dumpPath = $dumpPath;
                    super($project, $super_call_param$1, true);
                }

                public void run(ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    try {
                        Object[] objectArray = new String[]{"jfr"};
                        this.$profiler.stopProfiling(CollectionsKt.mutableListOf((Object[])objectArray));
                        String string = this.$dumpPath;
                        Intrinsics.checkNotNull((Object)string);
                        File snapshot = this.$profiler.compressResults(string, Profiler.Companion.formatSnapshotName(false));
                        if (snapshot != null) {
                            ProfilerHandlerUtils.notify((Project)this.myProject, (File)snapshot);
                        }
                    }
                    catch (ProcessCanceledException pce) {
                        throw pce;
                    }
                    catch (Exception ex) {
                        ProfilerHandlerUtils.notifyCapturingError((Throwable)ex, (Project)this.myProject);
                    }
                }
            }.queue();
        }
    }

    public final boolean isRunning$intellij_performanceTesting_async_core() {
        return StartStopAsyncProfilerAction.isRunning("cpu-usage");
    }
}

