/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.network.quic;

import com.intellij.platform.split.connection.network.quic.QuicheSockAddrIn;
import com.intellij.platform.split.connection.network.quic.QuicheSockAddrIn6;
import com.intellij.platform.split.connection.network.quic.SockAddrI;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u0004"}, d2={"getQuicheSockAddr", "Lcom/intellij/platform/split/connection/network/quic/SockAddrI;", "address", "Ljava/net/InetSocketAddress;", "intellij.platform.split.connection"})
public final class QuicheSockAddrKt {
    @NotNull
    public static final SockAddrI getQuicheSockAddr(@NotNull InetSocketAddress address) {
        SockAddrI sockAddrI;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        InetAddress inetAddress = address.getAddress();
        if (inetAddress instanceof Inet4Address) {
            sockAddrI = new QuicheSockAddrIn((Inet4Address)inetAddress, address.getPort());
        } else if (inetAddress instanceof Inet6Address) {
            sockAddrI = new QuicheSockAddrIn6((Inet6Address)inetAddress, address.getPort());
        } else {
            throw new IllegalStateException("Unsupported address type".toString());
        }
        return sockAddrI;
    }
}

