/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.transport;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.protocol.ConnectionState;
import com.intellij.platform.split.connection.protocol.ConnectionStateProperty;
import com.intellij.platform.split.connection.protocol.channel.TlsByteChannel;
import com.intellij.platform.split.connection.protocol.channel.certificate.RemoteTrustManager;
import com.intellij.platform.split.connection.protocol.transport.ByteChannelUtil;
import com.intellij.platform.split.connection.protocol.transport.StreamTransport;
import com.intellij.platform.split.connection.protocol.transport.TlsStreamTransportKt;
import com.intellij.platform.split.connection.protocol.transport.tls.TlsData;
import com.jetbrains.rd.util.Maybe;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IPropertyView;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.SourceExKt;
import java.nio.channels.ByteChannel;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020%H\u0002J\u000e\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0002J\b\u0010*\u001a\u00020\u0019H\u0002R\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006+"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/TlsStreamTransport;", "Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "id", "", "underlyingTransport", "tlsData", "Lcom/intellij/platform/split/connection/protocol/transport/tls/TlsData;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljava/lang/String;Lcom/intellij/platform/split/connection/protocol/transport/StreamTransport;Lcom/intellij/platform/split/connection/protocol/transport/tls/TlsData;)V", "getTlsData", "()Lcom/intellij/platform/split/connection/protocol/transport/tls/TlsData;", "name", "getName", "()Ljava/lang/String;", "myConnectionState", "Lcom/intellij/platform/split/connection/protocol/ConnectionStateProperty;", "myChannel", "Lcom/intellij/platform/split/connection/protocol/channel/TlsByteChannel;", "trustManager", "Lcom/intellij/platform/split/connection/protocol/channel/certificate/RemoteTrustManager;", "getTrustManager", "()Lcom/intellij/platform/split/connection/protocol/channel/certificate/RemoteTrustManager;", "isTrusted", "", "()Z", "byteChannel", "Ljava/nio/channels/ByteChannel;", "getByteChannel", "()Ljava/nio/channels/ByteChannel;", "connected", "Lcom/jetbrains/rd/util/reactive/IPropertyView;", "Lcom/intellij/platform/split/connection/protocol/ConnectionState;", "getConnected", "()Lcom/jetbrains/rd/util/reactive/IPropertyView;", "connect", "", "handshake", "getCertificates", "", "Ljava/security/cert/X509Certificate;", "checkTransportTrusted", "intellij.platform.split.connection"})
@SourceDebugExtension(value={"SMAP\nTlsStreamTransport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TlsStreamTransport.kt\ncom/intellij/platform/split/connection/protocol/transport/TlsStreamTransport\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ConnectionStateProperty.kt\ncom/intellij/platform/split/connection/protocol/ConnectionStateProperty\n*L\n1#1,154:1\n67#2,4:155\n67#2,4:159\n67#2,4:163\n51#3,4:167\n*S KotlinDebug\n*F\n+ 1 TlsStreamTransport.kt\ncom/intellij/platform/split/connection/protocol/transport/TlsStreamTransport\n*L\n133#1:155,4\n136#1:159,4\n143#1:163,4\n67#1:167,4\n*E\n"})
public final class TlsStreamTransport
implements StreamTransport {
    @NotNull
    private final StreamTransport underlyingTransport;
    @NotNull
    private final TlsData tlsData;
    @NotNull
    private final String name;
    @NotNull
    private final ConnectionStateProperty myConnectionState;
    @NotNull
    private final TlsByteChannel myChannel;

    public TlsStreamTransport(@NotNull Lifetime lifetime, @NotNull String id, @NotNull StreamTransport underlyingTransport, @NotNull TlsData tlsData) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)underlyingTransport, (String)"underlyingTransport");
        Intrinsics.checkNotNullParameter((Object)tlsData, (String)"tlsData");
        this.underlyingTransport = underlyingTransport;
        this.tlsData = tlsData;
        this.name = "TLS Transport (id: " + id + ")";
        this.myConnectionState = new ConnectionStateProperty();
        this.myChannel = new TlsByteChannel(id, this.underlyingTransport.getByteChannel(), this.tlsData);
        SourceExKt.adviseWithPrev((ISource)((ISource)this.myConnectionState), (Lifetime)lifetime, (arg_0, arg_1) -> TlsStreamTransport._init_$lambda$0(this, arg_0, arg_1));
        this.myConnectionState.advise(lifetime, (Function1<? super ConnectionState, Unit>)((Function1)arg_0 -> TlsStreamTransport._init_$lambda$1(this, arg_0)));
        lifetime.onTerminationIfAlive(() -> TlsStreamTransport._init_$lambda$2(this));
        this.underlyingTransport.getConnected().advise(lifetime, arg_0 -> TlsStreamTransport._init_$lambda$3(this, arg_0));
    }

    @NotNull
    public final TlsData getTlsData() {
        return this.tlsData;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public final RemoteTrustManager getTrustManager() {
        return this.tlsData.getTrustManager();
    }

    public final boolean isTrusted() {
        return this.myChannel.isTrusted();
    }

    @Override
    @NotNull
    public ByteChannel getByteChannel() {
        return this.myChannel;
    }

    @Override
    @NotNull
    public IPropertyView<ConnectionState> getConnected() {
        return (IPropertyView)this.myConnectionState;
    }

    public final void connect() {
        if (!ConnectionState.Companion.isConnected((ConnectionState)this.underlyingTransport.getConnected().getValue())) {
            this.myConnectionState.setIfNotTerminal(new ConnectionState.FAULTED(new IllegalStateException(this.getName() + " Inner channel must have connected state to perform TLS connection")));
            return;
        }
        if (!this.underlyingTransport.getByteChannel().isOpen()) {
            this.myConnectionState.setIfNotTerminal(new ConnectionState.FAULTED(new IllegalStateException(this.getName() + " Unable to connect using closed underlying channel")));
            return;
        }
        if (!ConnectionState.Companion.isAlive((ConnectionState)this.underlyingTransport.getConnected().getValue())) {
            this.myConnectionState.setIfNotTerminal(new ConnectionState.FAULTED(new IllegalStateException(this.getName() + " Unable to perform TLS transport connection because inner transport is not connected")));
            return;
        }
        try {
            this.handshake();
        }
        catch (Throwable t) {
            this.myConnectionState.setIfNotTerminal(new ConnectionState.FAULTED(new IllegalStateException(this.getName() + " Exception on TLS handshake: " + t.getMessage(), t)));
            return;
        }
        if (!this.isTrusted()) {
            this.myConnectionState.setIfNotTerminal(new ConnectionState.FAULTED(new IllegalStateException(this.getName() + " TLS transport did not reach the trust state")));
        }
    }

    private final void handshake() {
        Logger logger;
        TlsStreamTransportKt.access$getLogger$p().info(this.getName() + " Start TLS handshake");
        this.myChannel.handshake();
        boolean isTrusted = this.checkTransportTrusted();
        if (!isTrusted) {
            TlsStreamTransportKt.access$getLogger$p().info(this.getName() + " TLS transport did not reach a trusted state. Set FAILED status");
            this.myConnectionState.setIfNotTerminal(new ConnectionState.FAULTED(new IllegalStateException("Transport is not trusted. Remote certificates are not received")));
            return;
        }
        Logger $this$trace$iv = TlsStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Get counterpart certificates");
        }
        List<X509Certificate> counterpartCertificates = this.getCertificates();
        Logger $this$trace$iv2 = TlsStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace2 = false;
        if ($this$trace$iv2.isTraceEnabled()) {
            logger = $this$trace$iv2;
            boolean bl = false;
            logger.trace(this.getName() + " Received counterpart certificates size: " + counterpartCertificates.size());
        }
        this.tlsData.getCounterpartCertificates().set(counterpartCertificates);
        this.myConnectionState.setIfNotTerminal(ConnectionState.CONNECTED.INSTANCE);
    }

    private final List<X509Certificate> getCertificates() {
        Logger $this$trace$iv = TlsStreamTransportKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace(this.getName() + " Start getting counterpart certificates");
        }
        return this.myChannel.getCertificates();
    }

    private final boolean checkTransportTrusted() {
        List<X509Certificate> certificates = this.myChannel.getCertificates();
        return !((Collection)certificates).isEmpty();
    }

    private static final Unit _init_$lambda$0(TlsStreamTransport this$0, Maybe previous, ConnectionState current) {
        Intrinsics.checkNotNullParameter((Object)previous, (String)"previous");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        TlsStreamTransportKt.access$getLogger$p().info(this$0.connectionStateChangedToString((ConnectionState)previous.getAsNullable(), current));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(TlsStreamTransport this$0, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ByteChannelUtil.INSTANCE.checkState(this$0.myChannel, this$0.getName(), state);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(TlsStreamTransport this$0) {
        this$0.myConnectionState.setIfNotTerminal(ConnectionState.CLOSED.INSTANCE);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit _init_$lambda$3(TlsStreamTransport this$0, ConnectionState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (!ConnectionState.Companion.isAlive(state)) {
            void this_$iv;
            ConnectionStateProperty connectionStateProperty = this$0.myConnectionState;
            ConnectionState newValue$iv = state;
            boolean $i$f$setIfNotTerminalAndRun = false;
            if (this_$iv.setIfNotTerminal(newValue$iv)) {
                boolean bl = false;
                TlsStreamTransportKt.access$getLogger$p().info(this$0.getName() + " went to a terminal state '" + state + "' due to inner channel state change");
            }
        }
        return Unit.INSTANCE;
    }
}

