/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.split.connection.protocol.transport.stats;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.split.connection.protocol.transport.stats.TransportStatisticsDataKt;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001e\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/split/connection/protocol/transport/stats/TransportStatisticsData;", "", "<init>", "()V", "totalSend", "Ljava/util/concurrent/atomic/AtomicLong;", "totalReceive", "getTotalSend", "", "getTotalReceive", "value", "sendSpeed", "getSendSpeed", "()J", "receiveSpeed", "getReceiveSpeed", "lastSend", "lastReceive", "lastUpdate", "updateSpeeds", "", "logSend", "bytes", "logReceive", "intellij.platform.split.connection"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTransportStatisticsData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransportStatisticsData.kt\ncom/intellij/platform/split/connection/protocol/transport/stats/TransportStatisticsData\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n67#2,4:56\n*S KotlinDebug\n*F\n+ 1 TransportStatisticsData.kt\ncom/intellij/platform/split/connection/protocol/transport/stats/TransportStatisticsData\n*L\n30#1:56,4\n*E\n"})
public final class TransportStatisticsData {
    @NotNull
    private final AtomicLong totalSend = new AtomicLong(0L);
    @NotNull
    private final AtomicLong totalReceive = new AtomicLong(0L);
    private long sendSpeed;
    private long receiveSpeed;
    private long lastSend;
    private long lastReceive;
    private long lastUpdate = System.nanoTime();

    public final long getTotalSend() {
        return this.totalSend.get();
    }

    public final long getTotalReceive() {
        return this.totalReceive.get();
    }

    public final long getSendSpeed() {
        return this.sendSpeed;
    }

    public final long getReceiveSpeed() {
        return this.receiveSpeed;
    }

    public final void updateSpeeds() {
        Logger $this$trace$iv = TransportStatisticsDataKt.access$getLogger$p();
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Update wire speed statistics");
        }
        long currentUpdate = System.nanoTime();
        long spanMs = (currentUpdate - this.lastUpdate) / (long)1000000;
        if (spanMs <= 0L) {
            spanMs = 1L;
        }
        this.lastUpdate = currentUpdate;
        long currentSend = this.totalSend.get();
        this.sendSpeed = (currentSend - this.lastSend) * (long)1000 / spanMs;
        this.lastSend = currentSend;
        long currentReceive = this.totalReceive.get();
        this.receiveSpeed = (currentReceive - this.lastReceive) * (long)1000 / spanMs;
        this.lastReceive = currentReceive;
    }

    public final void logSend(long bytes) {
        this.totalSend.addAndGet(bytes);
    }

    public final void logReceive(long bytes) {
        if (bytes <= 0L) {
            return;
        }
        this.totalReceive.addAndGet(bytes);
    }
}

