/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler;

import com.intellij.openapi.util.Clock;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.profiler.CommonProfilerUiOptions;
import com.intellij.profiler.ProfilerProcessPanel;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.ui.content.Content;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.Calendar;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bH\u0003\u001a\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010\u00a8\u0006\u0011"}, d2={"formatTabName", "", "format", "Lcom/intellij/profiler/CommonProfilerUiOptions$TabNameFormat;", "defaultName", "time", "", "existingNames", "", "isToday", "", "findToolWindowContent", "Lcom/intellij/ui/content/Content;", "tw", "Lcom/intellij/openapi/wm/ToolWindow;", "profilerProcess", "Lcom/intellij/profiler/api/ProfilerProcess;", "intellij.profiler.common"})
public final class ProfilerToolWindowManagerKt {
    @NlsSafe
    private static final String formatTabName(CommonProfilerUiOptions.TabNameFormat format, String defaultName, long time, Collection<String> existingNames) {
        String tabName = switch (WhenMappings.$EnumSwitchMapping$0[format.ordinal()]) {
            case 1 -> defaultName;
            case 2 -> {
                String var6_4 = time > 0L ? DateFormatUtil.formatDateTime((long)time) : defaultName;
                Intrinsics.checkNotNull((Object)var6_4);
                yield var6_4;
            }
            case 3 -> {
                String var6_4 = time > 0L ? (ProfilerToolWindowManagerKt.isToday(time) ? DateFormatUtil.formatTime((long)time) : DateFormatUtil.formatDateTime((long)time)) : defaultName;
                Intrinsics.checkNotNull((Object)var6_4);
                yield var6_4;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        String string = UniqueNameGenerator.generateUniqueName((String)tabName, (String)"", (String)"", (String)" (", (String)")", arg_0 -> ProfilerToolWindowManagerKt.formatTabName$lambda$1(arg_0 -> ProfilerToolWindowManagerKt.formatTabName$lambda$0(existingNames, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
        return string;
    }

    static /* synthetic */ String formatTabName$default(CommonProfilerUiOptions.TabNameFormat tabNameFormat, String string, long l, Collection collection, int n, Object object) {
        if ((n & 8) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return ProfilerToolWindowManagerKt.formatTabName(tabNameFormat, string, l, collection);
    }

    private static final boolean isToday(long time) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(Clock.getTime());
        Pair pair = TuplesKt.to((Object)c.get(1), (Object)c.get(6));
        int currentYear = ((Number)pair.component1()).intValue();
        int currentDayOfYear = ((Number)pair.component2()).intValue();
        c.setTimeInMillis(time);
        Pair pair2 = TuplesKt.to((Object)c.get(1), (Object)c.get(6));
        int year = ((Number)pair2.component1()).intValue();
        int dayOfYear = ((Number)pair2.component2()).intValue();
        return currentYear == year && currentDayOfYear == dayOfYear;
    }

    @Nullable
    public static final Content findToolWindowContent(@NotNull ToolWindow tw, @NotNull ProfilerProcess<?> profilerProcess) {
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)tw, (String)"tw");
            Intrinsics.checkNotNullParameter(profilerProcess, (String)"profilerProcess");
            Content[] contentArray = tw.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                JComponent comp;
                Content it = (Content)object2;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it.getComponent(), (String)"getComponent(...)");
                if (!(comp instanceof ProfilerProcessPanel && Intrinsics.areEqual(((ProfilerProcessPanel)((Object)comp)).getProfilerProcess(), profilerProcess))) continue;
                object = object2;
                break block1;
            }
            object = null;
        }
        return (Content)object;
    }

    private static final boolean formatTabName$lambda$0(Collection $existingNames, String it) {
        return !$existingNames.contains(it);
    }

    private static final boolean formatTabName$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ String access$formatTabName(CommonProfilerUiOptions.TabNameFormat format, String defaultName, long time, Collection existingNames) {
        return ProfilerToolWindowManagerKt.formatTabName(format, defaultName, time, existingNames);
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommonProfilerUiOptions.TabNameFormat.values().length];
            try {
                nArray[CommonProfilerUiOptions.TabNameFormat.DEFAULT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommonProfilerUiOptions.TabNameFormat.ABSOLUTE_TIME.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommonProfilerUiOptions.TabNameFormat.SHORT_TIME.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

