/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.profiler.WithUserFriendlyMessage;
import com.intellij.profiler.api.AttachableTargetProcess;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0083\u0004J\n\u0010\u0014\u001a\u00020\u0015H\u00d6\u0081\u0004J\n\u0010\u0016\u001a\u00020\u000bH\u00d6\u0081\u0004R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/profiler/api/ProfilerAlreadyStartedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lcom/intellij/profiler/WithUserFriendlyMessage;", "targetProcess", "Lcom/intellij/profiler/api/AttachableTargetProcess;", "<init>", "(Lcom/intellij/profiler/api/AttachableTargetProcess;)V", "getTargetProcess", "()Lcom/intellij/profiler/api/AttachableTargetProcess;", "userFriendlyMessage", "", "getUserFriendlyMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.profiler.common"})
public final class ProfilerAlreadyStartedException
extends Exception
implements WithUserFriendlyMessage {
    @NotNull
    private final AttachableTargetProcess targetProcess;
    @NotNull
    private final String userFriendlyMessage;

    public ProfilerAlreadyStartedException(@NotNull AttachableTargetProcess targetProcess) {
        Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
        this.targetProcess = targetProcess;
        this.userFriendlyMessage = "Profiler for process '" + this.targetProcess.getFullName() + "' with pid " + this.targetProcess.getPid() + " is already started";
    }

    @NotNull
    public final AttachableTargetProcess getTargetProcess() {
        return this.targetProcess;
    }

    @Override
    @NotNull
    public String getUserFriendlyMessage() {
        return this.userFriendlyMessage;
    }

    @NotNull
    public final AttachableTargetProcess component1() {
        return this.targetProcess;
    }

    @NotNull
    public final ProfilerAlreadyStartedException copy(@NotNull AttachableTargetProcess targetProcess) {
        Intrinsics.checkNotNullParameter((Object)targetProcess, (String)"targetProcess");
        return new ProfilerAlreadyStartedException(targetProcess);
    }

    public static /* synthetic */ ProfilerAlreadyStartedException copy$default(ProfilerAlreadyStartedException profilerAlreadyStartedException, AttachableTargetProcess attachableTargetProcess, int n, Object object) {
        if ((n & 1) != 0) {
            attachableTargetProcess = profilerAlreadyStartedException.targetProcess;
        }
        return profilerAlreadyStartedException.copy(attachableTargetProcess);
    }

    @Override
    @NotNull
    public String toString() {
        return "ProfilerAlreadyStartedException(targetProcess=" + this.targetProcess + ")";
    }

    public int hashCode() {
        return this.targetProcess.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ProfilerAlreadyStartedException)) {
            return false;
        }
        ProfilerAlreadyStartedException profilerAlreadyStartedException = (ProfilerAlreadyStartedException)other;
        return Intrinsics.areEqual((Object)this.targetProcess, (Object)profilerAlreadyStartedException.targetProcess);
    }
}

