/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api.configurations;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\f\b \u0018\u00002\u00060\u0001j\u0002`\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0015\u0010\u000f\u001a\u00020\u00048FX\u0086\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0012"}, d2={"Lcom/intellij/profiler/api/configurations/MigrationFailedException;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "migratorName", "", "skippedMigratorNames", "", "<init>", "(Ljava/lang/String;Ljava/util/List;)V", "getMigratorName", "()Ljava/lang/String;", "getSkippedMigratorNames", "()Ljava/util/List;", "description", "getDescription", "message", "getMessage", "createMessage", "intellij.profiler.common"})
public abstract class MigrationFailedException
extends Exception {
    @NotNull
    private final String migratorName;
    @NotNull
    private final List<String> skippedMigratorNames;

    public MigrationFailedException(@NotNull String migratorName, @NotNull List<String> skippedMigratorNames) {
        Intrinsics.checkNotNullParameter((Object)migratorName, (String)"migratorName");
        Intrinsics.checkNotNullParameter(skippedMigratorNames, (String)"skippedMigratorNames");
        this.migratorName = migratorName;
        this.skippedMigratorNames = skippedMigratorNames;
    }

    @NotNull
    public final String getMigratorName() {
        return this.migratorName;
    }

    @NotNull
    public final List<String> getSkippedMigratorNames() {
        return this.skippedMigratorNames;
    }

    @NotNull
    public abstract String getDescription();

    @Override
    @NotNull
    public final String getMessage() {
        return this.createMessage();
    }

    private final String createMessage() {
        String header = StringsKt.trimIndent((String)("\n      Error in migrator " + this.migratorName + ":\n      " + this.getDescription() + "\n      Nothing will be changed.\n    "));
        Object chainedMigratorsSkippedNote = !((Collection)this.skippedMigratorNames).isEmpty() ? "Other consecutive migrators with the same language group were skipped: " + CollectionsKt.joinToString$default((Iterable)this.skippedMigratorNames, null, null, null, (int)0, null, null, (int)63, null) : null;
        String string = chainedMigratorsSkippedNote;
        if (string == null) {
            string = "";
        }
        return ((Object)StringsKt.trimEnd((CharSequence)StringsKt.trimIndent((String)("\n      " + header + "\n      " + string + "\n    ")))).toString();
    }
}

