/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.profiler.ui.LazyPanel;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.ui.AncestorListenerAdapter;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.DottedBorder;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.panels.OpaquePanel;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Y\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\"\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\u00020\u0004BM\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u0012\b\b\u0002\u0010\f\u001a\u00020\n\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\b\u0010&\u001a\u00020'H\u0002J\u0010\u0010(\u001a\u00020\n2\b\b\u0002\u0010)\u001a\u00020\nJ\b\u0010*\u001a\u00020\u001bH\u0002J\u0012\u0010+\u001a\u00020\n2\b\b\u0002\u0010)\u001a\u00020\nH\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010.\u001a\u00020'2\u0006\u0010/\u001a\u00020\nH\u0016J\u0006\u00100\u001a\u00020'J\b\u00101\u001a\u00020'H\u0016R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0016R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0016R\u0011\u0010\f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0016R\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00028\u00000\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001d\u001a\u0004\u0018\u00018\u00002\b\u0010\u001c\u001a\u0004\u0018\u00018\u0000@BX\u0082\u000e\u00a2\u0006\n\n\u0002\u0010 \"\u0004\b\u001e\u0010\u001fR\u0010\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010#R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/profiler/ui/LazyPanel;", "T", "Ljavax/swing/JComponent;", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "text", "", "isCancellable", "", "isAutoloadEnable", "isRegisterDisposable", "loader", "Lkotlin/Function1;", "Lcom/intellij/openapi/progress/ProgressIndicator;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;ZZZLkotlin/jvm/functions/Function1;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getText", "()Ljava/lang/String;", "()Z", "getLoader", "()Lkotlin/jvm/functions/Function1;", "loaded", "link", "Lcom/intellij/ui/HyperlinkLabel;", "value", "component", "setComponent", "(Ljavax/swing/JComponent;)V", "Ljavax/swing/JComponent;", "ancestorListener", "com/intellij/profiler/ui/LazyPanel$ancestorListener$1", "Lcom/intellij/profiler/ui/LazyPanel$ancestorListener$1;", "running", "Ljava/util/concurrent/CopyOnWriteArrayList;", "loadLaterIfNeeded", "", "loadLater", "focusAfter", "createHyperLink", "runLoader", "wrapLink", "Lcom/intellij/ui/components/panels/OpaquePanel;", "setEnabled", "enabled", "clear", "dispose", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nLazyPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyPanel.kt\ncom/intellij/profiler/ui/LazyPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1915#2,2:191\n1915#2,2:193\n*S KotlinDebug\n*F\n+ 1 LazyPanel.kt\ncom/intellij/profiler/ui/LazyPanel\n*L\n51#1:191,2\n178#1:193,2\n*E\n"})
public class LazyPanel<T extends JComponent>
extends BorderLayoutPanel
implements Disposable {
    @Nullable
    private final Project project;
    @NotNull
    private final String text;
    private final boolean isCancellable;
    private final boolean isAutoloadEnable;
    private final boolean isRegisterDisposable;
    @NotNull
    private final Function1<ProgressIndicator, T> loader;
    private boolean loaded;
    @NotNull
    private final HyperlinkLabel link;
    @Nullable
    private T component;
    @NotNull
    private final ancestorListener.1 ancestorListener;
    @NotNull
    private final CopyOnWriteArrayList<ProgressIndicator> running;

    public LazyPanel(@Nullable Project project, @Nls @NotNull String text, boolean isCancellable, boolean isAutoloadEnable, boolean isRegisterDisposable, @NotNull Function1<? super ProgressIndicator, ? extends T> loader) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter(loader, (String)"loader");
        this.project = project;
        this.text = text;
        this.isCancellable = isCancellable;
        this.isAutoloadEnable = isAutoloadEnable;
        this.isRegisterDisposable = isRegisterDisposable;
        this.loader = loader;
        this.ancestorListener = new AncestorListenerAdapter(this){
            final /* synthetic */ LazyPanel<T> this$0;
            {
                this.this$0 = $receiver;
            }

            public void ancestorAdded(AncestorEvent event) {
                LazyPanel.access$runLoader(this.this$0, false);
                this.this$0.removeAncestorListener((AncestorListener)((Object)this));
            }
        };
        this.running = new CopyOnWriteArrayList();
        this.setBackground(ProfilerUIUtilsKt.BACKGROUND);
        this.link = this.createHyperLink();
        this.addToCenter((Component)this.wrapLink(this.link));
        if (this.isAutoloadEnable) {
            this.loadLaterIfNeeded();
        }
    }

    public /* synthetic */ LazyPanel(Project project, String string, boolean bl, boolean bl2, boolean bl3, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = true;
        }
        this(project, string, bl, bl2, bl3, function1);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final boolean isCancellable() {
        return this.isCancellable;
    }

    public final boolean isAutoloadEnable() {
        return this.isAutoloadEnable;
    }

    public final boolean isRegisterDisposable() {
        return this.isRegisterDisposable;
    }

    @NotNull
    public final Function1<ProgressIndicator, T> getLoader() {
        return this.loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setComponent(T value) {
        try {
            T old = this.component;
            if (this.isRegisterDisposable && old != value && old instanceof Disposable) {
                Iterable $this$forEach$iv = this.running;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ProgressIndicator p0 = (ProgressIndicator)element$iv;
                    boolean bl = false;
                    p0.cancel();
                }
                Disposer.dispose((Disposable)((Disposable)old));
            }
        }
        finally {
            this.component = value;
        }
    }

    private final void loadLaterIfNeeded() {
        EDT.assertIsEdt();
        if (this.getParent() != null) {
            this.runLoader(false);
        } else {
            AncestorListener[] ancestorListenerArray = this.getAncestorListeners();
            Intrinsics.checkNotNullExpressionValue((Object)ancestorListenerArray, (String)"getAncestorListeners(...)");
            if (!ArraysKt.contains((Object[])ancestorListenerArray, (Object)((Object)this.ancestorListener))) {
                this.addAncestorListener((AncestorListener)((Object)this.ancestorListener));
            }
        }
    }

    public final boolean loadLater(boolean focusAfter) {
        boolean bl;
        if (this.getParent() != null) {
            bl = this.runLoader(focusAfter);
        } else {
            this.loadLaterIfNeeded();
            bl = true;
        }
        return bl;
    }

    public static /* synthetic */ boolean loadLater$default(LazyPanel lazyPanel, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: loadLater");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return lazyPanel.loadLater(bl);
    }

    private final HyperlinkLabel createHyperLink() {
        HyperlinkLabel hyperlinkLabel;
        HyperlinkLabel $this$createHyperLink_u24lambda_u240 = hyperlinkLabel = new HyperlinkLabel(this.text);
        boolean bl = false;
        $this$createHyperLink_u24lambda_u240.setIcon(EmptyIcon.ICON_16);
        $this$createHyperLink_u24lambda_u240.setFocusable(true);
        $this$createHyperLink_u24lambda_u240.addFocusListener((FocusListener)new FocusAdapter($this$createHyperLink_u24lambda_u240){
            final /* synthetic */ HyperlinkLabel $this_apply;
            {
                this.$this_apply = $this_apply;
            }

            public void focusLost(FocusEvent e) {
                this.$this_apply.setBorder(null);
            }

            public void focusGained(FocusEvent e) {
                this.$this_apply.setBorder((Border)new DottedBorder((Color)JBColor.BLACK));
            }
        });
        $this$createHyperLink_u24lambda_u240.addKeyListener((KeyListener)new KeyAdapter($this$createHyperLink_u24lambda_u240){
            final /* synthetic */ HyperlinkLabel $this_apply;
            {
                this.$this_apply = $this_apply;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 10 && this.$this_apply.hasFocus()) {
                    this.$this_apply.doClick();
                }
            }
        });
        $this$createHyperLink_u24lambda_u240.addHyperlinkListener(arg_0 -> LazyPanel.createHyperLink$lambda$0$0(this, arg_0));
        return hyperlinkLabel;
    }

    private final boolean runLoader(boolean focusAfter) {
        if (!this.isEnabled()) {
            return false;
        }
        Project project = this.project;
        String string = this.text;
        boolean bl = this.isCancellable;
        new Task.Backgroundable(this, focusAfter, project, string, bl){
            final /* synthetic */ LazyPanel<T> this$0;
            final /* synthetic */ boolean $focusAfter;
            {
                this.this$0 = $receiver;
                this.$focusAfter = $focusAfter;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run(ProgressIndicator indicator) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                boolean wasEnabled = this.this$0.isEnabled();
                this.this$0.setEnabled(false);
                LazyPanel.access$getLink$p(this.this$0).setIcon((Icon)new AnimatedIcon.Default());
                try {
                    LazyPanel.access$getRunning$p(this.this$0).add(indicator);
                    object = this.this$0.getLoader().invoke((Object)indicator);
                    LazyPanel<T> lazyPanel = this.this$0;
                    JComponent it = (JComponent)object;
                    boolean bl = false;
                    if (Disposer.isDisposed((Disposable)lazyPanel)) {
                        throw new ProcessCanceledException();
                    }
                    if (lazyPanel.isRegisterDisposable() && it instanceof Disposable) {
                        Disposer.register((Disposable)lazyPanel, (Disposable)((Disposable)it));
                    }
                    object = (JComponent)object;
                }
                catch (ProcessCanceledException e) {
                    this.this$0.setEnabled(wasEnabled);
                    return;
                }
                finally {
                    LazyPanel.access$getRunning$p(this.this$0).remove(indicator);
                    LazyPanel.access$setLoaded$p(this.this$0, true);
                    LazyPanel.access$getLink$p(this.this$0).setIcon(EmptyIcon.ICON_16);
                }
                Object component = object;
                UIUtil.invokeLaterIfNeeded(() -> runLoader.1.run$lambda$1(this.this$0, (JComponent)component, this.$focusAfter));
            }

            private static final void run$lambda$1(LazyPanel this$0, JComponent $component, boolean $focusAfter) {
                boolean bl;
                boolean bl2 = bl = this$0.getComponentCount() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                this$0.setEnabled(true);
                this$0.removeAll();
                this$0.addToCenter($component);
                if ($focusAfter) {
                    Container container = this$0.getParent();
                    if (container != null) {
                        Container it = container;
                        boolean bl3 = false;
                        IdeFocusManager.findInstance().requestFocus((Component)it, true);
                    }
                }
                LazyPanel.access$setComponent(this$0, $component);
            }
        }.queue();
        return true;
    }

    static /* synthetic */ boolean runLoader$default(LazyPanel lazyPanel, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runLoader");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return lazyPanel.runLoader(bl);
    }

    private final OpaquePanel wrapLink(HyperlinkLabel link) {
        OpaquePanel opaquePanel;
        OpaquePanel $this$wrapLink_u24lambda_u240 = opaquePanel = new OpaquePanel((LayoutManager)new GridBagLayout());
        boolean bl = false;
        $this$wrapLink_u24lambda_u240.add((Component)link);
        return opaquePanel;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.link.setEnabled(enabled);
        if (enabled) {
            this.link.setIcon(EmptyIcon.ICON_16);
        }
    }

    public final void clear() {
        Iterable $this$forEach$iv = this.running;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProgressIndicator p0 = (ProgressIndicator)element$iv;
            boolean bl = false;
            p0.cancel();
        }
        this.removeAll();
        this.addToCenter((Component)this.wrapLink(this.link));
        this.revalidate();
        this.repaint();
        this.setComponent(null);
    }

    public void dispose() {
        this.clear();
    }

    private static final void createHyperLink$lambda$0$0(LazyPanel this$0, HyperlinkEvent it) {
        LazyPanel.runLoader$default(this$0, false, 1, null);
    }

    public static final /* synthetic */ HyperlinkLabel access$getLink$p(LazyPanel $this) {
        return $this.link;
    }

    public static final /* synthetic */ CopyOnWriteArrayList access$getRunning$p(LazyPanel $this) {
        return $this.running;
    }

    public static final /* synthetic */ void access$setLoaded$p(LazyPanel $this, boolean bl) {
        $this.loaded = bl;
    }

    public static final /* synthetic */ void access$setComponent(LazyPanel $this, JComponent value) {
        $this.setComponent(value);
    }

    public static final /* synthetic */ boolean access$runLoader(LazyPanel $this, boolean focusAfter) {
        return $this.runLoader(focusAfter);
    }
}

