/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.profiler.ui.flamegraph.ViewScroller;
import com.intellij.ui.ComponentUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J3\u0010\n\u001a\u00020\u000b\"\b\b\u0000\u0010\f*\u00020\r2\u0006\u0010\u000e\u001a\u0002H\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\f\u0012\u0004\u0012\u00020\u000b0\u0003H\u0016\u00a2\u0006\u0002\u0010\u0010R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ui/flamegraph/AnchorViewScroller;", "Lcom/intellij/profiler/ui/flamegraph/ViewScroller;", "transform", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "Ljava/awt/Point;", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "getTransform", "()Lkotlin/jvm/functions/Function1;", "scroll", "", "T", "Ljava/awt/Component;", "panel", "componentResizing", "(Ljava/awt/Component;Lkotlin/jvm/functions/Function1;)V", "intellij.profiler.common"})
public final class AnchorViewScroller
implements ViewScroller {
    @NotNull
    private final Function1<Rectangle, Point> transform;

    public AnchorViewScroller(@NotNull Function1<? super Rectangle, ? extends Point> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        this.transform = transform;
    }

    @NotNull
    public final Function1<Rectangle, Point> getTransform() {
        return this.transform;
    }

    @Override
    public <T extends Component> void scroll(@NotNull T panel2, @NotNull Function1<? super T, Unit> componentResizing) {
        Intrinsics.checkNotNullParameter(panel2, (String)"panel");
        Intrinsics.checkNotNullParameter(componentResizing, (String)"componentResizing");
        JViewport jViewport = ComponentUtil.getViewport(panel2);
        if (jViewport != null) {
            JViewport it = jViewport;
            boolean bl = false;
            Rectangle view = it.getViewRect();
            Intrinsics.checkNotNull((Object)view);
            Point anchor = (Point)this.transform.invoke((Object)view);
            int dx = anchor.x - view.x;
            int dy = anchor.y - view.y;
            double ratioX = (double)anchor.x / (double)panel2.getWidth();
            double ratioY = (double)anchor.y / (double)panel2.getHeight();
            componentResizing.invoke(panel2);
            if (Math.abs(ratioX) <= Double.MAX_VALUE && Math.abs(ratioY) <= Double.MAX_VALUE) {
                it.setViewPosition(new Point(MathKt.roundToInt((double)((double)panel2.getWidth() * ratioX)) - dx, MathKt.roundToInt((double)((double)panel2.getHeight() * ratioY)) - dy));
            }
        } else {
            componentResizing.invoke(panel2);
        }
    }
}

