/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.threadview;

import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ui.threadview.PersistentMetric;
import com.intellij.profiler.ui.threadview.ThreadMetric;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0002H\u0016R\u001b\u0010\u0006\u001a\u00070\u0002\u00a2\u0006\u0002\b\u00078\u0016X\u0097\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u000bj\b\u0012\u0004\u0012\u00020\u0002`\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0002X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\tR\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lcom/intellij/profiler/ui/threadview/ThreadIdMetric;", "Lcom/intellij/profiler/ui/threadview/ThreadMetric;", "", "Lcom/intellij/profiler/ui/threadview/PersistentMetric;", "<init>", "()V", "name", "Lorg/jetbrains/annotations/Nls;", "getName", "()Ljava/lang/String;", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "getComparator", "()Ljava/util/Comparator;", "persistentName", "getPersistentName", "isVisibleByDefault", "", "()Z", "represent", "value", "intellij.profiler.common"})
public final class ThreadIdMetric
extends ThreadMetric<String>
implements PersistentMetric {
    @NotNull
    public static final ThreadIdMetric INSTANCE = new ThreadIdMetric();
    @Nls
    @NotNull
    private static final String name = CommonProfilerBundleKt.profilerMessage("ui.threadlist.metrics.threadId", new Object[0]);
    @NotNull
    private static final Comparator<String> comparator;
    @NotNull
    private static final String persistentName;
    private static final boolean isVisibleByDefault;

    private ThreadIdMetric() {
    }

    @Override
    @NotNull
    public String getName() {
        return name;
    }

    @Override
    @NotNull
    public Comparator<String> getComparator() {
        return comparator;
    }

    @Override
    @NotNull
    public String getPersistentName() {
        return persistentName;
    }

    @Override
    public boolean isVisibleByDefault() {
        return isVisibleByDefault;
    }

    @Override
    @NotNull
    public String represent(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "id=" + value;
    }

    static {
        Comparator comparator = NaturalComparator.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)comparator, (String)"INSTANCE");
        ThreadIdMetric.comparator = comparator;
        persistentName = "threadIdMetric";
    }
}

