/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.collaboration.ui.codereview.comment;

import com.intellij.collaboration.ui.codereview.editor.CodeReviewEditorInlayRangeOutlineUtilsKt;
import com.intellij.collaboration.ui.util.CodeReviewColorUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.ui.scale.JBUIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Path2D;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\b\b\u0000\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\u0018*\u00020\rH\u0002J(\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019H\u0002J(\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/collaboration/ui/codereview/comment/CommentedCodeFrameRenderer;", "Lcom/intellij/openapi/editor/markup/CustomHighlighterRenderer;", "Lcom/intellij/openapi/editor/markup/LineMarkerRenderer;", "startLine", "", "endLine", "editorSide", "Lcom/intellij/diff/util/Side;", "<init>", "(IILcom/intellij/diff/util/Side;)V", "paint", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "drawOutlinePath", "path", "Ljava/awt/geom/Path2D$Float;", "getYAxisValues", "Lkotlin/Pair;", "", "createLeftOutlinePath", "x", "y", "width", "height", "createRightOutlinePath", "Companion", "intellij.platform.collaborationTools"})
public final class CommentedCodeFrameRenderer
implements CustomHighlighterRenderer,
LineMarkerRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int startLine;
    private final int endLine;
    @Nullable
    private final Side editorSide;
    private static final float OUTER_GUTTER_FRAME_PADDING = 2.0f;
    @NotNull
    private static final Color color = (Color)CodeReviewColorUtil.Review.LineFrame.INSTANCE.getBorder();
    @NotNull
    private static final Stroke stroke = new BasicStroke(JBUIScale.scale((float)1.0f));

    public CommentedCodeFrameRenderer(int startLine, int endLine, @Nullable Side editorSide) {
        this.startLine = startLine;
        this.endLine = endLine;
        this.editorSide = editorSide;
    }

    public void paint(@NotNull Editor editor, @NotNull RangeHighlighter highlighter, @NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        float x = 0.0f;
        float width = editor.getContentComponent().getWidth();
        Pair<Float, Float> pair = this.getYAxisValues(editor);
        float y = ((Number)pair.component1()).floatValue();
        float height = ((Number)pair.component2()).floatValue();
        if (this.editorSide == Side.LEFT) {
            Path2D.Float path = this.createLeftOutlinePath(x += (float)CommentedCodeFrameRenderer.Companion.getScrollbarPadding(), y, width, height);
            this.drawOutlinePath(g, path);
        } else {
            Path2D.Float path = this.createRightOutlinePath(x, y, width -= (float)CommentedCodeFrameRenderer.Companion.getScrollbarPadding(), height);
            this.drawOutlinePath(g, path);
        }
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        float x = 2.0f;
        EditorEx editorEx = editor instanceof EditorEx ? (EditorEx)editor : null;
        float width = editorEx != null && (editorEx = editorEx.getGutterComponentEx()) != null ? (float)editorEx.getWidth() : 0.0f;
        Pair<Float, Float> pair = this.getYAxisValues(editor);
        float y = ((Number)pair.component1()).floatValue();
        float height = ((Number)pair.component2()).floatValue();
        Path2D.Float path = this.createLeftOutlinePath(x, y, width, height);
        this.drawOutlinePath(g, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void drawOutlinePath(Graphics g, Path2D.Float path) {
        Graphics graphics = g.create();
        Graphics2D graphics2D = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (graphics2D == null) {
            return;
        }
        Graphics2D g2d = graphics2D;
        try {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(color);
            g2d.setStroke(stroke);
            g2d.draw(path);
        }
        finally {
            g2d.dispose();
        }
    }

    private final Pair<Float, Float> getYAxisValues(Editor $this$getYAxisValues) {
        IntRange yRange = CodeReviewEditorInlayRangeOutlineUtilsKt.yRangeForLogicalLineRange($this$getYAxisValues, this.startLine, this.endLine);
        float startY = yRange.getFirst();
        float height = (float)yRange.getLast() - startY;
        return TuplesKt.to((Object)Float.valueOf(startY), (Object)Float.valueOf(height));
    }

    private final Path2D.Float createLeftOutlinePath(float x, float y, float width, float height) {
        Path2D.Float float_;
        Path2D.Float $this$createLeftOutlinePath_u24lambda_u240 = float_ = new Path2D.Float(1);
        boolean bl = false;
        $this$createLeftOutlinePath_u24lambda_u240.moveTo(width, y);
        $this$createLeftOutlinePath_u24lambda_u240.lineTo(x + (float)CommentedCodeFrameRenderer.Companion.getRadius(), y);
        $this$createLeftOutlinePath_u24lambda_u240.quadTo(x, y, x, y + (float)CommentedCodeFrameRenderer.Companion.getRadius());
        $this$createLeftOutlinePath_u24lambda_u240.lineTo(x, y + height - (float)CommentedCodeFrameRenderer.Companion.getRadius());
        $this$createLeftOutlinePath_u24lambda_u240.quadTo(x, y + height, x + (float)CommentedCodeFrameRenderer.Companion.getRadius(), y + height);
        $this$createLeftOutlinePath_u24lambda_u240.lineTo(width, y + height);
        return float_;
    }

    private final Path2D.Float createRightOutlinePath(float x, float y, float width, float height) {
        Path2D.Float float_;
        Path2D.Float $this$createRightOutlinePath_u24lambda_u240 = float_ = new Path2D.Float(1);
        boolean bl = false;
        $this$createRightOutlinePath_u24lambda_u240.moveTo(x, y);
        $this$createRightOutlinePath_u24lambda_u240.lineTo(x + width - (float)CommentedCodeFrameRenderer.Companion.getRadius(), y);
        $this$createRightOutlinePath_u24lambda_u240.quadTo(x + width, y, x + width, y + (float)CommentedCodeFrameRenderer.Companion.getRadius());
        $this$createRightOutlinePath_u24lambda_u240.lineTo(x + width, y + height - (float)CommentedCodeFrameRenderer.Companion.getRadius());
        $this$createRightOutlinePath_u24lambda_u240.quadTo(x + width, y + height, x + width - (float)CommentedCodeFrameRenderer.Companion.getRadius(), y + height);
        $this$createRightOutlinePath_u24lambda_u240.lineTo(x, y + height);
        return float_;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0010"}, d2={"Lcom/intellij/collaboration/ui/codereview/comment/CommentedCodeFrameRenderer$Companion;", "", "<init>", "()V", "OUTER_GUTTER_FRAME_PADDING", "", "color", "Ljava/awt/Color;", "stroke", "Ljava/awt/Stroke;", "radius", "", "getRadius", "()I", "scrollbarPadding", "getScrollbarPadding", "intellij.platform.collaborationTools"})
    public static final class Companion {
        private Companion() {
        }

        private final int getRadius() {
            return JBUIScale.scale((int)4);
        }

        private final int getScrollbarPadding() {
            return JBUIScale.scale((int)15);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

