/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.actions.Db2DbmsOutputHandler;
import com.intellij.database.actions.DbmsOutputHandler;
import com.intellij.database.actions.DbmsOutputHandlerStub;
import com.intellij.database.actions.OracleDbmsOutputHandler;
import com.intellij.database.actions.util.SettingsUtilsKt;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcConsoleProvider;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.console.session.PerProjectFileAttributes;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000bH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\tH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/actions/ProcessDbmsOutputAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isSelected", "", "setSelected", "state", "getConsoleIfSupported", "Lcom/intellij/database/console/JdbcConsole;", "DBMSDataAuditor", "Companion", "intellij.database.impl"})
public final class ProcessDbmsOutputAction
extends ToggleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<DBMSDataAuditor> dbmsListener;
    @NotNull
    private static final PerProjectFileAttributes fileAttributes;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JdbcConsole console = this.getConsoleIfSupported(e);
        e.getPresentation().setEnabledAndVisible(console != null);
        e.getPresentation().setText(DatabaseBundle.message((String)"action.Console.DbmsOutput.text", (Object[])new Object[0]), false);
        if (console != null) {
            super.update(e);
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        JdbcConsole console;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JdbcConsole jdbcConsole = console = this.getConsoleIfSupported(e);
        return (jdbcConsole != null ? (DBMSDataAuditor)jdbcConsole.getUserData(dbmsListener) : null) != null;
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JdbcConsole jdbcConsole = this.getConsoleIfSupported(e);
        if (jdbcConsole == null) {
            return;
        }
        JdbcConsole console = jdbcConsole;
        Companion.updateStateFor(console, state);
    }

    private final JdbcConsole getConsoleIfSupported(AnActionEvent $this$getConsoleIfSupported) {
        Project project = $this$getConsoleIfSupported.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)$this$getConsoleIfSupported.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file = virtualFile;
        JdbcConsole jdbcConsole = JdbcConsoleProvider.getConsole(project2, file);
        return jdbcConsole != null ? ProcessDbmsOutputAction.Companion.getIfSupported(jdbcConsole) : null;
    }

    @JvmStatic
    public static final void updateStateFor(@NotNull JdbcConsole console, boolean state) {
        Companion.updateStateFor(console, state);
    }

    @JvmStatic
    public static final void applySavedValue(@NotNull JdbcConsole console) {
        Companion.applySavedValue(console);
    }

    static {
        Key key = Key.create((String)"DBMS_LISTENER");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        dbmsListener = key;
        fileAttributes = new PerProjectFileAttributes("database.dbms.enabled.id", 0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011H\u0007R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/actions/ProcessDbmsOutputAction$Companion;", "", "<init>", "()V", "dbmsListener", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/database/actions/ProcessDbmsOutputAction$DBMSDataAuditor;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "fileAttributes", "Lcom/intellij/database/console/session/PerProjectFileAttributes;", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "Lcom/intellij/database/datagrid/DataRequest$Context;", "getConnection", "(Lcom/intellij/database/datagrid/DataRequest$Context;)Lcom/intellij/database/dataSource/DatabaseConnection;", "ifSupported", "Lcom/intellij/database/console/JdbcConsole;", "getIfSupported", "(Lcom/intellij/database/console/JdbcConsole;)Lcom/intellij/database/console/JdbcConsole;", "updateStateFor", "", "console", "state", "", "applySavedValue", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nProcessDbmsOutputAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/actions/ProcessDbmsOutputAction$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DatabaseConnection getConnection(@NotNull DataRequest.Context $this$connection) {
            Intrinsics.checkNotNullParameter((Object)$this$connection, (String)"<this>");
            DataProducer dataProducer = $this$connection.producer;
            JdbcEngine jdbcEngine = dataProducer instanceof JdbcEngine ? (JdbcEngine)dataProducer : null;
            return jdbcEngine != null ? jdbcEngine.getCurrentConnectionIfReady() : null;
        }

        private final JdbcConsole getIfSupported(JdbcConsole $this$ifSupported) {
            JdbcConsole jdbcConsole;
            JdbcConsole it = jdbcConsole = $this$ifSupported;
            boolean bl = false;
            return DbImplUtil.supportsDbmsOutput((Dbms)((DatabaseConnectionPoint)$this$ifSupported.getTarget()).getDbms()) ? jdbcConsole : null;
        }

        @JvmStatic
        public final void updateStateFor(@NotNull JdbcConsole console, boolean state) {
            Intrinsics.checkNotNullParameter((Object)((Object)console), (String)"console");
            if (this.getIfSupported(console) == null) {
                return;
            }
            if (state) {
                if (console.getUserData(dbmsListener) != null) {
                    return;
                }
                DBMSDataAuditor listener2 = new DBMSDataAuditor(console);
                Disposer.register((Disposable)((Disposable)console), (Disposable)listener2);
                console.getMessageBus().addAuditor((DataAuditor)listener2);
                console.putUserData(dbmsListener, listener2);
            } else {
                DBMSDataAuditor dBMSDataAuditor = (DBMSDataAuditor)console.getUserData(dbmsListener);
                if (dBMSDataAuditor != null) {
                    DBMSDataAuditor listener3 = dBMSDataAuditor;
                    boolean bl = false;
                    console.putUserData(dbmsListener, null);
                    Disposer.dispose((Disposable)listener3);
                }
            }
            PerProjectFileAttributes perProjectFileAttributes = fileAttributes;
            Project project = console.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = console.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"<get-virtualFile>(...)");
            SettingsUtilsKt.saveSettingValue("database.dbms.enabled.id", perProjectFileAttributes, project, virtualFile, state);
        }

        @JvmStatic
        public final void applySavedValue(@NotNull JdbcConsole console) {
            Intrinsics.checkNotNullParameter((Object)((Object)console), (String)"console");
            if (this.getIfSupported(console) == null) {
                return;
            }
            boolean defaultState = DatabaseSettings.getSettings().enableDbmsOutput;
            PerProjectFileAttributes perProjectFileAttributes = fileAttributes;
            Project project = console.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            VirtualFile virtualFile = console.getVirtualFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"<get-virtualFile>(...)");
            boolean value = SettingsUtilsKt.isSettingEnabled("database.dbms.enabled.id", perProjectFileAttributes, project, virtualFile, defaultState);
            this.updateStateFor(console, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0082\bJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/database/actions/ProcessDbmsOutputAction$DBMSDataAuditor;", "Lcom/intellij/database/datagrid/DataAuditor;", "Lcom/intellij/openapi/Disposable;", "console", "Lcom/intellij/database/console/JdbcConsole;", "<init>", "(Lcom/intellij/database/console/JdbcConsole;)V", "helper", "Lcom/intellij/database/actions/DbmsOutputHandler;", "handle", "", "context", "Lcom/intellij/database/datagrid/DataRequest$Context;", "call", "Lkotlin/Function0;", "beforeStatement", "requestFinished", "dispose", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nProcessDbmsOutputAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/actions/ProcessDbmsOutputAction$DBMSDataAuditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n40#1:183\n41#1:185\n40#1:186\n41#1:188\n1#2:182\n1#2:184\n1#2:187\n*S KotlinDebug\n*F\n+ 1 ProcessDbmsOutputAction.kt\ncom/intellij/database/actions/ProcessDbmsOutputAction$DBMSDataAuditor\n*L\n45#1:183\n45#1:185\n54#1:186\n54#1:188\n45#1:184\n54#1:187\n*E\n"})
    public static final class DBMSDataAuditor
    implements DataAuditor,
    Disposable {
        @NotNull
        private final DbmsOutputHandler helper;

        public DBMSDataAuditor(@NotNull JdbcConsole console) {
            Intrinsics.checkNotNullParameter((Object)((Object)console), (String)"console");
            Dbms dbms = ((DatabaseConnectionPoint)console.getTarget()).getDbms();
            this.helper = Intrinsics.areEqual((Object)dbms, (Object)Dbms.ORACLE) ? (DbmsOutputHandler)new OracleDbmsOutputHandler() : (Intrinsics.areEqual((Object)dbms, (Object)Dbms.DB2_LUW) ? (DbmsOutputHandler)new Db2DbmsOutputHandler() : (DbmsOutputHandler)DbmsOutputHandlerStub.INSTANCE);
        }

        private final void handle(DataRequest.Context context, Function0<Unit> call) {
            block2: {
                Object object;
                boolean $i$f$handle = false;
                Object object2 = this;
                try {
                    DBMSDataAuditor $this$handle_u24lambda_u240 = object2;
                    boolean bl = false;
                    call.invoke();
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) break block2;
                Object it = object = throwable;
                boolean bl = false;
                context.error((Throwable)it);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void beforeStatement(@NotNull DataRequest.Context context) {
            block3: {
                Object object;
                void this_$iv;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                DatabaseConnection databaseConnection = Companion.getConnection(context);
                if (databaseConnection == null) {
                    return;
                }
                DatabaseConnection connection = databaseConnection;
                DBMSDataAuditor dBMSDataAuditor = this;
                DataRequest.Context context$iv = context;
                boolean $i$f$handle = false;
                Object object2 = this_$iv;
                try {
                    DBMSDataAuditor $this$handle_u24lambda_u240$iv = (DBMSDataAuditor)object2;
                    boolean bl = false;
                    boolean bl2 = false;
                    DbmsOutputHandler.enable$default(this.helper, connection, 0, 2, null);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) break block3;
                Object it$iv = object = throwable;
                boolean bl = false;
                context$iv.error((Throwable)it$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void requestFinished(@NotNull DataRequest.Context context) {
            block7: {
                Object object;
                void this_$iv;
                Object $this$requestFinished_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                DatabaseConnection databaseConnection = Companion.getConnection(context);
                if (databaseConnection == null) {
                    return;
                }
                DatabaseConnection connection = databaseConnection;
                Object object2 = this;
                try {
                    $this$requestFinished_u24lambda_u240 = object2;
                    boolean bl = false;
                    ((DBMSDataAuditor)$this$requestFinished_u24lambda_u240).helper.processOutput(connection, (Function1<? super String, Unit>)((Function1)arg_0 -> DBMSDataAuditor.requestFinished$lambda$0$0(context, arg_0)));
                    $this$requestFinished_u24lambda_u240 = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl) {
                    $this$requestFinished_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = $this$requestFinished_u24lambda_u240;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Object it = $this$requestFinished_u24lambda_u240 = throwable;
                    boolean bl2 = false;
                    if (!(it instanceof SQLException)) {
                        context.error((Throwable)it);
                    }
                }
                Object it = object2;
                boolean bl = false;
                DBMSDataAuditor bl2 = this;
                DataRequest.Context context$iv = context;
                boolean $i$f$handle = false;
                Object object3 = this_$iv;
                try {
                    DBMSDataAuditor $this$handle_u24lambda_u240$iv = (DBMSDataAuditor)object3;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    this.helper.disable(connection);
                    object = Result.constructor-impl((Object)Unit.INSTANCE);
                }
                catch (Throwable bl3) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                }
                object3 = object;
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)object3);
                if (throwable2 == null) break block7;
                Object it$iv = object = throwable2;
                boolean bl5 = false;
                context$iv.error((Throwable)it$iv);
            }
        }

        public void dispose() {
        }

        private static final Unit requestFinished$lambda$0$0(DataRequest.Context $context, String line) {
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            $context.warn(line, true);
            return Unit.INSTANCE;
        }
    }
}

